/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.launch.RunGradleJvmTestLaunchRequestJob;
import org.eclipse.buildship.core.launch.RunGradleJvmTestMethodLaunchRequestJob;
import org.eclipse.buildship.ui.launch.EditorJavaElementResolver;
import org.eclipse.buildship.ui.launch.JavaElementNameCollector;
import org.eclipse.buildship.ui.launch.JavaElementResolver;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.launch.SelectionJavaElementResolver;
import org.eclipse.buildship.ui.launch.TestlaunchShortcutValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

public final class TestLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        SelectionJavaElementResolver resolver = SelectionJavaElementResolver.from(selection);
        this.launch(resolver);
    }

    public void launch(IEditorPart editor, String mode) {
        EditorJavaElementResolver resolver = EditorJavaElementResolver.from(editor);
        this.launch(resolver);
    }

    private void launch(JavaElementResolver resolver) {
        List<IMethod> methods = resolver.resolveMethods();
        if (TestlaunchShortcutValidator.validateMethods(methods)) {
            this.launchMethods(methods);
        } else {
            List<IType> types = resolver.resolveTypes();
            if (TestlaunchShortcutValidator.validateTypes(types)) {
                this.launchClasses(types);
            } else {
                this.showNoTestsFoundDialog();
            }
        }
    }

    private void launchMethods(List<IMethod> methods) {
        Map<String, Iterable<String>> methodNames = JavaElementNameCollector.collectClassNamesWithMethods(methods);
        IProject project = methods.get(0).getJavaProject().getProject();
        GradleRunConfigurationAttributes runConfigurationAttributes = this.collectRunConfigurationAttributes(project);
        new RunGradleJvmTestMethodLaunchRequestJob(methodNames, runConfigurationAttributes).schedule();
    }

    private void launchClasses(List<IType> types) {
        Iterable<String> typeNames = JavaElementNameCollector.collectClassNames(types);
        IProject project = types.get(0).getJavaProject().getProject();
        GradleRunConfigurationAttributes runConfigurationAttributes = this.collectRunConfigurationAttributes(project);
        new RunGradleJvmTestLaunchRequestJob(typeNames, runConfigurationAttributes).schedule();
    }

    private GradleRunConfigurationAttributes collectRunConfigurationAttributes(IProject project) {
        FixedRequestAttributes attributes = CorePlugin.projectConfigurationManager().readProjectConfiguration(project).getRequestAttributes();
        String projectDir = attributes.getProjectDir().getAbsolutePath();
        GradleDistribution gradleDistribution = attributes.getGradleDistribution();
        String gradleUserHome = attributes.getGradleUserHome() != null ? attributes.getGradleUserHome().getAbsolutePath() : null;
        String javaHome = attributes.getJavaHome() != null ? attributes.getJavaHome().getAbsolutePath() : null;
        List jvmArguments = attributes.getJvmArguments();
        List arguments = attributes.getArguments();
        boolean showExecutionView = true;
        boolean showConsoleView = false;
        return GradleRunConfigurationAttributes.with((List)ImmutableList.of(), (String)projectDir, (GradleDistribution)gradleDistribution, (String)gradleUserHome, (String)javaHome, (List)jvmArguments, (List)arguments, (boolean)showExecutionView, (boolean)showConsoleView);
    }

    private void showNoTestsFoundDialog() {
        CorePlugin.userNotification().errorOccurred(LaunchMessages.Test_Not_Found_Dialog_Title, LaunchMessages.Test_Not_Found_Dialog_Message, LaunchMessages.Test_Not_Found_Dialog_Details, 2, null);
    }
}

