/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal.deduplication;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingclient.internal.deduplication.DelegatingModelBuilder;
import com.gradleware.tooling.toolingclient.internal.deduplication.EclipseProjectDeduplicator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.connection.GradleConnection;
import org.gradle.tooling.connection.ModelResult;
import org.gradle.tooling.connection.ModelResults;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class DeduplicatingGradleConnection
implements GradleConnection {
    private final GradleConnection delegate;

    public DeduplicatingGradleConnection(GradleConnection delegate) {
        this.delegate = delegate;
    }

    public <T> ModelResults<T> getModels(Class<T> modelType) throws GradleConnectionException, IllegalStateException, IllegalArgumentException {
        return (ModelResults)this.models(modelType).get();
    }

    public <T> void getModels(Class<T> modelType, ResultHandler<? super ModelResults<T>> handler) throws IllegalStateException {
        this.models(modelType).get(handler);
    }

    public <T> ModelBuilder<ModelResults<T>> models(Class<T> modelType) throws GradleConnectionException, IllegalStateException, IllegalArgumentException {
        ModelBuilder models = this.delegate.models(modelType);
        if (modelType == EclipseProject.class) {
            DeduplicatingEclipseModelBuilder builder = new DeduplicatingEclipseModelBuilder((ModelBuilder<ModelResults<EclipseProject>>)models);
            return builder;
        }
        return models;
    }

    public BuildLauncher newBuild() {
        return this.delegate.newBuild();
    }

    public void close() {
        this.delegate.close();
    }

    private static class DeduplicatingEclipseModelBuilder
    extends DelegatingModelBuilder<ModelResults<EclipseProject>> {
        public DeduplicatingEclipseModelBuilder(ModelBuilder<ModelResults<EclipseProject>> delegate) {
            super(delegate);
        }

        @Override
        public ModelResults<EclipseProject> get() throws GradleConnectionException, IllegalStateException {
            ModelResults result = (ModelResults)super.get();
            return this.deduplicate((ModelResults<EclipseProject>)result);
        }

        @Override
        public void get(ResultHandler<? super ModelResults<EclipseProject>> handler) throws IllegalStateException {
            this.delegate.get((ResultHandler)new DeduplicatingResultHandler(handler));
        }

        private ModelResults<EclipseProject> deduplicate(ModelResults<EclipseProject> results) {
            return new DeduplicatedModelResults(results);
        }

        private static final class DeduplicatedModelResult
        implements ModelResult<EclipseProject> {
            private final ModelResult<EclipseProject> result;
            private final EclipseProject deduplicatedProject;

            DeduplicatedModelResult(ModelResult<EclipseProject> result, EclipseProject deduplicatedProject) {
                this.result = result;
                this.deduplicatedProject = deduplicatedProject;
            }

            public EclipseProject getModel() throws GradleConnectionException {
                return this.deduplicatedProject;
            }

            public GradleConnectionException getFailure() {
                return this.result.getFailure();
            }
        }

        private static final class DeduplicatedModelResults
        implements ModelResults<EclipseProject> {
            private final ModelResults<EclipseProject> delegate;

            public DeduplicatedModelResults(ModelResults<EclipseProject> delegate) {
                this.delegate = delegate;
            }

            public Iterator<ModelResult<EclipseProject>> iterator() {
                HashSet projects = Sets.newHashSet();
                for (ModelResult result : this.delegate) {
                    projects.add(result.getModel());
                }
                Set<EclipseProject> deduplicatedProjects = new EclipseProjectDeduplicator().deduplicate(projects);
                HashMap deduplicatedProjectsByProjectDir = Maps.newHashMap();
                for (EclipseProject deduplicatedProject : deduplicatedProjects) {
                    deduplicatedProjectsByProjectDir.put(deduplicatedProject.getProjectDirectory(), deduplicatedProject);
                }
                HashSet deduplicatedResults = Sets.newHashSet();
                for (ModelResult result : this.delegate) {
                    EclipseProject deduplicatedProject = (EclipseProject)deduplicatedProjectsByProjectDir.get(((EclipseProject)result.getModel()).getProjectDirectory());
                    deduplicatedResults.add(new DeduplicatedModelResult((ModelResult<EclipseProject>)result, deduplicatedProject));
                }
                return deduplicatedResults.iterator();
            }
        }

        private final class DeduplicatingResultHandler
        implements ResultHandler<ModelResults<EclipseProject>> {
            private final ResultHandler<? super ModelResults<EclipseProject>> delegate;

            private DeduplicatingResultHandler(ResultHandler<? super ModelResults<EclipseProject>> handler) {
                this.delegate = handler;
            }

            public void onComplete(ModelResults<EclipseProject> result) {
                this.delegate.onComplete((Object)DeduplicatingEclipseModelBuilder.this.deduplicate((ModelResults<EclipseProject>)result));
            }

            public void onFailure(GradleConnectionException failure) {
                this.delegate.onFailure(failure);
            }
        }
    }
}

