/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.projectimport.ProjectPreviewJob;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.AbstractProjectWizard;
import org.eclipse.buildship.ui.wizard.project.GradleOptionsWizardPage;
import org.eclipse.buildship.ui.wizard.project.GradleProjectWizardPage;
import org.eclipse.buildship.ui.wizard.project.GradleWelcomeWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectImportWizardController;
import org.eclipse.buildship.ui.wizard.project.ProjectPreviewWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.buildship.ui.wizard.project.WelcomePageContent;
import org.eclipse.buildship.ui.wizard.project.WelcomePageContentFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.ProgressListener;

public final class ProjectImportWizard
extends AbstractProjectWizard
implements IImportWizard {
    private static final String PROJECT_IMPORT_DIALOG_SETTINGS = "org.eclipse.buildship.ui.wizard.project.import";
    private static final String PREF_SHOW_WELCOME_PAGE = "org.eclipse.buildship.ui.wizard.project.import.showWelcomePage";
    private final GradleWelcomeWizardPage welcomeWizardPage;
    private final GradleProjectWizardPage gradleProjectPage;
    private final GradleOptionsWizardPage gradleOptionsPage;
    private final ProjectPreviewWizardPage projectPreviewPage;
    private final ProjectImportWizardController controller;

    public ProjectImportWizard() {
        this(ProjectImportWizard.getOrCreateDialogSection(UiPlugin.getInstance().getDialogSettings()), CorePlugin.publishedGradleVersions());
    }

    public ProjectImportWizard(IDialogSettings dialogSettings, PublishedGradleVersionsWrapper publishedGradleVersions) {
        super(PREF_SHOW_WELCOME_PAGE);
        this.setDialogSettings(dialogSettings);
        this.controller = new ProjectImportWizardController((IWizard)this);
        final ProjectImportConfiguration configuration = this.controller.getConfiguration();
        WelcomePageContent welcomePageContent = WelcomePageContentFactory.createImportWizardWelcomePageContent();
        this.welcomeWizardPage = new GradleWelcomeWizardPage(configuration, welcomePageContent);
        this.gradleProjectPage = new GradleProjectWizardPage(configuration);
        this.gradleOptionsPage = new GradleOptionsWizardPage(configuration, publishedGradleVersions);
        this.projectPreviewPage = new ProjectPreviewWizardPage(this.controller.getConfiguration(), new ProjectPreviewWizardPage.ProjectPreviewLoader(){

            @Override
            public Job loadPreview(FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuildStructure>> resultHandler, List<ProgressListener> listeners) {
                ProjectPreviewJob projectPreviewJob = new ProjectPreviewJob(configuration, listeners, AsyncHandler.NO_OP, resultHandler);
                projectPreviewJob.schedule();
                return projectPreviewJob;
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<String> workingSetNames = WorkingSetUtils.getSelectedWorkingSetNames(selection);
        if (!workingSetNames.isEmpty()) {
            this.controller.getConfiguration().setApplyWorkingSets(Boolean.valueOf(true));
            this.controller.getConfiguration().setWorkingSets(workingSetNames);
        }
    }

    public String getWindowTitle() {
        return ProjectWizardMessages.Title_GradleProjectWizardPage;
    }

    public void addPages() {
        if (this.isShowWelcomePage()) {
            this.addPage((IWizardPage)this.welcomeWizardPage);
        }
        this.addPage((IWizardPage)this.gradleProjectPage);
        this.addPage((IWizardPage)this.gradleOptionsPage);
        this.addPage((IWizardPage)this.projectPreviewPage);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
    }

    public boolean performFinish() {
        return this.controller.performImportProject(AsyncHandler.NO_OP, new UserDelegatedDescriptorHandler());
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.buildship.ui.projectimport";
    }

    private static IDialogSettings getOrCreateDialogSection(IDialogSettings dialogSettings) {
        IDialogSettings section = dialogSettings.getSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        if (section == null) {
            section = dialogSettings.addNewSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        }
        return section;
    }

    private final class UserDelegatedDescriptorHandler
    implements NewProjectHandler {
        private Boolean overwriteDescriptors;

        private UserDelegatedDescriptorHandler() {
        }

        public boolean shouldImport(OmniEclipseProject projectModel) {
            return true;
        }

        public boolean shouldOverwriteDescriptor(IProjectDescription descriptor, OmniEclipseProject projectModel) {
            if (this.overwriteDescriptors == null) {
                this.askUser();
            }
            return this.overwriteDescriptors;
        }

        public void afterImport(IProject project, OmniEclipseProject projectModel) {
        }

        private void askUser() {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog dialog = new MessageDialog(ProjectImportWizard.this.getShell(), ProjectWizardMessages.Existing_Descriptors_Overwrite_Dialog_Header, null, ProjectWizardMessages.Existing_Descriptors_Overwrite_Message, 3, new String[]{ProjectWizardMessages.Existing_Descriptors_Overwrite, ProjectWizardMessages.Existing_Descriptors_Keep}, 0);
                    int choice = dialog.open();
                    UserDelegatedDescriptorHandler.this.overwriteDescriptors = choice == 0;
                }
            });
        }
    }
}

