/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.oomph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DistributionType implements Enumerator
{
    GRADLE_WRAPPER(0, "GRADLE_WRAPPER", "GRADLE_WRAPPER"),
    LOCAL_INSTALLATION(1, "LOCAL_INSTALLATION", "LOCAL_INSTALLATION"),
    REMOTE_DISTRIBUTION(2, "REMOTE_DISTRIBUTION", "REMOTE_DISTRIBUTION"),
    SPECIFIC_GRADLE_VERSION(3, "SPECIFIC_GRADLE_VERSION", "SPECIFIC_GRADLE_VERSION");

    public static final String copyright = "Copyright (c) 2019 the original author or authors.\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n";
    public static final int GRADLE_WRAPPER_VALUE = 0;
    public static final int LOCAL_INSTALLATION_VALUE = 1;
    public static final int REMOTE_DISTRIBUTION_VALUE = 2;
    public static final int SPECIFIC_GRADLE_VERSION_VALUE = 3;
    private static final DistributionType[] VALUES_ARRAY;
    public static final List<DistributionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static DistributionType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DistributionType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static DistributionType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            DistributionType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static DistributionType get(int value) {
        switch (value) {
            case 0: {
                return GRADLE_WRAPPER;
            }
            case 1: {
                return LOCAL_INSTALLATION;
            }
            case 2: {
                return REMOTE_DISTRIBUTION;
            }
            case 3: {
                return SPECIFIC_GRADLE_VERSION;
            }
        }
        return null;
    }

    private DistributionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new DistributionType[]{GRADLE_WRAPPER, LOCAL_INSTALLATION, REMOTE_DISTRIBUTION, SPECIFIC_GRADLE_VERSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

