/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.buildship.ui.internal.util.editor.EditorUtils;
import org.eclipse.buildship.ui.internal.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.internal.view.task.OpenBuildScriptAction;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.SelectionDependentHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.gradle.tooling.model.gradle.GradleScript;

public final class OpenBuildScriptHandler
extends SelectionDependentHandler {
    @Override
    protected boolean isEnabledFor(NodeSelection selection) {
        return OpenBuildScriptAction.isEnabledForSelection(selection);
    }

    public Object execute(ExecutionEvent event) {
        NodeSelection selectionHistory = this.getSelectionHistory(event);
        for (ProjectNode projectNode : selectionHistory.toList(ProjectNode.class)) {
            Optional<File> buildScript = this.getBuildScriptFor(projectNode);
            if (!buildScript.isPresent()) continue;
            EditorUtils.openInInternalEditor((File)buildScript.get(), true);
        }
        return null;
    }

    private Optional<File> getBuildScriptFor(ProjectNode projectNode) {
        GradleScript buildScript = projectNode.getGradleProject().getBuildScript();
        return buildScript != null ? Optional.fromNullable((Object)buildScript.getSourceFile()) : Optional.absent();
    }
}

