/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ExecutorPolicy {
    public void onExecute(Runnable var1);

    public <T> T onExecute(Callable<T> var1) throws Exception;

    public void onStop();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CatchAndRecordFailures
    implements ExecutorPolicy {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorFactory.class);
        private final AtomicReference<Throwable> failure = new AtomicReference();

        @Override
        public void onExecute(Runnable command) {
            try {
                command.run();
            }
            catch (Throwable throwable) {
                this.onFailure(String.format("Failed to execute %s.", command), throwable);
            }
        }

        @Override
        public <T> T onExecute(Callable<T> command) throws Exception {
            try {
                return command.call();
            }
            catch (Exception exception) {
                this.onFailure(String.format("Failed to execute %s.", command), exception);
                throw exception;
            }
            catch (Throwable throwable) {
                this.onFailure(String.format("Failed to execute %s.", command), throwable);
                throw new UndeclaredThrowableException(throwable);
            }
        }

        public void onFailure(String message, Throwable throwable) {
            if (!this.failure.compareAndSet(null, throwable)) {
                LOGGER.error(message, throwable);
            }
        }

        @Override
        public void onStop() {
            Throwable failure = this.failure.getAndSet(null);
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }
    }
}

