/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.cybersecurity.test.diagram.CyberPABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class CyberPABDiagramTest
extends EmptyProject {
    protected TransactionalEditingDomainHelper tedHelper;
    private FunctionalPrimaryAsset fpa;
    private InformationPrimaryAsset ipa;
    private PrimaryAssetMember m1;
    private PrimaryAssetMember m2;

    protected void undoAllChanges() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(this.getRequiredTestModel());
        this.tedHelper = new TransactionalEditingDomainHelper(session.getTransactionalEditingDomain());
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        CyberPABDiagram diagram = CyberPABDiagram.createDiagram(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        String c1 = diagram.createBehaviorComponent("comp1", diagram.getDiagramId());
        String c2 = diagram.createBehaviorComponent("comp2", diagram.getDiagramId());
        String f1 = diagram.createFunction("f1", c1);
        String f2 = diagram.createFunction("f2", c2);
        diagram.createFunctionalExchange(f1, f2, "fe");
        CybersecurityServices services = new CybersecurityServices();
        this.executeCommand(() -> {
            this.fpa = services.createFunctionalPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            this.ipa = services.createInformationPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)diagram.getSemanticObjectMap().get(f1));
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)diagram.getSemanticObjectMap().get(f2));
            this.fpa.getOwnedMembers().add((Object)m1);
            this.fpa.getOwnedMembers().add((Object)m2);
        });
        diagram.insertPrimaryAsset((PrimaryAsset)this.fpa);
        DNode fpaNode = (DNode)diagram.getView((EObject)this.fpa);
        RGBValues fpaColor = ((Square)fpaNode.getStyle()).getColor();
        DNode f1Node = (DNode)diagram.getViewObjectMap().get(f1);
        DNode f2Node = (DNode)diagram.getViewObjectMap().get(f2);
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((Square)f2Node.getStyle()).getBorderColor());
        this.executeCommand(() -> this.fpa.getOwnedMembers().clear());
        this.executeCommand(() -> {
            ExchangeItem ei1 = InformationFactory.eINSTANCE.createExchangeItem();
            ExchangeItem ei2 = InformationFactory.eINSTANCE.createExchangeItem();
            DataPkg p1 = (DataPkg)context.getSemanticElement("dbaec066-1f9c-43e3-9ce1-b295c1e7fc8c");
            p1.getOwnedExchangeItems().add((Object)ei1);
            p1.getOwnedExchangeItems().add((Object)ei2);
            FunctionStorage f1Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f1Storage.getExchangedItems().add((Object)ei1);
            ((PhysicalFunction)diagram.getSemanticObjectMap().get("f1")).getOwnedExtensions().add((Object)f1Storage);
            FunctionStorage f2Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f2Storage.getExchangedItems().add((Object)ei1);
            ((PhysicalFunction)diagram.getSemanticObjectMap().get("f2")).getOwnedExtensions().add((Object)f2Storage);
            ((FunctionalExchange)diagram.getSemanticObjectMap().get("fe")).getExchangedItems().add((Object)ei2);
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)ei1);
            m2.setMember((ModelElement)ei2);
            this.ipa.getOwnedMembers().add((Object)m1);
            this.ipa.getOwnedMembers().add((Object)m2);
        });
        diagram.insertPrimaryAsset((PrimaryAsset)this.ipa);
        DNode ipaNode = (DNode)diagram.getView((EObject)this.ipa);
        RGBValues ipaColor = ((Square)ipaNode.getStyle()).getColor();
        DEdge feEdge = diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == diagram.getSemanticObjectMap().get("fe")).findFirst().get();
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((Square)f2Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((EdgeStyle)feEdge.getStyle()).getStrokeColor());
    }

    protected final void executeCommand(Runnable r) throws RollbackException, InterruptedException {
        this.tedHelper.executeCommand(r);
    }
}

