/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.test.common.BasicDynamicModelTest;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplate1;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplateLA;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplateOA;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplatePA;
import org.polarsys.capella.cybersecurity.test.common.ComponentTemplateSA;
import org.polarsys.capella.cybersecurity.test.common.ValidationHelpers;

public abstract class DynamicValidationTest
extends BasicDynamicModelTest {
    protected EnumerationPropertyType typeConfidentiality;
    protected EnumerationPropertyType typeAvailability;
    protected EnumerationPropertyType typeIntegrity;
    protected EnumerationPropertyType typeTraceability;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
        this.typeConfidentiality = CybersecurityQueries.getConfidentialityPropertyType((Project)this.project);
        this.typeAvailability = CybersecurityQueries.getAvailabilityPropertyType((Project)this.project);
        this.typeIntegrity = CybersecurityQueries.getIntegrityPropertyType((Project)this.project);
        this.typeTraceability = CybersecurityQueries.getTraceabilityPropertyType((Project)this.project);
    }

    protected IStatus ok(EObject e, String ruleID) throws InterruptedException {
        IStatus status = ValidationHelpers.validate(e, ruleID);
        if (!status.isOK()) {
            StatusManager.getManager().handle(status, 1);
            DynamicValidationTest.fail((String)status.getMessage());
        }
        return status;
    }

    protected void ok(IStatus s) {
        DynamicValidationTest.assertTrue((boolean)s.isOK());
    }

    protected void ko(IStatus s) {
        DynamicValidationTest.assertFalse((boolean)s.isOK());
    }

    protected IStatus ko(EObject e, String ruleID) throws InterruptedException {
        IStatus status = ValidationHelpers.validate(e, ruleID);
        DynamicValidationTest.assertFalse((String)"Validator returned unexpected OK Status", (boolean)status.isOK());
        return status;
    }

    protected ComponentTemplate1 createComponentTemplate(CapellaModelSkeleton skeleton, String architecture) {
        switch (architecture) {
            case "LA": {
                return new ComponentTemplateLA(skeleton, this);
            }
            case "SA": {
                return new ComponentTemplateSA(skeleton, this);
            }
            case "PA": {
                return new ComponentTemplatePA(skeleton, this);
            }
        }
        return new ComponentTemplateOA(skeleton, this);
    }
}

