/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.ui.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.ui.properties.controllers.AbstractMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.controllers.IMultipleSemanticFieldController;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.capella.cybersecurity.model.ThreatSourceUse;
import org.polarsys.capella.cybersecurity.ui.properties.sections.CyberMultipleSemanticField;

public abstract class CybersecuritySection
extends AbstractSection {
    protected CyberMultipleSemanticField widget;
    protected boolean showRealizations;

    public CybersecuritySection() {
        this(true);
    }

    public CybersecuritySection(boolean showRealizations) {
        this.showRealizations = showRealizations;
    }

    protected void addRealizedWidget(String label) {
        if (this.showRealizations) {
            this.widget = new CyberMultipleSemanticField((Composite)this.getReferencesGroup(), "", this.getWidgetFactory(), (IMultipleSemanticFieldController)this.getController());
            this.widget.setLabel(label);
            this.widget.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    protected void addUsedWidget(String label) {
        this.widget = new CyberMultipleSemanticField((Composite)this.getReferencesGroup(), "", this.getWidgetFactory(), (IMultipleSemanticFieldController)this.getController()){

            @Override
            protected void removeAllDataValue(final EObject object, final EStructuralFeature feature) {
                AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                    public void run() {
                        ArrayList containmentList = new ArrayList((List)object.eGet(feature));
                        for (EObject containedObject : containmentList) {
                            if (!(containedObject instanceof ThreatSourceUse)) continue;
                            1.deleteContainmentValue((EObject)containedObject);
                        }
                    }
                };
                this.executeCommand((ICommand)command);
            }
        };
        this.widget.setLabel(label);
        this.widget.setDisplayedInWizard(this.isDisplayedInWizard());
    }

    protected abstract AbstractMultipleSemanticFieldController getController();

    public void loadRealizedWidget(EObject capellaElement, EReference feature) {
        if (this.showRealizations) {
            this.widget.loadData(capellaElement, (EStructuralFeature)feature);
        }
    }

    public void addRealizedFields(List<AbstractSemanticField> fields) {
        if (this.showRealizations) {
            fields.add((AbstractSemanticField)this.widget);
        }
    }

    protected boolean isRealizedArchitecture(EObject capellaElement) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)capellaElement);
        BlockArchitectureExt.Type aType = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        return aType != BlockArchitectureExt.Type.OA && aType != BlockArchitectureExt.Type.EPBS;
    }
}

