/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.embeddededitor.listener;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.embeddededitor.commands.HelperCommands;
import org.polarsys.capella.scenario.editor.embeddededitor.helper.XtextEditorHelper;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;

public class EmbeddedEditorSessionListener
implements SessionManagerListener {
    private static ISelectionListener selectionListener;

    public void notify(Session session, int notification) {
    }

    public static ISelectionListener getSelectionListener() {
        if (selectionListener == null) {
            selectionListener = EmbeddedEditorSessionListener.createSelectionListener();
        }
        return selectionListener;
    }

    protected static ISelectionListener createSelectionListener() {
        return (part, selection) -> {
            if (part instanceof IWorkbenchPart) {
                DDiagram currentDiagram;
                DDiagramEditor dEditor;
                DDiagram diagram = null;
                if (part instanceof DDiagramEditor && (dEditor = (DDiagramEditor)part).getRepresentation() instanceof DDiagram) {
                    diagram = (DDiagram)dEditor.getRepresentation();
                }
                if (diagram instanceof SequenceDDiagram && ((SequenceDDiagram)diagram).getTarget() instanceof Scenario && ((currentDiagram = EmbeddedEditorInstance.getDDiagram()) == null || !currentDiagram.equals(diagram))) {
                    EmbeddedEditorSessionListener.updateLinkedTextualEditor(diagram);
                }
            }
        };
    }

    private static void updateLinkedTextualEditor(DDiagram diagram) {
        EmbeddedEditorInstance.setDDiagram((DDiagram)diagram);
        EmbeddedEditorView eeView = XtextEditorHelper.getActiveEmbeddedEditorView();
        if (eeView != null) {
            HelperCommands.refreshTextEditor(eeView);
        }
    }

    public void notifyAddSession(Session newSession) {
    }

    public void notifyRemoveSession(Session removedSession) {
        Session sessionForDiagram;
        DDiagram currentDiagram = EmbeddedEditorInstance.getDDiagram();
        if (currentDiagram != null && ((sessionForDiagram = SessionManager.INSTANCE.getSession((EObject)currentDiagram)) == null || removedSession.equals(sessionForDiagram))) {
            EmbeddedEditorSessionListener.updateLinkedTextualEditor(null);
        }
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }
}

