/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.sequencediag.ScenarioService;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.InteractionServices;
import org.polarsys.capella.core.sirius.analysis.OAServices;
import org.polarsys.capella.scenario.editor.EmbeddedEditorInstance;
import org.polarsys.capella.scenario.editor.helper.DataFlowHelper;
import org.polarsys.capella.scenario.editor.helper.SelectInvokedOperationModelForSharedDataAndEvent;

public class EmbeddedEditorInstanceHelper {
    public static final List<String> PARTICIPANT_KEYWORDS = Arrays.asList("actor", "entity", "role", "activity", "component", "configuration_item", "function");

    public static EList<InstanceRole> getAvailableInstanceRolesInDiagram() {
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return currentScenario.getOwnedInstanceRoles();
    }

    public static List<InstanceRole> getAvailableInstanceRoles() {
        List<String> participantKeywords = PARTICIPANT_KEYWORDS;
        ArrayList instanceRoles = new ArrayList();
        for (String keyword : participantKeywords) {
            if (!EmbeddedEditorInstanceHelper.checkValidKeyword(keyword)) continue;
            List availableInstanceRoleForKeyword = keyword.equals("function") || keyword.equals("activity") ? EmbeddedEditorInstanceHelper.getAvailableElements(keyword).stream().map(element -> ((AbstractFunction)element).getRepresentingInstanceRoles()).flatMap(Collection::stream).distinct().collect(Collectors.toList()) : EmbeddedEditorInstanceHelper.getAvailableElements(keyword).stream().map(element -> ((AbstractInstance)element).getRepresentingInstanceRoles()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            instanceRoles.addAll(availableInstanceRoleForKeyword);
        }
        return instanceRoles.stream().distinct().collect(Collectors.toList());
    }

    private static List<EObject> getAvailableAbstractInstances() {
        List<String> participantKeywords = PARTICIPANT_KEYWORDS;
        ArrayList<? extends EObject> instances = new ArrayList<EObject>();
        for (String keyword : participantKeywords) {
            if (!EmbeddedEditorInstanceHelper.checkValidKeyword(keyword)) continue;
            instances.addAll(EmbeddedEditorInstanceHelper.getAvailableElements(keyword));
        }
        return instances.stream().distinct().collect(Collectors.toList());
    }

    public static String getScenarioType() {
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return currentScenario.getKind().toString();
    }

    public static boolean isInteractionScenario() {
        Scenario scenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return scenario.getKind().equals((Object)ScenarioKind.INTERACTION);
    }

    public static boolean isInterfaceScenario() {
        Scenario scenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return scenario.getKind().equals((Object)ScenarioKind.INTERFACE);
    }

    public static boolean isESScenario() {
        Scenario scenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return scenario.getKind() == ScenarioKind.INTERACTION || scenario.getKind() == ScenarioKind.DATA_FLOW;
    }

    public static boolean isCEScenario() {
        return ScenarioExt.isDataFlowBehaviouralScenario((Scenario)EmbeddedEditorInstance.getAssociatedScenarioDiagram());
    }

    public static boolean isFEScenario() {
        return ScenarioExt.isDataFlowFunctionalScenario((Scenario)EmbeddedEditorInstance.getAssociatedScenarioDiagram());
    }

    public static boolean isFSScenario() {
        return ScenarioExt.isFunctionalScenario((Scenario)EmbeddedEditorInstance.getAssociatedScenarioDiagram());
    }

    public static AbstractFunction getSourceFunctionOfExchange(FunctionalExchange exchange) {
        if (exchange.getSource() instanceof AbstractFunction) {
            return (AbstractFunction)exchange.getSource();
        }
        FunctionOutputPort source = exchange.getSourceFunctionOutputPort();
        if (source != null && source.eContainer() instanceof AbstractFunction) {
            return (AbstractFunction)source.eContainer();
        }
        return null;
    }

    public static String getSourceFunctionNameOfExchange(FunctionalExchange exchange) {
        AbstractFunction function = EmbeddedEditorInstanceHelper.getSourceFunctionOfExchange(exchange);
        return function != null ? function.getName() : null;
    }

    public static AbstractFunction getTargetFunctionOfExchange(FunctionalExchange exchange) {
        if (exchange.getTarget() instanceof AbstractFunction) {
            return (AbstractFunction)exchange.getTarget();
        }
        FunctionInputPort target = exchange.getTargetFunctionInputPort();
        if (target != null && target.eContainer() instanceof AbstractFunction) {
            return (AbstractFunction)target.eContainer();
        }
        return null;
    }

    public static String getTargetFunctionNameOfExchange(FunctionalExchange exchange) {
        AbstractFunction function = EmbeddedEditorInstanceHelper.getTargetFunctionOfExchange(exchange);
        return function != null ? function.getName() : null;
    }

    public static EObject getScenarioLevel() {
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        return BlockArchitectureExt.getRootBlockArchitecture((EObject)currentScenario);
    }

    public static List<String> getExchangeNames(String source, String target) {
        ArrayList<String> messages = new ArrayList<String>();
        List<AbstractEventOperation> exchanges = EmbeddedEditorInstanceHelper.getAvailableExchanges(source, target);
        for (AbstractEventOperation exchange : exchanges) {
            if (EmbeddedEditorInstanceHelper.isInterfaceScenario()) {
                messages.add(((ExchangeItemAllocation)exchange).getAllocatedItem().getName());
                continue;
            }
            messages.add(exchange.getName());
        }
        return messages;
    }

    public static List<AbstractEventOperation> getExchangeMessages(String source, String target) {
        List<AbstractEventOperation> exchanges = EmbeddedEditorInstanceHelper.getAvailableExchanges(source, target);
        return exchanges;
    }

    public static List<AbstractEventOperation> getAvailableExchanges(String source, String target) {
        InstanceRole sourceIr = EmbeddedEditorInstanceHelper.getInstanceRoleFromScenario(source);
        InstanceRole targetIr = EmbeddedEditorInstanceHelper.getInstanceRoleFromScenario(target);
        if (sourceIr != null && targetIr != null) {
            return EmbeddedEditorInstanceHelper.getAllAvailableExchanges(sourceIr.getRepresentedInstance(), targetIr.getRepresentedInstance());
        }
        ArrayList<AbstractEventOperation> availableExchanges = new ArrayList<AbstractEventOperation>();
        List<EObject> sourceCandidates = EmbeddedEditorInstanceHelper.getAbstractInstanceCandidates(source);
        List<EObject> targetCandidates = EmbeddedEditorInstanceHelper.getAbstractInstanceCandidates(target);
        for (EObject sourceObj : sourceCandidates) {
            for (EObject targetObj : targetCandidates) {
                AbstractInstance sourceInst = sourceObj instanceof AbstractInstance ? (AbstractInstance)sourceObj : null;
                AbstractInstance targetInst = targetObj instanceof AbstractInstance ? (AbstractInstance)targetObj : null;
                availableExchanges.addAll(EmbeddedEditorInstanceHelper.getAllAvailableExchanges(sourceInst, targetInst));
            }
        }
        return availableExchanges;
    }

    private static List<AbstractEventOperation> getAllAvailableExchanges(AbstractInstance sourceInst, AbstractInstance targetInst) {
        List<Object> exchangesAvailable = new ArrayList<AbstractEventOperation>();
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        switch (currentScenario.getKind()) {
            case FUNCTIONAL: {
                if (!(sourceInst instanceof AbstractFunction) || !(targetInst instanceof AbstractFunction)) break;
                exchangesAvailable.addAll(DataFlowHelper.getAvailableFonctionalExchangesFromFunctions((AbstractFunction)sourceInst, (AbstractFunction)targetInst).stream().filter(x -> x instanceof AbstractEventOperation).collect(Collectors.toList()));
                break;
            }
            case INTERFACE: {
                List<CapellaElement> exchanges = SelectInvokedOperationModelForSharedDataAndEvent.getAvailableExchangeItems(sourceInst, targetInst, false);
                for (CapellaElement exchange : exchanges) {
                    if (!(exchange instanceof ExchangeItemAllocation)) continue;
                    exchangesAvailable.add((AbstractEventOperation)exchange);
                }
                break;
            }
            case DATA_FLOW: 
            case INTERACTION: {
                if (ScenarioExt.isFunctionalScenario((Scenario)currentScenario)) {
                    if (!(sourceInst instanceof AbstractFunction) || !(targetInst instanceof AbstractFunction)) break;
                    exchangesAvailable = DataFlowHelper.getAvailableFonctionalExchangesFromFunctions((AbstractFunction)sourceInst, (AbstractFunction)targetInst).stream().filter(x -> x instanceof AbstractEventOperation).collect(Collectors.toList());
                    break;
                }
                Component sourceComp = sourceInst != null && sourceInst.getAbstractType() instanceof Component ? (Component)sourceInst.getAbstractType() : null;
                Component targetComp = targetInst != null && targetInst.getAbstractType() instanceof Component ? (Component)targetInst.getAbstractType() : null;
                exchangesAvailable.addAll((List)DataFlowHelper.getAvailableComponentExchanges(sourceComp, targetComp));
                exchangesAvailable.addAll(DataFlowHelper.getAvailableFonctionalExchanges(sourceInst, targetInst).stream().filter(x -> x instanceof AbstractEventOperation).collect(Collectors.toList()));
                break;
            }
        }
        return exchangesAvailable;
    }

    public static List<String> getAvailablePartNames(String keyword) {
        ArrayList<String> partNames = new ArrayList<String>();
        Collection<? extends EObject> elements = EmbeddedEditorInstanceHelper.getAvailableElements(keyword);
        for (EObject eObject : elements) {
            if (!(eObject instanceof AbstractNamedElement)) continue;
            partNames.add(((AbstractNamedElement)eObject).getName());
        }
        return partNames;
    }

    private static Collection<? extends EObject> getAvailableAbstractFunctions() {
        Collection elements = FaServices.getFaServices().getAllAbstractFunctions(BlockArchitectureExt.getRootBlockArchitecture((EObject)EmbeddedEditorInstance.getAssociatedScenarioDiagram()));
        return elements;
    }

    private static Collection<? extends EObject> getAvailableComponents() {
        List elements = new InteractionServices().getESScopeInsertComponents(EmbeddedEditorInstance.getAssociatedScenarioDiagram());
        return elements;
    }

    private static Collection<? extends EObject> getAvailableActors() {
        List elements = new InteractionServices().getESScopeInsertActors(EmbeddedEditorInstance.getAssociatedScenarioDiagram());
        return elements;
    }

    private static Collection<? extends EObject> getAvailableRoles() {
        Collection elements = OAServices.getService().getOESScopeInsertEntitiesRoles(EmbeddedEditorInstance.getAssociatedScenarioDiagram()).stream().filter(x -> x instanceof Role).collect(Collectors.toList());
        return elements;
    }

    public static Collection<? extends EObject> getAvailableElements(String keyword) {
        switch (keyword) {
            case "activity": 
            case "function": {
                return EmbeddedEditorInstanceHelper.getAvailableAbstractFunctions();
            }
            case "role": {
                return EmbeddedEditorInstanceHelper.getAvailableRoles();
            }
            case "actor": {
                return EmbeddedEditorInstanceHelper.getAvailableActors();
            }
        }
        return EmbeddedEditorInstanceHelper.getAvailableComponents();
    }

    public static InstanceRole getInstanceRole(String source) {
        EList<InstanceRole> instanceRoles = EmbeddedEditorInstanceHelper.getAvailableInstanceRolesInDiagram();
        InstanceRole instanceRole = null;
        for (InstanceRole role : instanceRoles) {
            if (!role.getName().equals(source)) continue;
            instanceRole = role;
            break;
        }
        return instanceRole;
    }

    public static InstanceRole getInstanceRoleFromScenario(String source) {
        List<InstanceRole> instanceRoles = EmbeddedEditorInstanceHelper.getAvailableInstanceRoles();
        InstanceRole instanceRole = null;
        for (InstanceRole role : instanceRoles) {
            if (!role.getName().equals(source)) continue;
            instanceRole = role;
            break;
        }
        return instanceRole;
    }

    public static List<EObject> getAbstractInstanceCandidates(String name) {
        List<EObject> instances = EmbeddedEditorInstanceHelper.getAvailableAbstractInstances().stream().filter(inst -> inst instanceof AbstractNamedElement && ((AbstractNamedElement)inst).getName().equals(name)).collect(Collectors.toList());
        if (instances.isEmpty()) {
            instances.add(null);
        }
        return instances;
    }

    public static boolean checkValidKeyword(String keyword) {
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        BlockArchitecture blockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)currentScenario);
        if (currentScenario.getKind() == ScenarioKind.INTERACTION) {
            if (ScenarioExt.isFunctionalScenario((Scenario)currentScenario)) {
                return keyword.equals("activity");
            }
            return keyword.equals("entity") || keyword.equals("actor") || keyword.equals("role");
        }
        if (currentScenario.getKind() == ScenarioKind.INTERFACE || currentScenario.getKind() == ScenarioKind.DATA_FLOW) {
            if (blockArchitecture instanceof SystemAnalysis || blockArchitecture instanceof LogicalArchitecture || blockArchitecture instanceof PhysicalArchitecture) {
                return keyword.equals("actor") || keyword.equals("component");
            }
            if (blockArchitecture instanceof EPBSArchitecture) {
                return keyword.equals("configuration_item");
            }
        }
        if (currentScenario.getKind() == ScenarioKind.FUNCTIONAL && (blockArchitecture instanceof SystemAnalysis || blockArchitecture instanceof LogicalArchitecture || blockArchitecture instanceof PhysicalArchitecture)) {
            return keyword.equals("function");
        }
        return false;
    }

    public static boolean checkValidTimeline(String timelineName) {
        return timelineName != null && EmbeddedEditorInstanceHelper.getInstanceRoleFromScenario(timelineName) != null;
    }

    public static List<String> getAvailableStateFragments(String type, String timelineName) {
        if (timelineName == null || type == null) {
            return new ArrayList<String>();
        }
        InstanceRole element = EmbeddedEditorInstanceHelper.getInstanceRoleFromScenario(timelineName);
        if (element == null) {
            return new ArrayList<String>();
        }
        if (type.equals("function")) {
            return EmbeddedEditorInstanceHelper.getAllocatedFunctionsName((EObject)element);
        }
        Collection modesAndStates = ScenarioExt.getAvailableStateModeStateFragment((AbstractInstance)element.getRepresentedInstance());
        if (modesAndStates.isEmpty()) {
            return new ArrayList<String>();
        }
        if (type.equals("mode")) {
            return EmbeddedEditorInstanceHelper.getModesNames(modesAndStates);
        }
        return EmbeddedEditorInstanceHelper.getStatesNames(modesAndStates);
    }

    private static List<String> getModesNames(Collection<AbstractState> modesAndStates) {
        List<String> modesNames = modesAndStates.stream().filter(x -> x instanceof Mode).map(x -> x.getName()).collect(Collectors.toList());
        return modesNames;
    }

    private static List<String> getStatesNames(Collection<AbstractState> modesAndStates) {
        List<String> statesNames = modesAndStates.stream().filter(x -> x instanceof State && !(x instanceof Mode)).map(x -> x.getName()).collect(Collectors.toList());
        return statesNames;
    }

    private static List<String> getAllocatedFunctionsName(EObject element) {
        Collection allocFunctions = ScenarioExt.getAvailableFunctionsStateFragment((AbstractInstance)((InstanceRole)element).getRepresentedInstance());
        if (!allocFunctions.isEmpty()) {
            return allocFunctions.stream().map(x -> x.getName()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static void updateModel(String content) {
        XtextDocument document = EmbeddedEditorInstance.getEmbeddedEditor().getDocument();
        document.set(content);
        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource state) throws Exception {
            }
        });
    }

    public static void cleanUpModel() {
        EmbeddedEditorInstanceHelper.updateModel("");
    }

    public static String getModelContent() {
        XtextDocument document = EmbeddedEditorInstance.getEmbeddedEditor().getDocument();
        return document.get();
    }

    public static List<AbstractState> getStates(InstanceRole element) {
        Collection modesAndStates = ScenarioExt.getAvailableStateModeStateFragment((AbstractInstance)element.getRepresentedInstance());
        return modesAndStates.stream().filter(x -> x instanceof State && !(x instanceof Mode)).collect(Collectors.toList());
    }

    public static List<AbstractState> getModes(InstanceRole element) {
        Collection modesAndStates = ScenarioExt.getAvailableStateModeStateFragment((AbstractInstance)element.getRepresentedInstance());
        return modesAndStates.stream().filter(x -> x instanceof Mode).collect(Collectors.toList());
    }

    public static List<AbstractFunction> getAllocatedFunctions(InstanceRole element) {
        return ScenarioExt.getAvailableFunctionsStateFragment((AbstractInstance)element.getRepresentedInstance()).stream().collect(Collectors.toList());
    }

    public static String getStateFragmentType(StateFragment capellaStateFragment) {
        if (capellaStateFragment.getRelatedAbstractFunction() != null) {
            return "function";
        }
        if (capellaStateFragment.getRelatedAbstractState() != null && capellaStateFragment.getRelatedAbstractState() instanceof Mode) {
            return "mode";
        }
        return "state";
    }

    public static String getStateFragmentName(StateFragment capellaStateFragment) {
        if (capellaStateFragment.getRelatedAbstractFunction() != null) {
            return capellaStateFragment.getRelatedAbstractFunction().getName();
        }
        if (capellaStateFragment.getRelatedAbstractState() != null) {
            return capellaStateFragment.getRelatedAbstractState().getName();
        }
        return null;
    }

    private static List<DDiagram> getOpenedRepresentations() {
        ArrayList<DDiagram> diagrams = new ArrayList<DDiagram>();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            DDiagramEditor dEditor;
            DRepresentation representation;
            IEditorReference ref = iEditorReferenceArray[n2];
            IEditorPart editor = ref.getEditor(false);
            if (editor != null && editor instanceof DDiagramEditor && (representation = (dEditor = (DDiagramEditor)editor).getRepresentation()) instanceof DDiagram) {
                diagrams.add((DDiagram)representation);
            }
            ++n2;
        }
        return diagrams;
    }

    public static DDiagram getSelectedRepresentation() {
        DDiagramEditor dEditor;
        DRepresentation representation;
        IEditorPart editor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorReference activeEditor = (IEditorReference)activePage.getReference((IWorkbenchPart)activePage.getActiveEditor());
        if (activeEditor != null && (editor = activeEditor.getEditor(false)) != null && editor instanceof DDiagramEditor && (representation = (dEditor = (DDiagramEditor)editor).getRepresentation()) instanceof SequenceDDiagram) {
            return (DDiagram)representation;
        }
        return null;
    }

    public static void setOpenedRepresentation() {
        DDiagram diagram = EmbeddedEditorInstanceHelper.getSelectedRepresentation();
        EmbeddedEditorInstance.setDDiagram(diagram);
    }

    public static boolean isOpenedRepresentation() {
        List<DDiagram> diagrams = EmbeddedEditorInstanceHelper.getOpenedRepresentations();
        return diagrams.contains(EmbeddedEditorInstance.getDDiagram());
    }

    public static boolean isSelectedRepresentation() {
        DDiagram diagram = EmbeddedEditorInstanceHelper.getSelectedRepresentation();
        if (diagram instanceof SequenceDDiagram) {
            return diagram.equals(EmbeddedEditorInstance.getDDiagram());
        }
        return false;
    }

    public static void refreshAssociatedDiagram() {
        DDiagram diagram = EmbeddedEditorInstance.getDDiagram();
        if (diagram != null) {
            DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static List<String> getReferencedScenariosName() {
        return EmbeddedEditorInstanceHelper.getReferencedScenarios().stream().map(x -> ((Scenario)x).getName()).collect(Collectors.toList());
    }

    public static Scenario getScenarioWithGivenName(String name) {
        List referencedScenarios = EmbeddedEditorInstanceHelper.getReferencedScenarios().stream().filter(x -> ((Scenario)x).getName().equals(name)).collect(Collectors.toList());
        if (!referencedScenarios.isEmpty()) {
            return (Scenario)referencedScenarios.get(0);
        }
        return null;
    }

    public static List<EObject> getReferencedScenarios() {
        ScenarioService scenarioService = new ScenarioService();
        Scenario currentScenario = EmbeddedEditorInstance.getAssociatedScenarioDiagram();
        List referenceScope = scenarioService.getReferenceScope(currentScenario);
        return referenceScope;
    }
}

