/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.scenario.editor.ju.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.scenario.editor.embeddededitor.actions.RefreshAction;
import org.polarsys.capella.scenario.editor.embeddededitor.actions.SaveAction;
import org.polarsys.capella.scenario.editor.embeddededitor.helper.XtextEditorHelper;
import org.polarsys.capella.scenario.editor.embeddededitor.views.EmbeddedEditorView;
import org.polarsys.capella.scenario.editor.helper.EmbeddedEditorInstanceHelper;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.api.NonDirtyTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public abstract class TextualScenarioTestFramework
extends NonDirtyTestCase {
    public static final String simpleDiagramName = "[IS] CapabilityRealization 1 (Simple)";
    public static final String simpleFileContent = "[IS]_CapabilityRealization_1_Simple";
    protected String invalidContentErrMsg = "Invalid content in diagram {0}.\n Text expected in editor:\n{1}\nFound:\n{2}";
    protected String modelName = "TextualEditor";
    protected Session session;
    protected SessionContext context;

    protected void init() {
        this.session = this.getSession(this.modelName);
        this.context = new SessionContext(this.session);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        EmbeddedEditorView eeView = XtextEditorHelper.getActiveEmbeddedEditorView();
        if (eeView == null) {
            try {
                eeView = (EmbeddedEditorView)activePage.showView("org.eclipse.xtext.example.domainmodel.embeddededitor.views.EmbeddedEditorView");
            }
            catch (PartInitException e) {
                System.err.println("Cannot open Textual Editor View");
            }
            activePage.activate((IWorkbenchPart)eeView);
        }
    }

    protected void testLoadDiagram(String diagramName, String fileContentExpected) {
        this.openDiagram(diagramName);
        this.reloadDataFromDiagram();
        String expectedContent = this.readFile(fileContentExpected);
        this.checkValidContent(diagramName, expectedContent);
        DiagramContext simpleDiagram = (DiagramContext)new OpenDiagramStep(this.context, simpleDiagramName).run();
        TextualScenarioTestFramework.assertTrue((simpleDiagram != null ? 1 : 0) != 0);
        String simpleExpectedContent = this.readFile(simpleFileContent);
        this.checkValidContent(simpleDiagramName, simpleExpectedContent);
    }

    protected void testUpdateDiagram(String diagramName, String fileContent, String fileNewContent, List<String> expectedElements) {
        DiagramContext diagram = this.openDiagram(diagramName);
        EList elementsBeforeUpdate = diagram.getDiagram().getDiagramElements();
        String contentBeforeUpdate = this.readFile(fileContent);
        String newContent = this.readFile(fileNewContent);
        EmbeddedEditorInstanceHelper.updateModel((String)newContent);
        this.reloadDataFromDiagram();
        this.checkValidContent(diagramName, contentBeforeUpdate);
        EmbeddedEditorInstanceHelper.updateModel((String)newContent);
        this.saveDataToDiagram();
        this.reloadDataFromDiagram();
        this.checkValidContent(diagramName, newContent);
        ArrayList afterUpdateElements = new ArrayList();
        afterUpdateElements.addAll(diagram.getDiagram().getDiagramElements());
        afterUpdateElements.removeAll((Collection<?>)elementsBeforeUpdate);
        ArrayList newElements = new ArrayList();
        afterUpdateElements.forEach(x -> {
            EObject target = x.getTarget();
            if (target instanceof InstanceRole) {
                if (((InstanceRole)target).getRepresentedInstance().getAbstractType() != null) {
                    AbstractType type = ((InstanceRole)target).getRepresentedInstance().getAbstractType();
                    newElements.add(String.valueOf(EObjectLabelProviderHelper.getMetaclassLabel((EObject)type, (boolean)false)) + ":" + EObjectLabelProviderHelper.getText((Object)type));
                } else {
                    AbstractInstance instance = ((InstanceRole)target).getRepresentedInstance();
                    newElements.add(String.valueOf(EObjectLabelProviderHelper.getMetaclassLabel((EObject)instance, (boolean)false)) + ":" + EObjectLabelProviderHelper.getText((Object)instance));
                }
            } else if (target instanceof SequenceMessage) {
                SequenceMessage message = (SequenceMessage)target;
                InstanceRole sourceIr = message.getSendingEnd() == null ? null : message.getSendingEnd().getCovered();
                InstanceRole targetIr = message.getReceivingEnd() == null ? null : message.getReceivingEnd().getCovered();
                switch (message.getKind()) {
                    case CREATE: {
                        newElements.add(String.valueOf(sourceIr.getName()) + " ->+ " + targetIr.getName() + " : " + message.getName());
                        break;
                    }
                    case DELETE: {
                        newElements.add(String.valueOf(sourceIr.getName()) + " ->x " + targetIr.getName() + " : " + message.getName());
                        break;
                    }
                    case TIMER: {
                        newElements.add("->> " + targetIr.getName() + " : " + message.getName());
                        break;
                    }
                    default: {
                        if (sourceIr == null) {
                            newElements.add("o-> " + targetIr.getName() + " : " + message.getName());
                            break;
                        }
                        if (targetIr == null) {
                            newElements.add(String.valueOf(sourceIr.getName()) + " ->o : " + message.getName());
                            break;
                        }
                        newElements.add(String.valueOf(sourceIr.getName()) + " -> " + targetIr.getName() + " : " + message.getName());
                        break;
                    }
                }
            } else if (target instanceof StateFragment) {
                StateFragment fragment = (StateFragment)target;
                InstanceRole sourceIr = (InstanceRole)fragment.getStart().getCoveredInstanceRoles().get(0);
                String keyword = EmbeddedEditorInstanceHelper.getStateFragmentType((StateFragment)fragment);
                String stateName = fragment.getRelatedAbstractFunction() == null ? fragment.getRelatedAbstractState().getName() : fragment.getRelatedAbstractFunction().getName();
                String newElement = "on " + sourceIr.getName() + " " + keyword + " " + stateName;
                newElements.add(newElement);
            }
        });
        expectedElements.removeAll(newElements);
        StringBuilder sb = new StringBuilder();
        for (String data : expectedElements) {
            sb.append(data);
            sb.append("\n");
        }
        TextualScenarioTestFramework.assertTrue((String)("The following elements were not created:\n" + sb), (sb.length() == 0 ? 1 : 0) != 0);
        this.resetContent(diagramName, contentBeforeUpdate);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.modelName);
    }

    public void reloadDataFromDiagram() {
        RefreshAction action = new RefreshAction();
        action.run();
    }

    public void saveDataToDiagram() {
        SaveAction action = new SaveAction();
        action.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String readFile(String fileName) {
        String fileAsString = "";
        try {
            URL resolvedUrl = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("input/" + fileName));
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream is = new FileInputStream(resolvedUrl.getPath());
                try {
                    try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is));){
                        String line = buffer.readLine();
                        StringBuilder sb = new StringBuilder();
                        while (line != null) {
                            sb.append(line).append("\r\n");
                            line = buffer.readLine();
                        }
                        sb.setLength(sb.length() - 2);
                        fileAsString = sb.toString();
                    }
                    if (is == null) return fileAsString;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return fileAsString;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fileAsString;
    }

    protected DiagramContext openDiagram(String diagramName) {
        DiagramContext diagram = (DiagramContext)new OpenDiagramStep(this.context, diagramName).run();
        TextualScenarioTestFramework.assertTrue((diagram != null ? 1 : 0) != 0);
        EmbeddedEditorView textEditorView = XtextEditorHelper.getActiveEmbeddedEditorView();
        TextualScenarioTestFramework.assertTrue((textEditorView != null ? 1 : 0) != 0);
        return diagram;
    }

    protected void checkValidContent(String diagramName, String expectedContent) {
        String textEditorContent = EmbeddedEditorInstanceHelper.getModelContent();
        TextualScenarioTestFramework.assertTrue((String)NLS.bind((String)this.invalidContentErrMsg, (Object[])new String[]{diagramName, expectedContent, textEditorContent}), (boolean)expectedContent.replaceAll("\r\n", "\n").equals(textEditorContent));
    }

    protected void resetContent(String diagramName, String content) {
        EmbeddedEditorInstanceHelper.updateModel((String)content);
        this.saveDataToDiagram();
        this.reloadDataFromDiagram();
        this.checkValidContent(diagramName, content);
    }
}

