/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.common.ef.domain.AbstractEditingDomainResourceSetListenerImpl;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.access_Type;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class CSConfigurationListener
extends AbstractEditingDomainResourceSetListenerImpl {
    public CSConfigurationListener() {
        super(NotificationFilter.createNotifierTypeFilter((EClassifier)CsPackage.Literals.COMPONENT).and(NotificationFilter.createFeatureFilter((EStructuralFeature)EmdePackage.Literals.EXTENSIBLE_ELEMENT__OWNED_EXTENSIONS)));
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand result = null;
        ArrayList<CSConfiguration> addedConfigurations = new ArrayList<CSConfiguration>();
        for (Notification notif : event.getNotifications()) {
            if (notif.getEventType() == 3) {
                if (!(notif.getNewValue() instanceof CSConfiguration)) continue;
                addedConfigurations.add((CSConfiguration)notif.getNewValue());
                continue;
            }
            if (notif.getEventType() != 5) continue;
            for (Object o : (Collection)notif.getNewValue()) {
                if (!(o instanceof CSConfiguration)) continue;
                addedConfigurations.add((CSConfiguration)o);
            }
        }
        Map<EObject, List<CSConfiguration>> rootToConfigs = addedConfigurations.stream().collect(Collectors.groupingBy(t -> EcoreUtil.getRootContainer((EObject)t)));
        rootToConfigs.remove(null);
        result = new CompoundCommand();
        for (EObject root : rootToConfigs.keySet()) {
            Session session = SessionManager.INSTANCE.getSession(root);
            if (session == null) continue;
            String accessLiteral = Platform.getPreferencesService().getString("org.polarsys.capella.vp.ms.ui.preferences", "defaultConfigurationAccess", "", null);
            final access_Type access = access_Type.get((String)accessLiteral);
            final Collection added = rootToConfigs.get(root);
            result.append((Command)new RecordingCommand(event.getEditingDomain()){

                protected void doExecute() {
                    added.forEach(conf -> conf.setAccess(access));
                }
            });
        }
        return result;
    }

    public boolean isPrecommitOnly() {
        return true;
    }
}

