/*
 * Decompiled with CFR 0.152.
 */
package ms.configuration.services.cs;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ms.configuration.services.cs.Images;
import ms.configuration.services.cs.Messages;
import ms.configuration.services.cs.MsMappingConstants;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.EdgeMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.description.InstanceRoleMapping;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.Mode;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.BooleanOperation;
import org.polarsys.capella.vp.ms.CSConfiguration;
import org.polarsys.capella.vp.ms.Comparison;
import org.polarsys.capella.vp.ms.InStateExpression;
import org.polarsys.capella.vp.ms.MsFactory;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.Result;
import org.polarsys.capella.vp.ms.Situation;
import org.polarsys.capella.vp.ms.expression.parser.LinkedText2Situation;
import org.polarsys.capella.vp.ms.expression.parser.MsExpressionUnparser;
import org.polarsys.capella.vp.ms.provider.MsEditPlugin;
import org.polarsys.capella.vp.ms.selector_Type;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class CsConfigurationServices {
    public static final String DANNOTATION_SOURCE = "http://polarsys.org/capella/vp/ms";
    public static final String DANNOTATION_DETAIL_SHOW_CHILD_RELATIONS = "showChildRelations";
    public static final String DANNOTATION_DETAIL_SHOW_COMPONENTS = "showComponents";
    public static final String DANNOTATION_DETAIL_SHOW_FUNCTIONS = "showFunctions";
    public static final String DANNOTATION_DETAIL_SHOW_PORTS = "showPorts";
    public static final String DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS = "showFunctionalChains";
    public static final String DANNOTATION_DETAIL_SHOW_SCENARIOS = "showScenarios";
    private static final String CONFIGURATIONS_LAYER_LABEL = Messages.CsConfigurationServices_Configurations_Layer_Name;
    private static final Predicate<Component> HAS_STATEMACHINE = new Predicate<Component>(){

        @Override
        public boolean test(Component t) {
            return t.getOwnedStateMachines().size() > 0;
        }
    };
    protected List<CSConfiguration> configListFiltered = new ArrayList<CSConfiguration>();
    protected List<CSConfiguration> configList = new ArrayList<CSConfiguration>();

    private Map<CSConfiguration, DNode> getCurrentConfigNodeMap(DDiagram diagram) {
        HashMap<CSConfiguration, DNode> current = new HashMap<CSConfiguration, DNode>();
        for (DNode node : diagram.getNodes()) {
            if (!(node.getTarget() instanceof CSConfiguration)) continue;
            current.put((CSConfiguration)node.getTarget(), node);
        }
        return current;
    }

    private boolean isWizardCancelled(Object selection) {
        return !(selection instanceof Object[]);
    }

    public EObject msShowHideScenarioConfigurationsTool(Scenario sc, SequenceDDiagram diagram, Object selection) {
        return this.msShowHideScenarioConfigurationsTool(sc, diagram, null, null, selection);
    }

    public EObject msShowHideScenarioConfigurationsTool(InstanceRole ir, DNode irNode, Object selection) {
        return this.msShowHideScenarioConfigurationsTool((Scenario)ir.eContainer(), (SequenceDDiagram)irNode.getParentDiagram(), ir, irNode, selection);
    }

    private EObject msShowHideScenarioConfigurationsTool(Scenario scenario, SequenceDDiagram diagram, InstanceRole ir, DNode irNode, Object selection) {
        if (!this.isWizardCancelled(selection)) {
            Session session = SessionManager.INSTANCE.getSession((EObject)diagram);
            Map<CSConfiguration, DNode> shown = this.getCurrentConfigNodeMap((DDiagram)diagram);
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)diagram);
            Object[] objectArray = (Object[])selection;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                DNode node = shown.remove(o);
                if (node == null) {
                    NodeMapping nodeMapping = MsMappingConstants.getConfigurationNodeMapping(diagram);
                    node = new NodeMappingHelper(interpreter).createNode((INodeMappingExt)nodeMapping, (EObject)((CSConfiguration)o), (EObject)diagram, (DDiagram)diagram);
                    diagram.getOwnedDiagramElements().add((Object)node);
                }
                if (ir == null) {
                    for (DEdge in : node.getIncomingEdges()) {
                        if (!(in.getSourceNode() instanceof DSemanticDecorator) || !(in.getTarget() instanceof InstanceRole)) continue;
                        EcoreUtil.remove((EObject)in);
                    }
                } else {
                    EdgeMapping edgeMapping = MsMappingConstants.getInstanceRoleConfigurationEdgeMapping(diagram);
                    DEdge edge = new EdgeMappingHelper(interpreter).createEdge(edgeMapping, (EdgeTarget)irNode, (EdgeTarget)node, (EObject)diagram, (EObject)ir);
                    diagram.getOwnedDiagramElements().add((Object)edge);
                }
                ++n2;
            }
            for (Map.Entry<CSConfiguration, DNode> next : shown.entrySet()) {
                DEdge deleteEdge = null;
                boolean hasMoreEdges = false;
                for (DEdge incoming : next.getValue().getIncomingEdges()) {
                    if (!(incoming.getSourceNode() instanceof DSemanticDecorator) || !(((DSemanticDecorator)incoming.getSourceNode()).getTarget() instanceof InstanceRole)) continue;
                    if (incoming.getSourceNode() == irNode) {
                        deleteEdge = incoming;
                        continue;
                    }
                    hasMoreEdges = true;
                }
                if (irNode != null) {
                    if (deleteEdge == null) continue;
                    EcoreUtil.remove(deleteEdge);
                    if (hasMoreEdges) continue;
                    EcoreUtil.remove((EObject)((EObject)next.getValue()));
                    continue;
                }
                if (hasMoreEdges) continue;
                EcoreUtil.remove((EObject)((EObject)next.getValue()));
            }
        }
        return scenario;
    }

    public Collection<CSConfiguration> msScenarioInstanceRoleConfigurationFinder(InstanceRole context) {
        return this.getAllBlockConfigurationsSemantic((EObject)context);
    }

    public boolean msScenarioConfigurationSelectionPrecondition(EObject context) {
        boolean result = false;
        if (context instanceof DNode) {
            EObject semantic = ((DNode)context).getTarget();
            if (semantic instanceof InstanceRole && ((DNode)context).getActualMapping() instanceof InstanceRoleMapping) {
                result = true;
            }
        } else if (context instanceof SequenceDDiagram) {
            result = true;
        }
        return result;
    }

    public static boolean canCompleteChildConfigurationRelation(CSConfiguration source, CSConfiguration target) {
        AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source);
        IItemPropertySource propertySource = (IItemPropertySource)domain.getAdapterFactory().adapt((Notifier)source, IItemPropertySource.class);
        return propertySource.getPropertyDescriptor((Object)source, (Object)MsPackage.Literals.CS_CONFIGURATION__CHILD_CONFIGURATIONS).getChoiceOfValues((Object)source).contains(target);
    }

    public Collection<CSConfiguration> getOwnedConfigurations(EObject ele) {
        if (ele instanceof Component) {
            return this.getOwnedConfigurations((Component)ele);
        }
        if (ele instanceof Part) {
            return this.getOwnedConfigurations((EObject)((Part)ele).getType());
        }
        return Collections.emptyList();
    }

    public Collection<EObject> getIrregularEObject(EObject ele) {
        this.configList.clear();
        this.configListFiltered.clear();
        ArrayList<AbstractFunction> functionListIncluded = new ArrayList<AbstractFunction>();
        ArrayList<AbstractFunction> functionListExcluded = new ArrayList<AbstractFunction>();
        ArrayList<AbstractFunction> componentListIncluded = new ArrayList<AbstractFunction>();
        ArrayList<AbstractFunction> componentListExcluded = new ArrayList<AbstractFunction>();
        ArrayList<EObject> objectsIrregularList = new ArrayList<EObject>();
        Situation situCompare = null;
        if (ele instanceof Result) {
            Result result = (Result)ele;
            situCompare = (Situation)result.getSituation().get(0);
        }
        for (EObject iObj : situCompare.eContents()) {
            if (iObj instanceof BooleanOperation) {
                BooleanOperation booleanOperation = (BooleanOperation)iObj;
                EObject tObj = booleanOperation.eContainer();
                EObject vObj = tObj.eContainer();
                for (EObject jObj : vObj.eContents()) {
                    if (jObj instanceof CSConfiguration) {
                        if (this.configList.contains(jObj)) continue;
                        this.configList.add((CSConfiguration)jObj);
                        continue;
                    }
                    if (!(jObj instanceof Component)) continue;
                    for (EObject childComponent : ((Component)jObj).eContents()) {
                        if (!(childComponent instanceof CSConfiguration) || this.configList.contains(childComponent)) continue;
                        this.configList.add((CSConfiguration)childComponent);
                    }
                }
                for (EObject jObj : booleanOperation.eContents()) {
                    if (!(jObj instanceof InStateExpression)) continue;
                    for (CSConfiguration configObject : this.configList) {
                        for (AbstractState pObj : configObject.getSupportedModes()) {
                            Mode modeState;
                            if (((InStateExpression)jObj).getState() instanceof Mode) {
                                modeState = (Mode)((InStateExpression)jObj).getState();
                                if (!modeState.equals(pObj) || this.configListFiltered.contains(configObject)) continue;
                                this.configListFiltered.add(configObject);
                                continue;
                            }
                            if (!(((InStateExpression)jObj).getState() instanceof State) || !(modeState = (State)((InStateExpression)jObj).getState()).equals(pObj) || this.configListFiltered.contains(configObject)) continue;
                            this.configListFiltered.add(configObject);
                        }
                    }
                }
            }
            for (CSConfiguration cSConfiguration : this.configListFiltered) {
                for (AbstractFunction jObj : cSConfiguration.getFunctions()) {
                    cSConfiguration.getSelector();
                    if (cSConfiguration.getSelector().equals((Object)selector_Type.INCLUSION)) {
                        functionListIncluded.add(jObj);
                        continue;
                    }
                    functionListExcluded.add(jObj);
                }
                for (AbstractFunction jObj : cSConfiguration.getFunctionalChains()) {
                    cSConfiguration.getSelector();
                    if (cSConfiguration.getSelector().equals((Object)selector_Type.INCLUSION)) {
                        for (AbstractFunction tObj : jObj.getInvolvedFunctions()) {
                            functionListIncluded.add(tObj);
                        }
                        continue;
                    }
                    for (AbstractFunction tObj : jObj.getInvolvedFunctions()) {
                        functionListExcluded.add(tObj);
                    }
                }
                for (AbstractFunction jObj : cSConfiguration.getComponents()) {
                    cSConfiguration.getSelector();
                    if (cSConfiguration.getSelector().equals((Object)selector_Type.INCLUSION)) {
                        componentListIncluded.add(jObj);
                        continue;
                    }
                    componentListExcluded.add(jObj);
                }
            }
            for (AbstractFunction abstractFunction : functionListIncluded) {
                if (!functionListExcluded.contains(abstractFunction)) continue;
                objectsIrregularList.add((EObject)abstractFunction);
            }
            for (Component component : componentListIncluded) {
                if (!componentListExcluded.contains(component)) continue;
                objectsIrregularList.add((EObject)component);
            }
        }
        return objectsIrregularList;
    }

    public Collection<CSConfiguration> getOwnedConfigurations(Component component) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        for (ElementExtension extension : component.getOwnedExtensions()) {
            if (!(extension instanceof CSConfiguration)) continue;
            result.add((CSConfiguration)extension);
        }
        return result;
    }

    public Collection<EObject> getTheConfiguration(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        ArrayList<AbstractState> modeCompareList = new ArrayList<AbstractState>();
        this.configList.clear();
        if (ele instanceof Comparison) {
            Situation situMode = (Situation)((Comparison)ele).getSituation().get(0);
            for (EObject iObj : situMode.eContents()) {
                if (!(iObj instanceof BooleanOperation)) continue;
                BooleanOperation boolObj = (BooleanOperation)iObj;
                EObject tObj = boolObj.eContainer();
                EObject vObj = tObj.eContainer();
                for (EObject jObj : vObj.eContents()) {
                    if (jObj instanceof CSConfiguration) {
                        if (this.configList.contains(jObj)) continue;
                        this.configList.add((CSConfiguration)jObj);
                        continue;
                    }
                    if (!(jObj instanceof Component)) continue;
                    for (EObject childComponent : ((Component)jObj).eContents()) {
                        if (!(childComponent instanceof CSConfiguration) || this.configList.contains(childComponent)) continue;
                        this.configList.add((CSConfiguration)childComponent);
                    }
                }
                for (EObject jObj : boolObj.eContents()) {
                    if (!(jObj instanceof InStateExpression) || !(((InStateExpression)jObj).getState() instanceof AbstractState)) continue;
                    modeCompareList.add(((InStateExpression)jObj).getState());
                }
            }
            CSConfiguration premConfig = (CSConfiguration)((Comparison)ele).getConfiguration1().get(0);
            for (CSConfiguration csc : this.configList) {
                if (csc.equals(premConfig)) continue;
                for (AbstractState mode : csc.getSupportedModes()) {
                    if (!modeCompareList.contains(mode)) continue;
                    for (ModelElement iObj : premConfig.getElements()) {
                        if (!csc.getElements().contains((Object)iObj)) continue;
                        result.add((EObject)iObj);
                    }
                }
            }
        }
        return result;
    }

    public Collection<EObject> getTheAbstractState(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (ele instanceof Comparison) {
            CSConfiguration csc = (CSConfiguration)((Comparison)ele).getConfiguration1().get(0);
            for (ModelElement iObj : csc.getElements()) {
                result.add((EObject)iObj);
            }
        }
        return result;
    }

    public String getConfigurationIrregular(EObject ele) {
        String result = "";
        for (CSConfiguration confEle : this.configListFiltered) {
            for (AbstractFunction jObj : confEle.getFunctions()) {
                if (!jObj.equals(ele)) continue;
                result = result.length() == 0 ? confEle.getName() : String.valueOf(result) + "; " + confEle.getName();
            }
        }
        return result;
    }

    public String getElementsIrregular(EObject ele) {
        return "X";
    }

    public boolean verifCell(EObject ele) {
        return ele instanceof EObject;
    }

    public List<EObject> getOwnedConfigurationsFromType(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (ele instanceof Component) {
            Component cmp = (Component)ele;
            EList extensions = cmp.getOwnedExtensions();
            ArrayList<CSConfiguration> configurations = new ArrayList<CSConfiguration>();
            for (ElementExtension extension : extensions) {
                if (!(extension instanceof CSConfiguration)) continue;
                configurations.add((CSConfiguration)extension);
            }
            result.addAll(configurations);
        }
        return result;
    }

    public List<EObject> getConfigurationFromElement(EObject ele) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)ele);
        Collection refs = domain.getCrossReferencer().getInverseReferences(ele, MsPackage.Literals.CS_CONFIGURATION__ELEMENTS, true);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : refs) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public Collection<EObject> getConfigurationsFromMode(AbstractState state) {
        SemanticEditingDomainFactory.SemanticEditingDomain domain = (SemanticEditingDomainFactory.SemanticEditingDomain)TransactionUtil.getEditingDomain((EObject)state);
        Collection refs = domain.getCrossReferencer().getInverseReferences((EObject)state, MsPackage.Literals.CS_CONFIGURATION__SUPPORTED_MODES, true);
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EStructuralFeature.Setting setting : refs) {
            result.add(setting.getEObject());
        }
        return result;
    }

    public Collection<EObject> getConfigurationsFromEObject(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(ele);
        return result;
    }

    public Collection<EObject> getConfigurationsFromModesandStates(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(ele);
        return result;
    }

    public static boolean isConfigurationsLayerActive(DDiagram diag) {
        for (Layer l : diag.getActivatedLayers()) {
            if (!CONFIGURATIONS_LAYER_LABEL.equals(l.getLabel())) continue;
            return true;
        }
        return false;
    }

    private void getSelectedConfigurationsImpl(AbstractDNode view, boolean includeParents, Collection<CSConfiguration> result) {
        AbstractDNode current = view;
        for (DNode dNode : current.getOwnedBorderedNodes()) {
            if (!(dNode.getTarget() instanceof CSConfiguration)) continue;
            result.add((CSConfiguration)dNode.getTarget());
        }
        if (view.getTarget() instanceof InstanceRole) {
            for (DEdge edge : ((EdgeTarget)view).getOutgoingEdges()) {
                if (!(edge.getTargetNode() instanceof DNode) || !(((DNode)edge.getTargetNode()).getTarget() instanceof CSConfiguration)) continue;
                result.add((CSConfiguration)((DNode)edge.getTargetNode()).getTarget());
            }
        }
        if (includeParents) {
            if (current.eContainer() instanceof AbstractDNode) {
                this.getSelectedConfigurationsImpl((AbstractDNode)current.eContainer(), includeParents, result);
            } else if (current.eContainer() instanceof DSemanticDiagram) {
                this.getSelectedConfigurationsImpl((DSemanticDiagram)current.eContainer(), result);
            }
        }
    }

    public Collection<CSConfiguration> getSelectedConfigurations(AbstractDNode view, boolean includeParents) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        this.getSelectedConfigurationsImpl(view, includeParents, result);
        return result;
    }

    public Collection<CSConfiguration> getSelectedConfigurations(DSemanticDiagram diagram) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        this.getSelectedConfigurationsImpl(diagram, result);
        return result;
    }

    public Collection<CSConfiguration> getSelectedConfigurations(AbstractDNode node) {
        return this.getSelectedConfigurations(node, false);
    }

    private void getSelectedConfigurationsImpl(DSemanticDiagram diagram, Collection<CSConfiguration> result) {
        for (DDiagramElement de : diagram.getOwnedDiagramElements()) {
            if (!(de.getTarget() instanceof CSConfiguration)) continue;
            boolean include = true;
            if (de instanceof EdgeTarget) {
                for (DEdge edge : ((DNode)de).getIncomingEdges()) {
                    if (!(edge.getSourceNode() instanceof DSemanticDecorator) || !(((DSemanticDecorator)edge.getSourceNode()).getTarget() instanceof InstanceRole)) continue;
                    include = false;
                }
            }
            if (!include) continue;
            result.add((CSConfiguration)de.getTarget());
        }
    }

    public List<EObject> getNotSelectedConfigurations(EObject view, List<EObject> selection) {
        if (view instanceof DNodeContainer) {
            return this.getNotSelectedConfigurations((DNodeContainer)view, selection);
        }
        if (view instanceof DDiagram) {
            return this.getNotSelectedConfigurations((DDiagram)view, selection);
        }
        throw new IllegalArgumentException();
    }

    private List<EObject> getNotSelectedConfigurations(DNodeContainer view, List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DNode dNode : view.getOwnedBorderedNodes()) {
            if (!(dNode.getTarget() instanceof CSConfiguration) || selection.contains(dNode.getTarget())) continue;
            result.add((EObject)dNode);
        }
        return result;
    }

    private List<EObject> getNotSelectedConfigurations(DDiagram diagram, List<EObject> selection) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (DDiagramElement element : diagram.getOwnedDiagramElements()) {
            if (!(element.getTarget() instanceof CSConfiguration) || selection.contains(element.getTarget())) continue;
            result.add((EObject)element);
        }
        return result;
    }

    public Collection<CSConfiguration> getSelectableConfigurations(DSemanticDiagram diagram) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        EObject c = diagram.getTarget();
        while (c instanceof Component) {
            result.addAll(this.getOwnedConfigurations((Component)c));
            c = c.eContainer();
        }
        return result;
    }

    public Collection<CSConfiguration> getAllBlockConfigurationsSemantic(EObject semantic) {
        ArrayList<CSConfiguration> result = new ArrayList<CSConfiguration>();
        BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)semantic);
        if (ba != null) {
            result.addAll(EObjectExt.getAll((EObject)ba, (EClass)MsPackage.Literals.CS_CONFIGURATION));
        }
        return result;
    }

    public Collection<CSConfiguration> getAllBlockConfigurations(DSemanticDecorator decorator) {
        return this.getAllBlockConfigurationsSemantic(decorator.getTarget());
    }

    public boolean isDiagram(EObject e) {
        return e instanceof DSemanticDiagram;
    }

    public Collection<CSConfiguration> getSelectableConfigurations(DNodeContainer container) {
        Collection<CSConfiguration> result = Collections.emptyList();
        Component comp = null;
        if (container.getTarget() instanceof Component) {
            comp = (Component)container.getTarget();
        } else if (container.getTarget() instanceof Part && ((Part)container.getTarget()).getType() instanceof Component) {
            comp = (Component)((Part)container.getTarget()).getType();
        }
        if (comp != null) {
            result = this.getOwnedConfigurations(comp);
        }
        return result;
    }

    public boolean msStyleCustomizationPredicate(ModelElement context, DDiagramElement view) {
        return false;
    }

    public int disabledElementColor(ModelElement context, DDiagramElement view) {
        boolean isComponent = (context instanceof Part ? ((Part)context).getType() : context) instanceof Component;
        if (isComponent) {
            return 200;
        }
        return 220;
    }

    public static boolean isConsistentIncludeRequired() {
        return Platform.getPreferencesService().getBoolean("org.polarsys.capella.vp.ms.ui.preferences", "defaultConsistentIncludeRequired", true, null);
    }

    public static boolean isMarkConflictingInclusions() {
        return Platform.getPreferencesService().getBoolean("org.polarsys.capella.vp.ms.ui.preferences", "defaultMarkConflicts", true, null);
    }

    public boolean isShowDisabledPortOverlay(ModelElement context, DDiagramElement view) {
        throw new UnsupportedOperationException("Overlays not working with Capella 1.2.1, see https://bugs.polarsys.org/show_bug.cgi?id=2115");
    }

    public int disabledElementLabelColor(ModelElement context, DDiagramElement view) {
        return 120;
    }

    public String disabledElementWorkspacePathImage(ModelElement context, DDiagramElement view) {
        return Images.getImagePath((EObject)context, view);
    }

    public CSConfiguration createConfiguration(EObject context) {
        Component cmp = null;
        if (context instanceof Component) {
            cmp = (Component)context;
        } else if (context instanceof Part && ((Part)context).getType() instanceof Component) {
            cmp = (Component)((Part)context).getType();
        } else {
            BlockArchitecture ba = BlockArchitectureExt.getRootBlockArchitecture((EObject)context);
            Iterator roots = BlockArchitectureExt.getRootComponents((BlockArchitecture)ba).iterator();
            if (roots.hasNext()) {
                cmp = (Component)roots.next();
            }
        }
        if (cmp != null) {
            CSConfiguration configuration = MsFactory.eINSTANCE.createCSConfiguration();
            cmp.getOwnedExtensions().add((Object)configuration);
            this.msCreationService(configuration);
            return configuration;
        }
        return null;
    }

    public boolean canEditStateConfiguration(EObject state) {
        return !(state instanceof FinalState);
    }

    public List<AbstractFunction> getAllocatedFunctions(EObject component) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        if (component instanceof Component) {
            result.addAll((Collection<AbstractFunction>)((Component)component).getAllocatedFunctions());
        }
        return result;
    }

    public Collection<?> msCrossTableFunctionalChains(DTable table, Component component) {
        return this.msCrossTableElements(table, component, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__FUNCTIONAL_CHAINS);
    }

    public Collection<?> msCrossTableScenarios(DTable table, Component component) {
        return this.msCrossTableElements(table, component, (EStructuralFeature)MsPackage.Literals.CS_CONFIGURATION__SCENARIOS);
    }

    private Collection<?> msCrossTableElements(DTable table, Component component, EStructuralFeature feature) {
        if (!CsConfigurationServices.isShowScenarios(table)) {
            return Collections.emptyList();
        }
        if (this.getOwnedConfigurations(component).isEmpty()) {
            return Collections.emptyList();
        }
        CSConfiguration configuration = this.getOwnedConfigurations(component).iterator().next();
        AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)configuration);
        IItemPropertySource propertySource = (IItemPropertySource)domain.getAdapterFactory().adapt((Notifier)configuration, IItemPropertySource.class);
        IItemPropertyDescriptor descriptor = propertySource.getPropertyDescriptor((Object)configuration, (Object)feature);
        return new LinkedHashSet(descriptor.getChoiceOfValues((Object)configuration));
    }

    public void msCreationService(CSConfiguration configuration) {
        CapellaElementExt.creationService((EObject)configuration, (String)MsEditPlugin.INSTANCE.getString("_UI_CSConfiguration_type"));
    }

    public Collection<InputPin> msInputs(DTable table, AbstractFunction function) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return function.getInputs();
        }
        return Collections.emptyList();
    }

    public Collection<OutputPin> msOutputs(DTable table, AbstractFunction function) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return function.getOutputs();
        }
        return Collections.emptyList();
    }

    public Collection<AbstractFunction> msAllocatedFunctions(DTable table, Component component) {
        if (CsConfigurationServices.isShowFunctions(table)) {
            return component.getAllocatedFunctions();
        }
        return Collections.emptyList();
    }

    public Collection<EObject> msCrossTableComponentLines(LogicalComponent c) {
        return c.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, (Predicate<Component>)Predicates.alwaysTrue())).collect(Collectors.toList());
    }

    public Collection<EObject> msCrossTableComponentLines(LogicalComponentPkg p) {
        return p.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, (Predicate<Component>)Predicates.alwaysTrue())).collect(Collectors.toList());
    }

    public Collection<EObject> msCrossTableComponentLines(PhysicalComponentPkg p) {
        return p.getOwnedPhysicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, (Predicate<Component>)Predicates.alwaysTrue())).collect(Collectors.toList());
    }

    public Collection<? extends EObject> msContainedComponentPorts(DTable table, Component component) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return component.getContainedComponentPorts();
        }
        return Collections.emptyList();
    }

    public Collection<PhysicalPort> msContainedPhysicalPorts(DTable table, Component component) {
        if (CsConfigurationServices.isShowPorts(table)) {
            return component.getContainedPhysicalPorts();
        }
        return Collections.emptyList();
    }

    public Collection<Component> msComponentRoot(DTable table, Component component) {
        if (CsConfigurationServices.isShowComponents(table)) {
            return Collections.singletonList(component);
        }
        return Collections.emptyList();
    }

    public static boolean isShowChildConfigurationRelationships(DDiagram diagram) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)diagram, DANNOTATION_DETAIL_SHOW_CHILD_RELATIONS, true);
    }

    public static void setShowChildConfigurationRelationships(DDiagram diagram, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)diagram, DANNOTATION_DETAIL_SHOW_CHILD_RELATIONS, b);
    }

    public static void setShowComponents(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENTS, b);
    }

    public static boolean isShowComponents(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_COMPONENTS, true);
    }

    public static void setShowFunctions(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONS, b);
    }

    public static boolean isShowFunctions(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONS, true);
    }

    public static void setShowPorts(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_PORTS, b);
    }

    public static boolean isShowPorts(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_PORTS, true);
    }

    public static void setShowFunctionalChains(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS, b);
    }

    public static boolean isShowFunctionalChains(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_FUNCTIONAL_CHAINS, true);
    }

    public static boolean isShowScenarios(DTable table) {
        return CsConfigurationServices.isAnnotationDetailSet((DModelElement)table, DANNOTATION_DETAIL_SHOW_SCENARIOS, true);
    }

    public static void setShowScenarios(DTable table, boolean b) {
        CsConfigurationServices.setAnnotationDetail((DModelElement)table, DANNOTATION_DETAIL_SHOW_SCENARIOS, b);
    }

    private static boolean isAnnotationDetailSet(DModelElement element, String key, boolean defaultValue) {
        DAnnotation annot = CsConfigurationServices.getAnnotation(element, DANNOTATION_SOURCE, false);
        if (annot != null && annot.getDetails().containsKey((Object)key)) {
            return Boolean.valueOf((String)annot.getDetails().get((Object)key));
        }
        return defaultValue;
    }

    private static void setAnnotationDetail(DModelElement element, String key, boolean value) {
        DAnnotation annot = CsConfigurationServices.getAnnotation(element, DANNOTATION_SOURCE, true);
        annot.getDetails().put((Object)key, (Object)String.valueOf(value));
    }

    private static DAnnotation getAnnotation(DModelElement element, String source, boolean create) {
        DAnnotation result = element.getDAnnotation(source);
        if (result == null && create) {
            result = DescriptionFactory.eINSTANCE.createDAnnotation();
            result.setSource(source);
            element.getEAnnotations().add((Object)result);
        }
        return result;
    }

    public boolean msConfigurationNodeCreationPrecondition(EObject container) {
        return container instanceof Component | container instanceof Part;
    }

    public String msSituationExpression(StateMachine row, Situation situation, DLine line, DColumn column) {
        LinkedText2Situation.SplitExpression split = LinkedText2Situation.SplitExpression.of((BooleanExpression)situation.getExpression());
        BooleanExpression expression = (BooleanExpression)split.get((Object)row);
        if (expression == null) {
            return "";
        }
        String label = new MsExpressionUnparser(MsExpressionUnparser.Mode.NAME).unparse(expression);
        return LinkedTextDocument.load((LinkedTextDocument.Input)new CapellaEmbeddedLinkedTextEditorInput.Readonly((EObject)row, label)).get();
    }

    public Collection<Situation> msAllSituations(EObject context) {
        ArrayList<Situation> result = new ArrayList<Situation>();
        ComponentArchitecture architecture = (ComponentArchitecture)EcoreUtil2.getFirstContainer((EObject)context, (EClass)CsPackage.Literals.COMPONENT_ARCHITECTURE);
        EObject rootPkg = null;
        if (architecture != null) {
            for (EObject e : architecture.eContents()) {
                if (!(e instanceof ComponentPkg)) continue;
                rootPkg = e;
                break;
            }
        }
        if (rootPkg != null) {
            TreeIterator it = rootPkg.eAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (!(next instanceof Situation)) continue;
                result.add((Situation)next);
            }
        }
        return result;
    }

    public Collection<EObject> msSituationExpressionComponentLines(LogicalComponent c) {
        return c.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msSituationExpressionComponentLines(LogicalComponentPkg p) {
        return p.getOwnedLogicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msSituationExpressionComponentLines(PhysicalComponent c) {
        return this.msComponentLines(c, HAS_STATEMACHINE);
    }

    public Collection<EObject> msCrossTableComponentLines(PhysicalComponent c) {
        return this.msComponentLines(c, (Predicate<Component>)Predicates.alwaysTrue());
    }

    public Collection<EObject> msSituationExpressionComponentLines(PhysicalComponentPkg p) {
        return p.getOwnedPhysicalComponents().stream().filter(child -> this.componentHierarchyWithPredicate((EObject)child, HAS_STATEMACHINE)).collect(Collectors.toList());
    }

    public Collection<EObject> msCrossTableComponentPkgLines(EObject target) {
        return this.msComponentPkgLines(target, (Predicate<Component>)Predicates.alwaysTrue());
    }

    public Collection<EObject> msSituationExpressionComponentPkgLines(EObject target) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        block0: for (EObject e : target.eContents()) {
            if (!(e instanceof ComponentPkg)) continue;
            TreeIterator deeper = e.eAllContents();
            while (deeper.hasNext()) {
                if (!(deeper.next() instanceof StateMachine)) continue;
                result.add(e);
                continue block0;
            }
        }
        return result;
    }

    public Collection<EObject> msComponentLines(PhysicalComponent c, Predicate<Component> predicate) {
        Stream<PhysicalComponent> candidateChildren = Stream.concat(c.getDeployedPhysicalComponents().stream(), c.getOwnedPhysicalComponents().stream().filter(child -> child.getDeployingPhysicalComponents().isEmpty()));
        return candidateChildren.filter(child -> this.componentHierarchyWithPredicate((EObject)child, predicate)).collect(Collectors.toList());
    }

    public Collection<EObject> msComponentPkgLines(EObject target, Predicate<Component> predicate) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject e : target.eContents()) {
            if (!(e instanceof ComponentPkg) || !this.componentHierarchyWithPredicate(e, predicate)) continue;
            result.add(e);
        }
        return result;
    }

    public boolean componentHierarchyWithPredicate(EObject e, Predicate<Component> predicate) {
        if (e instanceof Component && predicate.test((Component)e)) {
            return true;
        }
        if (e instanceof LogicalComponentPkg) {
            return Stream.concat(((LogicalComponentPkg)e).getOwnedLogicalComponents().stream(), ((LogicalComponentPkg)e).getOwnedLogicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof LogicalComponent) {
            return Stream.concat(((LogicalComponent)e).getOwnedLogicalComponents().stream(), ((LogicalComponent)e).getOwnedLogicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof PhysicalComponent) {
            return Stream.concat(Stream.concat(((PhysicalComponent)e).getDeployedPhysicalComponents().stream(), ((PhysicalComponent)e).getOwnedPhysicalComponentPkgs().stream()), ((PhysicalComponent)e).getOwnedPhysicalComponents().stream().filter(p -> p.getDeployingPhysicalComponents().isEmpty())).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        if (e instanceof PhysicalComponentPkg) {
            return Stream.concat(((PhysicalComponentPkg)e).getOwnedPhysicalComponents().stream().filter(p -> p.getDeployingPhysicalComponents().isEmpty()), ((PhysicalComponentPkg)e).getOwnedPhysicalComponentPkgs().stream()).anyMatch(t -> this.componentHierarchyWithPredicate((EObject)t, predicate));
        }
        return false;
    }

    public Collection<? extends EObject> msSituationExpressionStateMachineLines(EObject container) {
        if (container instanceof Component) {
            return ((Component)container).getOwnedStateMachines();
        }
        if (container instanceof ComponentPkg) {
            return ((ComponentPkg)container).getOwnedStateMachines();
        }
        return Collections.emptyList();
    }

    public Collection<Situation> msSituationExpressionColumns(Component container) {
        ArrayList<Situation> result = new ArrayList<Situation>();
        TreeIterator it = container.eAllContents();
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!(next instanceof Situation)) continue;
            try {
                LinkedText2Situation.SplitExpression.of((BooleanExpression)((Situation)next).getExpression());
                result.add((Situation)next);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }
}

