/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.client.BaseClientRequest;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

class CancellableRequestThread<T> {
    private T result = null;
    private Throwable exceptionThrown = null;
    private boolean threadComplete = false;
    private final Object lock = new Object();
    private final IProgressMonitor monitor;
    private final BaseClientRequest<T> request;

    public CancellableRequestThread(BaseClientRequest<T> request, IProgressMonitor monitor) {
        this.request = request;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInThread() {
        block14: {
            try {
                try {
                    this.result = this.request.run(this.monitor);
                }
                catch (Exception e) {
                    this.exceptionThrown = e;
                    Object object = this.lock;
                    synchronized (object) {
                        this.threadComplete = true;
                        this.lock.notify();
                        break block14;
                    }
                }
            }
            catch (Throwable throwable) {
                Object object = this.lock;
                synchronized (object) {
                    this.threadComplete = true;
                    this.lock.notify();
                }
                throw throwable;
            }
            Object object = this.lock;
            synchronized (object) {
                this.threadComplete = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T runAndWaitForCompleteOrCancelled() {
        try {
            ThreadWrapper tw = new ThreadWrapper();
            tw.start();
            while (!this.monitor.isCanceled()) {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(250L);
                    if (this.threadComplete) {
                        break;
                    }
                }
            }
            Throwable thr = this.getExceptionThrown();
            if (thr != null) {
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw new RuntimeException(thr);
            }
            if (!this.isThreadComplete() && this.getResult() == null) {
                throw new OperationCanceledException();
            }
            T result = this.getResult();
            return result;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getExceptionThrown() {
        Object object = this.lock;
        synchronized (object) {
            return this.exceptionThrown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isThreadComplete() {
        Object object = this.lock;
        synchronized (object) {
            return this.threadComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    private class ThreadWrapper
    extends Thread {
        private ThreadWrapper() {
            this.setDaemon(true);
            this.setName(CancellableRequestThread.class.getName());
        }

        @Override
        public void run() {
            CancellableRequestThread.this.runInThread();
        }
    }
}

