/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.list.primitive.ImmutableByteListFactory;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteArrayList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteEmptyList;
import org.eclipse.collections.impl.list.immutable.primitive.ImmutableByteSingletonList;

public class ImmutableByteListFactoryImpl
implements ImmutableByteListFactory {
    public ImmutableByteList empty() {
        return ImmutableByteEmptyList.INSTANCE;
    }

    public ImmutableByteList of() {
        return this.empty();
    }

    public ImmutableByteList with() {
        return this.empty();
    }

    public ImmutableByteList of(byte one) {
        return this.with(one);
    }

    public ImmutableByteList with(byte one) {
        return new ImmutableByteSingletonList(one);
    }

    public ImmutableByteList of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteList with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteArrayList.newListWith(items);
    }

    public ImmutableByteList ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteList withAll(ByteIterable items) {
        if (items instanceof ImmutableByteList) {
            return (ImmutableByteList)items;
        }
        return this.with(items.toArray());
    }
}

