/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.twiki.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class VerbatimBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("\\s*<verbatim>(.*)");
    private static final Pattern endPattern = Pattern.compile("\\s*</verbatim>(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            offset = this.matcher.start(1);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        } else {
            Matcher endMatcher = endPattern.matcher(line);
            if (endMatcher.matches()) {
                this.setClosed(true);
                return endMatcher.start(1);
            }
        }
        this.builder.characters(offset == 0 ? line : line.substring(offset));
        this.builder.characters("\n");
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            this.blockLineCount = 0;
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

