/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.RuntimeActivator;
import org.eclipse.dirigible.runtime.registry.IRuntimeServiceDescriptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RuntimeServicesServlet
extends HttpServlet {
    private static final long serialVersionUID = 6479080968630898150L;
    private static final Logger logger = Logger.getLogger((String)RuntimeServicesServlet.class.getCanonicalName());
    static List<IRuntimeServiceDescriptor> runtimeServiceDescriptors = new ArrayList<IRuntimeServiceDescriptor>();
    private static Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (runtimeServiceDescriptors.size() == 0) {
            Class<RuntimeServicesServlet> clazz = RuntimeServicesServlet.class;
            // MONITORENTER : org.eclipse.dirigible.runtime.registry.RuntimeServicesServlet.class
            try {
                this.registerRuntimeServices();
            }
            catch (InvalidSyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
                resp.sendError(500, e.getMessage());
            }
        }
        String runtimeServicesJson = "";
        try {
            runtimeServicesJson = gson.toJson(runtimeServiceDescriptors);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            resp.sendError(500, e.getMessage());
        }
        resp.getWriter().append(runtimeServicesJson);
        resp.getWriter().flush();
        resp.getWriter().close();
    }

    private void registerRuntimeServices() throws InvalidSyntaxException {
        BundleContext context = RuntimeActivator.getContext();
        Collection serviceReferences = context.getServiceReferences(IRuntimeServiceDescriptor.class, null);
        for (ServiceReference serviceReference : serviceReferences) {
            IRuntimeServiceDescriptor runtimeServiceDescriptor = (IRuntimeServiceDescriptor)context.getService(serviceReference);
            runtimeServiceDescriptors.add(runtimeServiceDescriptor);
            logger.info(String.format("%s added to the list of available Runtime Services", runtimeServiceDescriptor.getClass().getCanonicalName()));
        }
    }
}

