/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.ui.json.internal.handler;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationController;
import org.eclipse.emf.ecp.emf2web.exporter.FileGenerationExporter;
import org.eclipse.emf.ecp.emf2web.exporter.GenerationExporter;
import org.eclipse.emf.ecp.emf2web.json.controller.xtend.JsonGenerationController;
import org.eclipse.emf.ecp.emf2web.ui.handler.AbstractSchemaExportCommandHandler;
import org.eclipse.emf.ecp.emf2web.ui.json.Activator;
import org.eclipse.emf.ecp.emf2web.ui.json.internal.messages.Messages;
import org.eclipse.emf.ecp.ide.spi.util.EcoreHelper;
import org.eclipse.emf.ecp.ide.spi.util.ViewModelHelper;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExportJSONFormsHandler
extends AbstractSchemaExportCommandHandler {
    private final List<String> registeredEcores = new LinkedList<String>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.registeredEcores.clear();
        super.execute(event);
        for (String registeredEcore : this.registeredEcores) {
            EcoreHelper.unregisterEcore((String)registeredEcore);
        }
        return null;
    }

    protected Collection<VView> getViews(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        LinkedList<VView> views = new LinkedList<VView>();
        LinkedList<IFile> failedFiles = new LinkedList<IFile>();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof IFile)) continue;
            IFile file = (IFile)selectedObject;
            VView view = null;
            try {
                view = ViewModelHelper.loadView((IFile)file, this.registeredEcores);
            }
            catch (IOException ex) {
                Activator.logException(ex);
            }
            if (view == null || !ViewModelHelper.viewIsResolved((VView)view)) {
                failedFiles.add(file);
                continue;
            }
            views.add(view);
        }
        if (!failedFiles.isEmpty()) {
            this.showErrorMessage(failedFiles, views.isEmpty());
            if (views.isEmpty()) {
                return null;
            }
        }
        return views;
    }

    private void showErrorMessage(Collection<IFile> files, boolean allFailed) {
        Iterator<IFile> viewIt = files.iterator();
        String viewNames = viewIt.next().getName();
        while (viewIt.hasNext()) {
            viewNames = String.valueOf(viewNames) + ", " + viewIt.next().getName();
        }
        String message = String.valueOf(Messages.ExportJSONFormsHandler_ViewsNotResolved) + viewNames;
        message = allFailed ? String.valueOf(message) + "\n" + Messages.ExportJSONFormsHandler_ExportCanceled : String.valueOf(message) + "\n" + Messages.ExportJSONFormsHandler_ViewsSkipped;
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportJSONFormsHandler_ErrorResolvedViews, (String)message);
    }

    protected GenerationController getGenerationController() {
        return new JsonGenerationController();
    }

    protected GenerationExporter getGenerationExporter() {
        return new FileGenerationExporter();
    }
}

