/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProviderAware;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.internal.core.util.ElementRegistry;
import org.eclipse.emf.ecp.internal.core.util.ExtensionParser;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.ecp.spi.core.ProviderChangeListener;
import org.eclipse.emf.ecp.spi.core.util.AdapterProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.net4j.util.AdapterUtil;

public final class ECPProviderRegistryImpl
extends ElementRegistry<InternalProvider, ECPObserver>
implements ECPProviderRegistry {
    private final ProviderParser extensionParser = new ProviderParser();

    public InternalProvider getProvider(Object adaptable) {
        if (adaptable instanceof ECPProviderAware) {
            ECPProviderAware providerAware = (ECPProviderAware)adaptable;
            return (InternalProvider)providerAware.getProvider();
        }
        return (InternalProvider)AdapterUtil.adapt((Object)adaptable, InternalProvider.class);
    }

    @Override
    public InternalProvider getProvider(String name) {
        return (InternalProvider)this.getElement(name);
    }

    @Override
    public Collection<ECPProvider> getProviders() {
        return this.getElements();
    }

    @Override
    public void addProvider(ECPProvider provider) {
        this.changeElements(null, Collections.singleton((InternalProvider)provider));
    }

    @Override
    public void removeProvider(String name) {
        this.changeElements(Collections.singleton(name), null);
    }

    @Override
    protected void notifyObservers(Collection<InternalProvider> oldProviders, Collection<InternalProvider> newProviders) throws Exception {
        ECPUtil.getECPObserverBus().notify(ECPProvidersChangedObserver.class).providersChanged(oldProviders, newProviders);
    }

    @Override
    protected void elementsChanged(Collection<InternalProvider> oldElements, Collection<InternalProvider> newElements) {
        super.elementsChanged(oldElements, newElements);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.extensionParser.activate();
    }

    protected void doDeactivate() throws Exception {
        this.extensionParser.deactivate();
        super.doDeactivate();
    }

    private final class ProviderDescriptor
    extends ExtensionParser.ExtensionDescriptor<InternalProvider>
    implements InternalProvider {
        private AdapterProvider uiProvider;

        ProviderDescriptor(String name, IConfigurationElement configurationElement) {
            super(ECPProviderRegistryImpl.this, name, "Provider", configurationElement);
        }

        @Override
        public ECPProvider getProvider() {
            return this;
        }

        @Override
        public AdapterProvider getUIProvider() {
            return this.uiProvider;
        }

        @Override
        public void setUIProvider(AdapterProvider uiProvider) {
            this.uiProvider = uiProvider;
            if (this.isResolved()) {
                ((InternalProvider)this.getResolvedElement()).setUIProvider(uiProvider);
            }
        }

        @Override
        public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
            return (T)((InternalProvider)this.getResolvedElement()).getAdapter(adaptable, adapterType);
        }

        public Object getAdapter(Class adapterType) {
            return ((InternalProvider)this.getResolvedElement()).getAdapter(adapterType);
        }

        @Override
        public Set<InternalProject> getOpenProjects() {
            return ((InternalProvider)this.getResolvedElement()).getOpenProjects();
        }

        @Override
        public EditingDomain createEditingDomain(InternalProject project) {
            return ((InternalProvider)this.getResolvedElement()).createEditingDomain(project);
        }

        @Override
        public boolean hasCreateRepositorySupport() {
            return ((InternalProvider)this.getResolvedElement()).hasCreateRepositorySupport();
        }

        @Override
        public boolean isSlow(Object parent) {
            return ((InternalProvider)this.getResolvedElement()).isSlow(parent);
        }

        @Override
        public ECPContainer getModelContext(Object element) {
            return ((InternalProvider)this.getResolvedElement()).getModelContext(element);
        }

        @Override
        public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
            ((InternalProvider)this.getResolvedElement()).fillChildren(context, parent, childrenList);
        }

        @Override
        public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
            ((InternalProvider)this.getResolvedElement()).handleLifecycle(context, event);
        }

        @Override
        protected void resolvedElement(InternalProvider provider) {
            super.resolvedElement(provider);
            provider.setLabel(this.getLabel());
            provider.setDescription(this.getDescription());
            provider.setUIProvider(this.uiProvider);
        }

        @Override
        protected void doDispose() {
            this.uiProvider = null;
            super.doDispose();
        }

        @Override
        public boolean hasCreateProjectWithoutRepositorySupport() {
            return ((InternalProvider)this.getResolvedElement()).hasCreateProjectWithoutRepositorySupport();
        }

        @Override
        public EList<? extends Object> getElements(InternalProject project) {
            return ((InternalProvider)this.getResolvedElement()).getElements(project);
        }

        @Override
        public Iterator<EObject> getLinkElements(InternalProject project, EObject modelElement, EReference eReference) {
            return ((InternalProvider)this.getResolvedElement()).getLinkElements(project, modelElement, eReference);
        }

        @Override
        public Set<EPackage> getUnsupportedEPackages(Collection<EPackage> ePackages, InternalRepository repository) {
            return ((InternalProvider)this.getResolvedElement()).getUnsupportedEPackages(ePackages, repository);
        }

        @Override
        public void doSave(InternalProject project) {
            ((InternalProvider)this.getResolvedElement()).doSave(project);
        }

        @Override
        public boolean isDirty(InternalProject project) {
            return ((InternalProvider)this.getResolvedElement()).isDirty(project);
        }

        @Override
        public void delete(InternalProject project, Collection<Object> objects) {
            ((InternalProvider)this.getResolvedElement()).delete(project, objects);
        }

        @Override
        public void cloneProject(InternalProject projectToClone, InternalProject targetProject) {
            ((InternalProvider)this.getResolvedElement()).cloneProject(projectToClone, targetProject);
        }

        @Override
        public boolean modelExists(InternalProject project) {
            return ((InternalProvider)this.getResolvedElement()).modelExists(project);
        }

        @Override
        public Notifier getRoot(InternalProject project) {
            return ((InternalProvider)this.getResolvedElement()).getRoot(project);
        }

        @Override
        public boolean contains(InternalProject project, Object object) {
            return ((InternalProvider)this.getResolvedElement()).contains(project, object);
        }

        @Override
        public boolean isThreadSafe() {
            return ((InternalProvider)this.getResolvedElement()).isThreadSafe();
        }

        @Override
        public void registerChangeListener(ProviderChangeListener listener) {
            ((InternalProvider)this.getResolvedElement()).registerChangeListener(listener);
        }

        @Override
        public void unregisterChangeListener(ProviderChangeListener listener) {
            ((InternalProvider)this.getResolvedElement()).unregisterChangeListener(listener);
        }
    }

    private final class ProviderParser
    extends ExtensionParser<InternalProvider> {
        private static final String EXTENSION_POINT_NAME = "providers";

        ProviderParser() {
            super(ECPProviderRegistryImpl.this, "org.eclipse.emf.ecp.core", EXTENSION_POINT_NAME);
        }

        @Override
        protected InternalProvider createElement(String name, IConfigurationElement configurationElement) {
            ProviderDescriptor descriptor = new ProviderDescriptor(name, configurationElement);
            descriptor.setLabel(configurationElement.getDeclaringExtension().getLabel());
            descriptor.setDescription(configurationElement.getAttribute("description"));
            return descriptor;
        }
    }
}

