/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.spi.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.spi.common.ui.SelectModelElementWizardFactory;
import org.eclipse.emf.ecp.spi.common.ui.composites.SelectionComposite;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.ui.util.ECPHandlerHelper;
import org.eclipse.emf.ecp.ui.common.ECPCompositeFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ECPReferenceServiceImpl
implements ReferenceService {
    private ViewModelContext context;
    private ECPProject ecpProject;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.ecpProject = ECPUtil.getECPProjectManager().getProject((Object)context.getDomainModel());
    }

    public void dispose() {
        this.ecpProject = null;
        this.context = null;
    }

    public int getPriority() {
        return 0;
    }

    public void addNewModelElements(EObject eObject, EReference eReference) {
        if (eReference == null) {
            return;
        }
        EObject newModelElement = null;
        Collection classes = ECPUtil.getSubClasses((EClass)eReference.getEReferenceType());
        if (classes.size() > 1) {
            SelectionComposite<TreeViewer> helper = ECPCompositeFactory.getSelectModelClassComposite(new HashSet<EPackage>(), new HashSet<EPackage>(), classes);
            newModelElement = SelectModelElementWizardFactory.openCreateNewModelElementDialog(helper);
        } else {
            newModelElement = eReference.getEReferenceType().getEPackage().getEFactoryInstance().create((EClass)classes.iterator().next());
        }
        if (newModelElement == null) {
            return;
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        ECPControlHelper.addModelElementInReference((EObject)eObject, (EObject)newModelElement, (EReference)eReference, (EditingDomain)this.ecpProject.getEditingDomain());
        this.openInNewContext(newModelElement);
    }

    public void addExistingModelElements(EObject eObject, EReference eReference) {
        Iterator allElements = ((InternalProject)this.ecpProject).getReferenceCandidates(this.context.getDomainModel(), eReference);
        LinkedHashSet<EObject> elements = new LinkedHashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        ECPControlHelper.removeExistingReferences((EObject)eObject, (EReference)eReference, elements);
        Set selectedElements = SelectModelElementWizardFactory.openModelElementSelectionDialog(elements, (boolean)eReference.isMany());
        ECPControlHelper.addModelElementsInReference((EObject)eObject, (Set)selectedElements, (EReference)eReference, (EditingDomain)this.ecpProject.getEditingDomain());
    }

    public void openInNewContext(EObject eObject) {
        ECPHandlerHelper.openModelElement(eObject, this.ecpProject);
    }
}

