/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.provider.xmi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.internal.view.model.provider.xmi.Activator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrationException;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.spi.model.LocalizationAdapter;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceFactoryImpl;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceImpl;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;

public final class ViewModelFileExtensionsManager {
    private static final String FILTER_VALUE_ATTRIBUTE = "value";
    private static final String FILTER_KEY_ATTRIBUTE = "key";
    private static final String FILTER_ELEMENT = "filter";
    private static final String FILE_EXTENSION = "org.eclipse.emf.ecp.view.model.provider.xmi.file";
    private static final String FILEPATH_ATTRIBUTE = "filePath";
    private static final Map<Object, Object> LOAD_OPTIONS = new LinkedHashMap<Object, Object>();
    private final Map<EClass, Map<VView, Set<ExtensionDescription>>> map;
    private static File viewModelFolder;
    private static ViewModelFileExtensionsManager instance;
    private static final int FILTER_NOT_MATCHED = Integer.MIN_VALUE;

    private ViewModelFileExtensionsManager() {
        LOAD_OPTIONS.put("TIMEOUT", 1);
        LOAD_OPTIONS.put("DEFER_ATTACHMENT", Boolean.TRUE);
        LOAD_OPTIONS.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        LOAD_OPTIONS.put("USE_DEPRECATED_METHODS", Boolean.TRUE);
        this.map = new LinkedHashMap<EClass, Map<VView, Set<ExtensionDescription>>>();
    }

    public static synchronized ViewModelFileExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ViewModelFileExtensionsManager();
            instance.init();
        }
        return instance;
    }

    private void init() {
        Map<URI, List<ExtensionDescription>> extensionURIS = ViewModelFileExtensionsManager.getExtensionURIS();
        for (URI uri : extensionURIS.keySet()) {
            VViewResourceImpl resource = ViewModelFileExtensionsManager.loadResource(uri);
            EList contents = resource.getContents();
            if (contents.size() == 0) continue;
            EObject eObject = (EObject)contents.get(0);
            if (!(eObject instanceof VView)) {
                ReportService reportService = Activator.getReportService();
                if (reportService == null) continue;
                reportService.report(new AbstractReport(String.format("The registered file '%1$s' doesn't point to a serialized view model.", uri.toString())));
                continue;
            }
            VView view = (VView)eObject;
            if (view.getRootEClass() == null) {
                ReportService reportService = Activator.getReportService();
                if (reportService == null) continue;
                reportService.report(new AbstractReport(String.format("The registered view in file '%1$s' doesn't have a set root eclass.", uri.toString())));
                continue;
            }
            ViewModelFileExtensionsManager.setUUIDAsElementId(resource, view);
            for (ExtensionDescription extensionDescription : extensionURIS.get(uri)) {
                this.registerView(view, extensionDescription);
            }
        }
    }

    public static void setUUIDAsElementId(VViewResourceImpl resource, VView view) {
        view.setUuid(resource.getID((EObject)view));
        TreeIterator allContents = view.eAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!VElement.class.isInstance(next)) continue;
            ((VElement)VElement.class.cast(next)).setUuid(resource.getID(next));
        }
    }

    void registerView(VView view, ExtensionDescription extensionDescription) {
        Map<VView, Set<ExtensionDescription>> viewDescriptionMap;
        if (!this.map.containsKey(view.getRootEClass())) {
            this.map.put(view.getRootEClass(), new LinkedHashMap());
        }
        if (!(viewDescriptionMap = this.map.get(view.getRootEClass())).containsKey(view)) {
            viewDescriptionMap.put(view, new LinkedHashSet());
        }
        viewDescriptionMap.get(view).add(extensionDescription);
    }

    public static VViewResourceImpl loadResource(URI uri) {
        VViewResourceImpl resource;
        ViewModelMigrator viewModelMigrator = ViewModelMigratorUtil.getViewModelMigrator();
        if (viewModelMigrator != null) {
            uri = ViewModelFileExtensionsManager.migrateViewModelIfNecesarry(viewModelMigrator, uri);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().putAll(LOAD_OPTIONS);
        Map extensionToFactoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("*", new VViewResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://org/eclipse/emf/ecp/view/model/170", (Object)VViewPackage.eINSTANCE);
        try {
            resource = (VViewResourceImpl)resourceSet.getResource(uri, true);
        }
        catch (WrappedException exception) {
            ReportService reportService = Activator.getReportService();
            if (reportService != null) {
                reportService.report(new AbstractReport((Throwable)exception, "Loading view model failed. Maybe a migration is needed. Please take a look at the migration guide at: http://www.eclipse.org/ecp/emfforms/documentation.html"));
            }
            resource = (VViewResourceImpl)resourceSet.createResource(uri);
        }
        return resource;
    }

    private static URI migrateViewModelIfNecesarry(ViewModelMigrator viewModelMigrator, URI uri) {
        block7: {
            ReportService reportService = Activator.getReportService();
            try {
                File dest = ViewModelFileExtensionsManager.getFileDestination();
                if (dest == null) {
                    return uri;
                }
                ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
                InputStream inputStream = uriConverter.createInputStream(uri, LOAD_OPTIONS);
                ViewModelFileExtensionsManager.copy(inputStream, dest);
                uri = URI.createFileURI((String)dest.getAbsolutePath());
                if (viewModelMigrator.checkMigration(uri)) {
                    return uri;
                }
                if (reportService != null) {
                    reportService.report(new AbstractReport(MessageFormat.format("The view model at {0} needs migration. Please take a look at the migration guide at: http://www.eclipse.org/ecp/emfforms/documentation.html", uri.toString()), 2));
                }
                viewModelMigrator.performMigration(uri);
                return uri;
            }
            catch (IOException ex) {
                if (reportService != null) {
                    reportService.report(new AbstractReport((Throwable)ex, MessageFormat.format("The migration of view model at {0} failed.", uri.toString())));
                }
            }
            catch (ViewModelMigrationException ex) {
                if (reportService == null) break block7;
                reportService.report(new AbstractReport((Throwable)ex, MessageFormat.format("The migration of view model at {0} failed.", uri.toString())));
            }
        }
        return uri;
    }

    private static synchronized File getFileDestination() {
        if (viewModelFolder == null) {
            File stateLocation = Activator.getInstance().getStateLocation().toFile();
            viewModelFolder = new File(stateLocation, "views");
            if (!viewModelFolder.exists()) {
                viewModelFolder.mkdir();
            }
            File[] fileArray = viewModelFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        File file = new File(viewModelFolder, String.valueOf(System.currentTimeMillis()) + ".view");
        file.deleteOnExit();
        return file;
    }

    private static void copy(InputStream in, File file) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
    }

    public static void dispose() {
        instance = null;
    }

    public static Map<URI, List<ExtensionDescription>> getExtensionURIS() {
        LinkedHashMap<URI, List<ExtensionDescription>> ret = new LinkedHashMap<URI, List<ExtensionDescription>>();
        IConfigurationElement[] files = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_EXTENSION);
        URIConverter converter = new ResourceSetImpl().getURIConverter();
        IConfigurationElement[] iConfigurationElementArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ReportService reportService;
            IConfigurationElement file = iConfigurationElementArray[n2];
            String bundleId = file.getContributor().getName();
            String filePath = file.getAttribute(FILEPATH_ATTRIBUTE);
            IConfigurationElement[] children = file.getChildren(FILTER_ELEMENT);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement child = iConfigurationElementArray2[n4];
                String key = child.getAttribute(FILTER_KEY_ATTRIBUTE);
                String value = child.getAttribute(FILTER_VALUE_ATTRIBUTE);
                keyValuePairs.put(key, value);
                ++n4;
            }
            String bundleName = file.getContributor().getName();
            String path = String.valueOf(bundleName) + '/' + filePath;
            URI uri = URI.createPlatformPluginURI((String)path, (boolean)false);
            if (!converter.exists(uri, LOAD_OPTIONS) && !converter.exists(uri = URI.createPlatformResourceURI((String)filePath, (boolean)false), LOAD_OPTIONS) && (reportService = Activator.getReportService()) != null) {
                reportService.report(new AbstractReport(String.format("The provided uri '%1$s' doesn't point to an existing file.", uri.toString()), 4));
            } else {
                if (!ret.containsKey(uri)) {
                    ret.put(uri, new ArrayList());
                }
                ((List)ret.get(uri)).add(new ExtensionDescription(keyValuePairs, bundleId));
            }
            ++n2;
        }
        return ret;
    }

    public boolean hasViewModelFor(EObject eObject, VViewModelProperties properties) {
        return !this.findBestFittingViews(eObject, properties).isEmpty();
    }

    public VView createView(EObject eObject, VViewModelProperties properties) {
        ReportService reportService;
        Map<VView, ExtensionDescription> bestFitting = this.findBestFittingViews(eObject, properties);
        if (bestFitting.isEmpty()) {
            ReportService reportService2 = Activator.getReportService();
            if (reportService2 != null) {
                reportService2.report(new AbstractReport("No view models have been found for the given View Model Loading Properties. This should have not been called!", 4));
            }
            return null;
        }
        if (bestFitting.size() != 1 && (reportService = Activator.getReportService()) != null) {
            reportService.report(new AbstractReport("Multiple view models have been found for the given View Model Loading Properties.", 2));
        }
        Map.Entry<VView, ExtensionDescription> entry = bestFitting.entrySet().iterator().next();
        VView copiedView = (VView)EcoreUtil.copy((EObject)entry.getKey());
        String bundleId = entry.getValue().getBundleId();
        copiedView.eAdapters().add((Object)new LocalizationAdapter(){

            public String localize(String key) {
                return LocalizationServiceHelper.getString((Bundle)Platform.getBundle((String)bundleId), (String)key);
            }
        });
        copiedView.setLoadingProperties((VViewModelProperties)EcoreUtil.copy((EObject)properties));
        return copiedView;
    }

    private Map<VView, ExtensionDescription> findBestFittingViews(EObject eObject, VViewModelProperties properties) {
        LinkedHashMap<VView, Set<ExtensionDescription>> viewMap = new LinkedHashMap<VView, Set<ExtensionDescription>>();
        LinkedHashSet<EClass> allEClass = new LinkedHashSet<EClass>();
        allEClass.add(eObject.eClass());
        allEClass.addAll((Collection<EClass>)eObject.eClass().getEAllSuperTypes());
        for (EClass eClass : allEClass) {
            Map<VView, Set<ExtensionDescription>> classMap = this.map.get(eClass);
            if (classMap == null) continue;
            viewMap.putAll(classMap);
        }
        LinkedHashMap<VView, ExtensionDescription> bestFitting = new LinkedHashMap<VView, ExtensionDescription>();
        int maxNumberFittingKeyValues = -1;
        VViewModelProperties propertiesToCheck = properties;
        if (propertiesToCheck == null) {
            propertiesToCheck = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        }
        for (VView view : viewMap.keySet()) {
            for (ExtensionDescription description : (Set)viewMap.get(view)) {
                int currentFittingKeyValues = 0;
                Map<String, String> viewFilter = description.getKeyValuPairs();
                for (String viewFilterKey : viewFilter.keySet()) {
                    if (propertiesToCheck.containsKey(viewFilterKey)) {
                        Object contextValue = propertiesToCheck.get(viewFilterKey);
                        String viewFilterValue = viewFilter.get(viewFilterKey);
                        if (contextValue.toString().equalsIgnoreCase(viewFilterValue)) {
                            ++currentFittingKeyValues;
                            continue;
                        }
                        currentFittingKeyValues = Integer.MIN_VALUE;
                        break;
                    }
                    currentFittingKeyValues = Integer.MIN_VALUE;
                    break;
                }
                if (currentFittingKeyValues == Integer.MIN_VALUE) continue;
                if (currentFittingKeyValues > maxNumberFittingKeyValues) {
                    maxNumberFittingKeyValues = currentFittingKeyValues;
                    bestFitting.clear();
                    bestFitting.put(view, description);
                    continue;
                }
                if (currentFittingKeyValues != maxNumberFittingKeyValues) continue;
                bestFitting.put(view, description);
            }
        }
        return this.getViewMap(bestFitting, eObject.eClass());
    }

    private Map<VView, ExtensionDescription> getViewMap(Map<VView, ExtensionDescription> fullMap, EClass viewModelFor) {
        LinkedHashMap<VView, ExtensionDescription> viewMap = new LinkedHashMap<VView, ExtensionDescription>();
        LinkedHashSet<EClass> checkedEClasses = new LinkedHashSet<EClass>();
        LinkedHashSet<EClass> eClassesToGetViewModelsFor = new LinkedHashSet<EClass>();
        eClassesToGetViewModelsFor.add(viewModelFor);
        while (!eClassesToGetViewModelsFor.isEmpty()) {
            for (EClass eClass : eClassesToGetViewModelsFor) {
                LinkedHashMap<VView, ExtensionDescription> classMap = new LinkedHashMap<VView, ExtensionDescription>();
                for (VView vView : fullMap.keySet()) {
                    if (eClass != vView.getRootEClass()) continue;
                    classMap.put(vView, fullMap.get(vView));
                }
                viewMap.putAll(classMap);
                checkedEClasses.add(eClass);
            }
            if (!viewMap.isEmpty()) {
                eClassesToGetViewModelsFor.clear();
                break;
            }
            LinkedHashSet<EClass> superTypes = new LinkedHashSet<EClass>();
            for (EClass eClass : eClassesToGetViewModelsFor) {
                for (EClass superType : eClass.getESuperTypes()) {
                    if (checkedEClasses.contains(superType)) continue;
                    superTypes.add(superType);
                }
            }
            eClassesToGetViewModelsFor = superTypes;
        }
        return viewMap;
    }

    static final class ExtensionDescription {
        private final Map<String, String> keyValuPairs;
        private final String bundleId;

        ExtensionDescription(Map<String, String> keyValuPairs, String bundleId) {
            this.keyValuPairs = keyValuPairs;
            this.bundleId = bundleId;
        }

        Map<String, String> getKeyValuPairs() {
            return this.keyValuPairs;
        }

        String getBundleId() {
            return this.bundleId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
            result = 31 * result + (this.keyValuPairs == null ? 0 : this.keyValuPairs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtensionDescription other = (ExtensionDescription)obj;
            if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
                return false;
            }
            return !(this.keyValuPairs == null ? other.keyValuPairs != null : !this.keyValuPairs.equals(other.keyValuPairs));
        }
    }
}

