/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.internal.migration;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class Resources {
    private static final String VIEW_EXT = "view";

    private Resources() {
    }

    public static Set<IFile> findAllViewFilesInWorkspace(SubMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)root.getProjects().length);
        try {
            return Resources.collectViewFiles((IContainer)root, subMonitor);
        }
        catch (CoreException ex) {
            return new LinkedHashSet<IFile>();
        }
    }

    public static Set<IFile> collectViewFiles(IContainer container, SubMonitor subMonitor) throws CoreException {
        LinkedHashSet<IFile> files = new LinkedHashSet<IFile>();
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IContainer) {
                files.addAll(Resources.collectViewFiles((IContainer)IContainer.class.cast(member), subMonitor));
            } else if (member != null && member.getFileExtension() != null && member.getFileExtension().equals(VIEW_EXT)) {
                files.add((IFile)member);
            }
            ++n2;
        }
        if (container instanceof IProject) {
            subMonitor.worked(1);
        }
        return files;
    }
}

