/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.model.util.ViewModelUtil;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.layout.LayoutProviderHelper;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ContainerSWTRenderer<VELEMENT extends VElement>
extends AbstractSWTRenderer<VELEMENT> {
    private final EMFFormsRendererFactory factory;
    private final EMFFormsDatabinding emfFormsDatabinding;
    private SWTGridDescription rendererGridDescription;

    protected final EMFFormsRendererFactory getEMFFormsRendererFactory() {
        return this.factory;
    }

    public ContainerSWTRenderer(VELEMENT vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory factory, EMFFormsDatabinding emfFormsDatabinding) {
        super(vElement, viewContext, reportService);
        this.factory = factory;
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell gridCell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (gridCell.getColumn() != 0) {
            return null;
        }
        Composite columnComposite = this.getComposite(parent);
        columnComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getCustomVariant());
        columnComposite.setBackground(parent.getBackground());
        LinkedHashMap elementRendererMap = new LinkedHashMap();
        SWTGridDescription maximalGridDescription = null;
        LinkedHashMap<VContainedElement, SWTGridDescription> rowGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        LinkedHashMap<VContainedElement, SWTGridDescription> controlGridDescription = new LinkedHashMap<VContainedElement, SWTGridDescription>();
        for (VContainedElement child : this.getChildren()) {
            AbstractSWTRenderer renderer;
            try {
                renderer = this.getEMFFormsRendererFactory().getRendererInstance((VElement)child, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.core.swt", String.format("No Renderer for %s found.", child.eClass().getName()), (Throwable)ex)));
                continue;
            }
            Collection additionalRenderers = this.getEMFFormsRendererFactory().getAdditionalRendererInstances((VElement)child, this.getViewModelContext());
            SWTGridDescription gridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            controlGridDescription.put(child, gridDescription);
            for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
                gridDescription = additionalRenderer.getGridDescription(gridDescription);
            }
            rowGridDescription.put(child, gridDescription);
            if (maximalGridDescription == null || maximalGridDescription.getColumns() < gridDescription.getColumns()) {
                maximalGridDescription = gridDescription;
            }
            LinkedHashSet<AbstractSWTRenderer> allRenderer = new LinkedHashSet<AbstractSWTRenderer>();
            allRenderer.add(renderer);
            allRenderer.addAll(additionalRenderers);
            elementRendererMap.put(child, allRenderer);
        }
        if (maximalGridDescription == null) {
            return columnComposite;
        }
        columnComposite.setLayout(this.getLayout(maximalGridDescription.getColumns(), false));
        for (VContainedElement child : this.getChildren()) {
            SWTGridDescription gridDescription = (SWTGridDescription)rowGridDescription.get(child);
            if (gridDescription == null) continue;
            for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                Control control;
                block15: {
                    control = null;
                    try {
                        control = ((AbstractSWTRenderer)childGridCell.getRenderer()).render(childGridCell, columnComposite);
                    }
                    catch (NoRendererFoundException ex) {
                        this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                        if (ViewModelUtil.isDebugMode()) {
                            control = this.renderDiagnoseControl(columnComposite, child);
                        }
                    }
                    catch (NoPropertyDescriptorFoundExeption ex) {
                        this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                        if (!ViewModelUtil.isDebugMode()) break block15;
                        control = this.renderDiagnoseControl(columnComposite, child);
                    }
                }
                if (control == null) {
                    this.getReportService().report(new AbstractReport(String.format("No Control created for Column %1$s of Control %2$s. Filled in with blank.", childGridCell.getColumn(), ((AbstractSWTRenderer)childGridCell.getRenderer()).getClass().getName())));
                    control = new Composite(columnComposite, 0);
                }
                this.setLayoutDataForControl(childGridCell, (SWTGridDescription)controlGridDescription.get(child), gridDescription, maximalGridDescription, ((AbstractSWTRenderer)childGridCell.getRenderer()).getVElement(), control);
            }
            for (SWTGridCell childGridCell : gridDescription.getGrid()) {
                ((AbstractSWTRenderer)childGridCell.getRenderer()).finalizeRendering(columnComposite);
            }
        }
        return columnComposite;
    }

    protected EMFFormsDatabinding getEMFFormsDatabinding() {
        return this.emfFormsDatabinding;
    }

    private Control renderDiagnoseControl(Composite parent, VContainedElement child) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setForeground(Display.getDefault().getSystemColor(3));
        label.setText("An error occurred while rendering " + child.getClass().getCanonicalName());
        return composite;
    }

    protected String getCustomVariant() {
        return "org_eclipse_emf_ecp_view_container";
    }

    protected Collection<VContainedElement> getChildren() {
        if (VViewPackage.eINSTANCE.getContainer().isInstance((Object)this.getVElement())) {
            return ((VContainer)VContainer.class.cast(this.getVElement())).getChildren();
        }
        return Collections.emptySet();
    }

    protected Composite getComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    protected Layout getLayout(int numControls, boolean equalWidth) {
        return LayoutProviderHelper.getColumnLayout((int)numControls, (boolean)equalWidth);
    }

    protected void setLayoutDataForControl(SWTGridCell gridCell, SWTGridDescription gridDescription, SWTGridDescription currentRowGridDescription, SWTGridDescription fullGridDescription, VElement vElement, Control control) {
        control.setLayoutData(LayoutProviderHelper.getLayoutData((SWTGridCell)gridCell, (SWTGridDescription)gridDescription, (SWTGridDescription)currentRowGridDescription, (SWTGridDescription)fullGridDescription, (VElement)vElement, (EObject)this.getViewModelContext().getDomainModel(), (Control)control));
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }
}

