/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.preview;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.ecp.view.model.internal.preview.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ManageAdditionalViewsDialog
extends Dialog {
    private final Set<IPath> knownViews;

    public ManageAdditionalViewsDialog(Shell parentShell, Set<IPath> knownViews) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.knownViews = knownViews;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ManageAdditionalViewsDialog_Title);
        shell.setMinimumSize(300, 300);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.ManageAdditionalViewsDialog_LoadedView);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)label);
        final ListViewer listViewer = new ListViewer(composite, 2052);
        listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (IPath.class.isInstance(element)) {
                    return ((IPath)IPath.class.cast(element)).toOSString();
                }
                return super.getText(element);
            }
        });
        listViewer.setInput(this.knownViews);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(listViewer.getControl());
        Composite buttons = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)buttons);
        buttons.setLayout((Layout)new FillLayout(256));
        Button addView = new Button(buttons, 8);
        addView.setText(Messages.ManageAdditionalViewsDialog_AddView);
        addView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                WorkspaceResourceDialog d = new WorkspaceResourceDialog(ManageAdditionalViewsDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                d.setAllowMultiple(false);
                d.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        if (selection == null || selection.length != 1 || !IFile.class.isInstance(selection[0])) {
                            return new Status(4, "org.eclipse.emf.ecp.view.model.preview.e3", Messages.ManageAdditionalViewsDialog_NoFileSelected);
                        }
                        if (((IFile)IFile.class.cast(selection[0])).getFileExtension().equals("view")) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, "org.eclipse.emf.ecp.view.model.preview.e3", Messages.ManageAdditionalViewsDialog_NoViewModelSelected);
                    }
                });
                d.loadContents();
                int result = d.open();
                if (result == 0) {
                    ManageAdditionalViewsDialog.this.knownViews.add(d.getSelectedFiles()[0].getFullPath());
                    listViewer.refresh();
                }
            }
        });
        Button removeView = new Button(buttons, 8);
        removeView.setText(Messages.ManageAdditionalViewsDialog_RemoveView);
        removeView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ManageAdditionalViewsDialog.this.knownViews.remove(listViewer.getStructuredSelection().getFirstElement());
                listViewer.refresh();
            }
        });
        return composite;
    }
}

