/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.nebula.grid;

import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.common.Property;
import org.eclipse.emfforms.spi.swt.table.AbstractTableViewerColumnBuilder;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.ViewerRefreshManager;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GridViewerColumnBuilder
extends AbstractTableViewerColumnBuilder<GridTableViewer, GridViewerColumn> {
    private ViewerRefreshManager refreshManager;

    public GridViewerColumnBuilder(ColumnConfiguration config) {
        super(config);
    }

    public GridViewerColumn createViewerColumn(GridTableViewer tableViewer) {
        this.refreshManager = ViewerRefreshManager.getInstance((Viewer)tableViewer);
        return new GridViewerColumn(tableViewer, this.getConfig().getStyleBits());
    }

    protected void configure(GridTableViewer tableViewer, GridViewerColumn viewerColumn) {
        super.configure((AbstractTableViewer)tableViewer, (ViewerColumn)viewerColumn);
        this.configureHideShow(tableViewer, viewerColumn);
        this.configureFiltering(tableViewer, viewerColumn);
    }

    protected void configureDatabinding(Widget column) {
        super.configureDatabinding(column);
        this.bindValue(column, (IWidgetValueProperty)new GridColumnTooltipTextProperty(), this.getConfig().getColumnTooltip());
    }

    protected Item getTableColumn(GridViewerColumn viewerColumn) {
        return viewerColumn.getColumn();
    }

    protected void configureViewerColumn(GridViewerColumn viewerColumn) {
        GridColumn column = viewerColumn.getColumn();
        column.setResizeable(this.getConfig().isResizeable());
        column.setMoveable(this.getConfig().isMoveable());
        column.setVisible(((Boolean)this.getConfig().visible().getValue()).booleanValue());
    }

    protected void configureEditingSupport(GridViewerColumn viewerColumn, GridTableViewer tableViewer) {
        Optional editingSupport = this.getConfig().createEditingSupport((AbstractTableViewer)tableViewer);
        if (editingSupport.isPresent()) {
            viewerColumn.setEditingSupport((EditingSupport)editingSupport.get());
        }
    }

    protected void configureHideShow(GridTableViewer tableViewer, final GridViewerColumn viewerColumn) {
        this.getConfig().visible().addChangeListener((Property.ChangeListener)new Property.ChangeListener<Boolean>(){

            public void valueChanged(Property<Boolean> property, Boolean oldValue, Boolean newValue) {
                GridViewerColumnBuilder.this.getConfig().matchFilter().resetToDefault();
                GridColumn column = viewerColumn.getColumn();
                Listener hideShowListener = GridViewerColumnBuilder.extractShowListener(viewerColumn.getColumn());
                if (column.getHeaderControl() == null && hideShowListener != null) {
                    column.removeListener(22, hideShowListener);
                    column.removeListener(23, hideShowListener);
                } else {
                    hideShowListener = null;
                }
                column.setVisible(newValue.booleanValue());
                if (hideShowListener != null) {
                    column.addListener(22, hideShowListener);
                    column.addListener(23, hideShowListener);
                }
            }
        });
    }

    private static Listener extractShowListener(GridColumn column) {
        Listener[] listenerArray = column.getListeners(22);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            if (listener.getClass().getEnclosingClass() != null && ControlEditor.class.isAssignableFrom(listener.getClass().getEnclosingClass())) {
                return listener;
            }
            ++n2;
        }
        return null;
    }

    protected void configureFiltering(GridTableViewer tableViewer, GridViewerColumn viewerColumn) {
        final GridColumn column = viewerColumn.getColumn();
        this.getConfig().showFilterControl().addChangeListener((Property.ChangeListener)new Property.ChangeListener<Boolean>(){
            private Control filterControl;

            public void valueChanged(Property<Boolean> property, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    this.filterControl = GridViewerColumnBuilder.this.createHeaderFilterControl((Composite)column.getParent());
                    column.setHeaderControl(this.filterControl);
                } else {
                    column.setHeaderControl(null);
                    if (this.filterControl != null) {
                        this.filterControl.dispose();
                    }
                    GridViewerColumnBuilder.this.getConfig().matchFilter().resetToDefault();
                }
                column.setWidth(column.getWidth());
            }
        });
        this.getConfig().matchFilter().addChangeListener((Property.ChangeListener)new Property.ChangeListener<Object>(){

            public void valueChanged(Property<Object> property, Object oldValue, Object newValue) {
                GridViewerColumnBuilder.this.refreshManager.postRefresh();
            }
        });
    }

    protected Control createHeaderFilterControl(Composite parent) {
        Composite filterComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterComposite);
        final Text txtFilter = new Text(filterComposite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)txtFilter);
        txtFilter.addModifyListener(new ModifyListener(txtFilter){
            private final Runnable runnable;
            {
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!text.isDisposed()) {
                            GridViewerColumnBuilder.this.getConfig().matchFilter().setValue((Object)text.getText());
                        }
                    }
                };
            }

            public void modifyText(ModifyEvent e) {
                Display.getDefault().timerExec(300, this.runnable);
            }
        });
        filterComposite.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                if (!txtFilter.isDisposed() && GridViewerColumnBuilder.this.getConfig().matchFilter().getValue() != null) {
                    txtFilter.setText(String.valueOf(GridViewerColumnBuilder.this.getConfig().matchFilter().getValue()));
                }
            }
        });
        Button btnClear = new Button(filterComposite, 8);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)btnClear);
        btnClear.setText("x");
        btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                txtFilter.setText("");
            }
        });
        return filterComposite;
    }

    class GridColumnTooltipTextProperty
    extends WidgetValueProperty {
        GridColumnTooltipTextProperty() {
        }

        public String toString() {
            return "GridColumn.toolTipText <String>";
        }

        public Object getValueType() {
            return String.class;
        }

        protected Object doGetValue(Object source) {
            return ((GridColumn)source).getHeaderTooltip();
        }

        protected void doSetValue(Object source, Object value) {
            ((GridColumn)source).setHeaderTooltip((String)value);
        }
    }
}

