/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.index;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexDomainModelReference;
import org.eclipse.emf.ecp.view.spi.indexdmr.model.VIndexdmrPackage;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.segments.DmrSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.spi.view.indexsegment.model.VIndexDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.view.indexsegment.model.VIndexsegmentFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="IndexDmrSegmentGenerator")
public class IndexDmrSegmentGenerator
implements DmrSegmentGenerator {
    private EMFFormsSegmentGenerator emfFormsSegmentGenerator;
    private ReportService reportService;

    @Reference(unbind="-")
    void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() == VIndexdmrPackage.Literals.INDEX_DOMAIN_MODEL_REFERENCE) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public List<VDomainModelReferenceSegment> generateSegments(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() != VIndexdmrPackage.Literals.INDEX_DOMAIN_MODEL_REFERENCE) {
            throw new IllegalArgumentException(String.format("The given DMR was no index domain model reference. The DMR was: %s", reference));
        }
        VIndexDomainModelReference indexDmr = (VIndexDomainModelReference)reference;
        LinkedList<VDomainModelReferenceSegment> result = new LinkedList<VDomainModelReferenceSegment>();
        if (indexDmr.getPrefixDMR() != null) {
            List prefixSegments = this.getEMFFormsSegmentGenerator().generateSegments(indexDmr.getPrefixDMR());
            if (prefixSegments.isEmpty()) {
                this.reportFailure("no segments could be generated for the prefix dmr", (VDomainModelReference)indexDmr);
                return Collections.emptyList();
            }
            VFeatureDomainModelReferenceSegment lastPrefixSegment = (VFeatureDomainModelReferenceSegment)prefixSegments.get(prefixSegments.size() - 1);
            VIndexDomainModelReferenceSegment indexSegment = this.createIndexSegment(lastPrefixSegment.getDomainModelFeature(), indexDmr.getIndex());
            prefixSegments.remove(lastPrefixSegment);
            result.addAll(prefixSegments);
            result.add((VDomainModelReferenceSegment)indexSegment);
        } else {
            for (EReference eReference : indexDmr.getDomainModelEReferencePath()) {
                VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
                segment.setDomainModelFeature(eReference.getName());
                result.add((VDomainModelReferenceSegment)segment);
            }
            if (indexDmr.getDomainModelEFeature() != null) {
                VIndexDomainModelReferenceSegment indexSegment = this.createIndexSegment(indexDmr.getDomainModelEFeature().getName(), indexDmr.getIndex());
                result.add((VDomainModelReferenceSegment)indexSegment);
            } else {
                this.reportFailure("it has no prefix dmr and its domain model e feature is null", (VDomainModelReference)indexDmr);
                return Collections.emptyList();
            }
        }
        List targetSegments = this.getEMFFormsSegmentGenerator().generateSegments(indexDmr.getTargetDMR());
        if (targetSegments.isEmpty()) {
            this.reportFailure("no target segments could be generated", (VDomainModelReference)indexDmr);
            return Collections.emptyList();
        }
        result.addAll(targetSegments);
        return result;
    }

    private VIndexDomainModelReferenceSegment createIndexSegment(String domainModelFeature, int index) {
        VIndexDomainModelReferenceSegment indexSegment = VIndexsegmentFactory.eINSTANCE.createIndexDomainModelReferenceSegment();
        indexSegment.setDomainModelFeature(domainModelFeature);
        indexSegment.setIndex(index);
        return indexSegment;
    }

    private void reportFailure(String reason, VDomainModelReference indexDmr) {
        StringBuilder sb = new StringBuilder();
        sb.append("Could not generate segments for the index dmr because ");
        sb.append(reason);
        sb.append(". The index DMR was: %s");
        this.reportService.report(new AbstractReport(String.format(sb.toString(), indexDmr), 2));
    }

    private EMFFormsSegmentGenerator getEMFFormsSegmentGenerator() {
        if (this.emfFormsSegmentGenerator == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(IndexDmrSegmentGenerator.class).getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(EMFFormsSegmentGenerator.class);
            this.emfFormsSegmentGenerator = (EMFFormsSegmentGenerator)bundleContext.getService(serviceReference);
        }
        return this.emfFormsSegmentGenerator;
    }

    void setEMFFormsSegmentGenerator(EMFFormsSegmentGenerator generator) {
        this.emfFormsSegmentGenerator = generator;
    }
}

