/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecp.view.internal.core.swt.ComboUtil;
import org.eclipse.emf.ecp.view.internal.core.swt.MatchItemComboViewer;
import org.eclipse.emf.ecp.view.internal.core.swt.renderer.EnumComboViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EnumLiteralFilteredComboViewerSWTRenderer
extends EnumComboViewerSWTRenderer {
    @Inject
    public EnumLiteralFilteredComboViewerSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
    }

    @Override
    protected ComboViewer createComboViewer(Composite parent, final EEnum eEnum) {
        final CCombo combo = new CCombo(parent, 2048);
        combo.addListener(11, new Listener(){

            public void handleEvent(Event argEvent) {
                combo.setText(combo.getText());
            }
        });
        combo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                combo.clearSelection();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        combo.setEditable(true);
        MatchItemComboViewer viewer = new MatchItemComboViewer(combo){

            @Override
            public void onEnter() {
                int selectedIndex = ComboUtil.getClosestMatchIndex(this.getCCombo().getItems(), this.getBuffer().asString());
                if (!this.getBuffer().isEmpty() && selectedIndex > -1) {
                    String closestMatch = this.getCCombo().getItems()[selectedIndex];
                    Optional findLiteral = EnumLiteralFilteredComboViewerSWTRenderer.findLiteral((List)eEnum.getELiterals(), closestMatch);
                    if (findLiteral.isPresent()) {
                        this.setSelection((ISelection)new StructuredSelection((Object)((EEnumLiteral)findLiteral.get()).getInstance()));
                    }
                } else {
                    this.setClosestMatch(this.getCCombo().getText());
                }
                combo.clearSelection();
            }
        };
        return viewer;
    }

    private static Optional<EEnumLiteral> findLiteral(List<EEnumLiteral> enumerators, String literal) {
        for (EEnumLiteral e : enumerators) {
            if (!e.getLiteral().equals(literal)) continue;
            return Optional.of((Object)e);
        }
        return Optional.empty();
    }
}

