/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="unfoldClass", label="Unfold Class", description="In the metamodel, a class reachable through a single-valued containment reference is unfolded. More specifically, its features are copied to the source class of the reference which is deleted. In the model, the values of these features are moved accordingly.", breaking=true)
public class UnfoldClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to the class to be unfolded")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference must not have an opposite")
    public boolean checkReference(EReference reference) {
        return reference.getEOpposite() == null;
    }

    @EdaptConstraint(restricts="reference", description="The multiplicity of the reference must be single-valued")
    public boolean checkReferenceManyValued(EReference reference) {
        return !reference.isMany();
    }

    @EdaptConstraint(restricts="reference", description="The reference must be containment")
    public boolean checkReferenceContainment(EReference reference) {
        return reference.isContainment();
    }

    @EdaptConstraint(restricts="reference", description="The class to be unfolded must not have sub classes")
    public boolean checkUnfoldedClassNoSubTypes(EReference reference, Metamodel metamodel) {
        EClass unfoldedClass = reference.getEReferenceType();
        return metamodel.getESubTypes(unfoldedClass).isEmpty();
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass unfoldedClass = this.reference.getEReferenceType();
        EClass contextClass = this.reference.getEContainingClass();
        ArrayList features = new ArrayList(unfoldedClass.getEAllStructuralFeatures());
        ArrayList<EStructuralFeature> unfoldedFeatures = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature feature : features) {
            EReference r;
            EStructuralFeature unfoldedFeature = (EStructuralFeature)MetamodelUtils.copy((EModelElement)feature);
            unfoldedFeatures.add(unfoldedFeature);
            if (contextClass.getEStructuralFeature(feature.getName()) != null) {
                unfoldedFeature.setName(String.valueOf(unfoldedFeature.getName()) + "_" + unfoldedClass.getName());
            }
            contextClass.getEStructuralFeatures().add((Object)unfoldedFeature);
            if (!(feature instanceof EReference) || (r = (EReference)feature).getEOpposite() == null) continue;
            EReference foldedOpposite = (EReference)MetamodelUtils.copy((EModelElement)r.getEOpposite());
            foldedOpposite.setEType((EClassifier)contextClass);
            foldedOpposite.setName(String.valueOf(foldedOpposite.getName()) + "_" + contextClass.getName());
            r.getEReferenceType().getEStructuralFeatures().add((Object)foldedOpposite);
            metamodel.setEOpposite(foldedOpposite, (EReference)unfoldedFeature);
        }
        metamodel.delete((EModelElement)this.reference);
        for (Instance contextElement : model.getAllInstances(contextClass)) {
            Instance unfoldedElement = (Instance)contextElement.unset((EStructuralFeature)this.reference);
            if (unfoldedElement == null) continue;
            int i = 0;
            for (EStructuralFeature feature : features) {
                Object value = unfoldedElement.unset(feature);
                contextElement.set((EStructuralFeature)unfoldedFeatures.get(i), value);
                ++i;
            }
            model.delete(unfoldedElement);
        }
    }
}

