/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.AssocWithThreadResourceHandle;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.ConnectionPool;
import com.sun.enterprise.resource.pool.datastructure.DataStructureFactory;
import com.sun.enterprise.resource.pool.resizer.AssocWithThreadPoolResizer;
import com.sun.enterprise.resource.pool.resizer.Resizer;
import jakarta.transaction.Transaction;
import java.util.Hashtable;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class AssocWithThreadResourcePool
extends ConnectionPool {
    private ThreadLocal<AssocWithThreadResourceHandle> localResource = new ThreadLocal();

    public AssocWithThreadResourcePool(PoolInfo poolInfo, Hashtable env) throws PoolingException {
        super(poolInfo, env);
    }

    @Override
    protected void initializePoolDataStructure() throws PoolingException {
        this.dataStructure = DataStructureFactory.getDataStructure("com.sun.enterprise.resource.pool.datastructure.ListDataStructure", this.dataStructureParameters, this.maxPoolSize, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) {
        AssocWithThreadResourceHandle ar = this.localResource.get();
        if (ar != null) {
            Object object = ar.lock;
            synchronized (object) {
                if (ar.getThreadId() != Thread.currentThread().getId() || ar.hasConnectionErrorOccurred() || ar.isDirty() || !ar.isAssociated()) {
                    this.localResource.remove();
                    return null;
                }
                if (ar.getResourceState().isFree() && ar.getResourceState().isUnenlisted()) {
                    if (this.matchConnections) {
                        if (!alloc.matchConnection(ar)) {
                            this.localResource.remove();
                            ar.setAssociated(false);
                            if (this.poolLifeCycleListener != null) {
                                this.poolLifeCycleListener.connectionNotMatched();
                            }
                            return null;
                        }
                        if (this.poolLifeCycleListener != null) {
                            this.poolLifeCycleListener.connectionMatched();
                        }
                    }
                    if (!this.isConnectionValid(ar, alloc)) {
                        this.localResource.remove();
                        ar.setAssociated(false);
                        return null;
                    }
                    this.setResourceStateToBusy(ar);
                    if (this.maxConnectionUsage_ > 0) {
                        ar.incrementUsageCount();
                    }
                    if (this.poolLifeCycleListener != null) {
                        this.poolLifeCycleListener.connectionUsed(ar.getId());
                        this.poolLifeCycleListener.decrementNumConnFree();
                    }
                    return ar;
                }
            }
        }
        return null;
    }

    @Override
    protected Resizer initializeResizer() {
        return new AssocWithThreadPoolResizer(this.poolInfo, this.dataStructure, this, this, this.preferValidateOverRecreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInThreadLocal(AssocWithThreadResourceHandle h) {
        if (h != null) {
            Object object = h.lock;
            synchronized (object) {
                h.setThreadId(Thread.currentThread().getId());
                h.setAssociated(true);
                this.localResource.set(h);
            }
        }
    }

    @Override
    protected boolean isResourceUnused(ResourceHandle h) {
        if (h instanceof AssocWithThreadResourceHandle) {
            return h.getResourceState().isFree() && !((AssocWithThreadResourceHandle)h).isAssociated();
        }
        return h.getResourceState().isFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        Object object;
        ResourceHandle result = super.getUnenlistedResource(spec, alloc, tran);
        if (result != null) {
            object = result.lock;
            synchronized (object) {
                if (this.dataStructure.getAllResources().contains(result) && ((AssocWithThreadResourceHandle)result).isDirty()) {
                    this.dataStructure.removeResource(result);
                    result = null;
                }
            }
        }
        if (result == null) {
            object = this;
            synchronized (object) {
                for (ResourceHandle resource : this.dataStructure.getAllResources()) {
                    Object object2 = resource.lock;
                    synchronized (object2) {
                        if (resource.getResourceState().isUnenlisted() && resource.getResourceState().isFree() && !((AssocWithThreadResourceHandle)resource).isDirty()) {
                            if (!this.matchConnection(resource, alloc) || resource.hasConnectionErrorOccurred()) {
                                continue;
                            }
                            result = resource;
                            this.setResourceStateToBusy(result);
                            ((AssocWithThreadResourceHandle)result).setAssociated(false);
                            break;
                        }
                    }
                }
            }
        }
        if (this.localResource.get() == null && result instanceof AssocWithThreadResourceHandle) {
            this.setInThreadLocal((AssocWithThreadResourceHandle)result);
        }
        return result;
    }

    @Override
    protected synchronized void freeUnenlistedResource(ResourceHandle h) {
        if (this.cleanupResource(h) && h instanceof AssocWithThreadResourceHandle) {
            if (this.maxConnectionUsage_ > 0 && h.getUsageCount() >= this.maxConnectionUsage_) {
                this.performMaxConnectionUsageOperation(h);
            } else {
                if (!((AssocWithThreadResourceHandle)h).isAssociated()) {
                    this.dataStructure.returnResource(h);
                }
                if (this.poolLifeCycleListener != null) {
                    this.poolLifeCycleListener.decrementConnectionUsed(h.getId());
                    this.poolLifeCycleListener.incrementNumConnFree(false, this.steadyPoolSize);
                }
            }
            this.notifyWaitingThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResource(ResourceHandle resourceHandle) {
        try {
            super.deleteResource(resourceHandle);
        }
        finally {
            if (resourceHandle instanceof AssocWithThreadResourceHandle) {
                Object object = resourceHandle.lock;
                synchronized (object) {
                    ((AssocWithThreadResourceHandle)resourceHandle).setDirty();
                }
            }
        }
    }
}

