/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.web.logger.FileLoggerHandler;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.glassfish.main.jul.GlassFishLogger;

public final class VirtualServerGlassFishLogger
extends GlassFishLogger {
    public VirtualServerGlassFishLogger(String name, ResourceBundle rb) {
        super(name);
        this.setResourceBundle(rb);
    }

    public void log(LogRecord record) {
        ResourceBundle bundle;
        if (record.getResourceBundle() == null && (bundle = this.getResourceBundle()) != null) {
            record.setResourceBundle(bundle);
        }
        record.setThreadID((int)Thread.currentThread().getId());
        super.log(record);
    }

    public synchronized void addHandler(Handler handler) {
        super.addHandler(handler);
        if (handler instanceof FileLoggerHandler) {
            ((FileLoggerHandler)handler).associate();
        }
    }

    public synchronized void removeHandler(Handler handler) {
        if (!(handler instanceof FileLoggerHandler)) {
            super.removeHandler(handler);
        } else {
            boolean hasHandler = false;
            Handler[] hs = this.getHandlers();
            if (hs != null) {
                for (Handler h : hs) {
                    if (h != handler) continue;
                    hasHandler = true;
                    break;
                }
            }
            if (hasHandler) {
                super.removeHandler(handler);
                ((FileLoggerHandler)handler).disassociate();
            }
        }
    }
}

