/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class CreateIndexNode
extends DDLStatementNode {
    private boolean unique;
    private Properties properties;
    private String indexType;
    private TableName indexName;
    private TableName tableName;
    private List<String> columnNameList;
    private String[] columnNames;
    private boolean[] isAscending;
    private int[] boundColumnIDs;
    private TableDescriptor td;

    CreateIndexNode(boolean bl, String string, TableName tableName, TableName tableName2, List<String> list, Properties properties, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.unique = bl;
        this.indexType = string;
        this.indexName = tableName;
        this.tableName = tableName2;
        this.columnNameList = list;
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "CREATE INDEX";
    }

    @Override
    public void bindStatement() throws StandardException {
        this.getSchemaDescriptor();
        this.td = this.getTableDescriptor(this.tableName);
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        if (this.td.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(this.td.getTotalNumberOfIndexes()), this.tableName, String.valueOf(Short.MAX_VALUE));
        }
        this.verifyAndGetUniqueNames();
        int n = this.columnNames.length;
        this.boundColumnIDs = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[i], this.tableName);
            }
            this.boundColumnIDs[i] = columnDescriptor.getPosition();
            if (columnDescriptor.getType().getTypeId().orderable(this.getClassFactory())) continue;
            throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
        }
        if (n > 16) {
            throw StandardException.newException("54008", new Object[0]);
        }
        this.getCompilerContext().createDependency(this.td);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return CreateIndexNode.isSessionSchema(this.td.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        int n = this.columnNames.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnNames[i]);
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            n2 += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (n2 > 1024 && (this.properties == null || this.properties.get("derby.storage.pageSize") == null) && PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") == null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(false, this.unique, false, false, false, -1, this.indexType, schemaDescriptor.getSchemaName(), this.indexName.getTableName(), this.tableName.getTableName(), this.td.getUUID(), this.columnNames, this.isAscending, false, null, this.properties);
    }

    private void verifyAndGetUniqueNames() throws StandardException {
        int n = this.columnNameList.size();
        HashSet<String> hashSet = new HashSet<String>(n + 2, 0.999f);
        this.columnNames = new String[n];
        this.isAscending = new boolean[n];
        for (int i = 0; i < n; ++i) {
            boolean bl;
            this.columnNames[i] = this.columnNameList.get(i);
            if (this.columnNames[i].endsWith(" ")) {
                this.columnNames[i] = this.columnNames[i].substring(0, this.columnNames[i].length() - 1);
                this.isAscending[i] = false;
            } else {
                this.isAscending[i] = true;
            }
            boolean bl2 = bl = !hashSet.add(this.columnNames[i]);
            if (!bl) continue;
            throw StandardException.newException("42X66", this.columnNames[i]);
        }
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.indexName != null) {
            this.indexName = (TableName)this.indexName.accept(visitor);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(visitor);
        }
    }
}

