/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.formatter;

import java.util.Arrays;
import java.util.logging.LogRecord;
import org.glassfish.main.jul.cfg.LogProperty;
import org.glassfish.main.jul.formatter.FormatterConfigurationHelper;
import org.glassfish.main.jul.formatter.GlassFishLogFormatter;
import org.glassfish.main.jul.formatter.HandlerId;
import org.glassfish.main.jul.record.GlassFishLogRecord;

public class OneLineFormatter
extends GlassFishLogFormatter {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private int sizeOfLevel = 7;
    private int sizeOfThread = 20;
    private int sizeOfClass = 60;

    public OneLineFormatter(HandlerId handlerId) {
        super(handlerId, true, ISO_LOCAL_TIME);
        OneLineFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
        OneLineFormatter.configure(this, FormatterConfigurationHelper.forHandlerId(handlerId));
    }

    public OneLineFormatter() {
        super(true, ISO_LOCAL_TIME);
        OneLineFormatter.configure(this, FormatterConfigurationHelper.forFormatterClass(this.getClass()));
    }

    private static void configure(OneLineFormatter formatter, FormatterConfigurationHelper helper) {
        formatter.sizeOfLevel = helper.getNonNegativeInteger(OneLineFormatterProperty.SIZE_LEVEL, formatter.sizeOfLevel);
        formatter.sizeOfThread = helper.getNonNegativeInteger(OneLineFormatterProperty.SIZE_THREAD, formatter.sizeOfThread);
        formatter.sizeOfClass = helper.getNonNegativeInteger(OneLineFormatterProperty.SIZE_CLASS, formatter.sizeOfClass);
    }

    @Override
    public String formatRecord(LogRecord record) {
        return this.formatEnhancedLogRecord(MSG_RESOLVER.resolve(record));
    }

    @Override
    public String formatMessage(LogRecord record) {
        throw new UnsupportedOperationException("String formatMessage(LogRecord record)");
    }

    private String formatEnhancedLogRecord(GlassFishLogRecord record) {
        if (record.getMessage() == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getTimestampFormatter().format(record.getTime()));
        this.addPadded(record.getLevel(), this.sizeOfLevel, sb);
        this.addPadded(record.getThreadName(), this.sizeOfThread, sb);
        if (this.isPrintSource()) {
            this.addPadded(record.getSourceClassName(), this.sizeOfClass, sb);
            sb.append('.');
            if (record.getSourceMethodName() != null) {
                sb.append(record.getSourceMethodName());
            }
        } else {
            this.addPadded(record.getLoggerName(), this.sizeOfClass, sb);
        }
        sb.append(' ').append(record.getMessage());
        if (record.getThrown() != null) {
            sb.append(LINE_SEPARATOR);
            sb.append(record.getThrownStackTrace());
        }
        return sb.append(LINE_SEPARATOR).toString();
    }

    private void addPadded(Object value, int size, StringBuilder sb) {
        String text = value == null ? "" : String.valueOf(value);
        sb.append(' ');
        sb.append(this.getPad(text, size));
        sb.append(text.length() <= size ? text : text.substring(text.length() - size));
    }

    private char[] getPad(String text, int size) {
        int countOfSpaces = size - text.length();
        if (countOfSpaces <= 0) {
            return new char[0];
        }
        char[] spaces = new char[countOfSpaces];
        Arrays.fill(spaces, ' ');
        return spaces;
    }

    public static enum OneLineFormatterProperty implements LogProperty
    {
        SIZE_LEVEL("size.level"),
        SIZE_THREAD("size.thread"),
        SIZE_CLASS("size.class");

        private final String propertyName;

        private OneLineFormatterProperty(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

