/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.application;

import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.Map;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "jakarta.faces.STATE_SAVING_METHOD";
    public static final String PARTIAL_STATE_SAVING_PARAM_NAME = "jakarta.faces.PARTIAL_STATE_SAVING";
    public static final String FULL_STATE_SAVING_VIEW_IDS_PARAM_NAME = "jakarta.faces.FULL_STATE_SAVING_VIEW_IDS";
    public static final String IS_SAVING_STATE = "jakarta.faces.IS_SAVING_STATE";
    public static final String IS_BUILDING_INITIAL_STATE = "jakarta.faces.IS_BUILDING_INITIAL_STATE";
    public static final String SERIALIZE_SERVER_STATE_PARAM_NAME = "jakarta.faces.SERIALIZE_SERVER_STATE";
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    private Boolean savingStateInClient;

    public void writeState(FacesContext context, Object state) throws IOException {
    }

    public boolean isSavingStateInClient(FacesContext context) {
        if (this.savingStateInClient != null) {
            return this.savingStateInClient;
        }
        this.savingStateInClient = false;
        String saveStateParam = context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
        if (saveStateParam != null && saveStateParam.equalsIgnoreCase(STATE_SAVING_METHOD_CLIENT)) {
            this.savingStateInClient = true;
        }
        return this.savingStateInClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getViewState(FacesContext context) {
        Object savedView = null;
        if (context != null && !context.getViewRoot().isTransient()) {
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguage vdl = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, viewId);
            if (vdl != null) {
                Map<Object, Object> contextAttributes = context.getAttributes();
                try {
                    contextAttributes.put(IS_SAVING_STATE, Boolean.TRUE);
                    savedView = vdl.getStateManagementStrategy(context, viewId).saveView(context);
                }
                finally {
                    contextAttributes.remove(IS_SAVING_STATE);
                }
            }
        }
        return context.getRenderKit().getResponseStateManager().getViewState(context, savedView);
    }
}

