/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataFatalError;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import java.io.PrintWriter;

public class JDOMetaDataModelImpl
extends Support
implements JDOMetaData {
    protected final PrintWriter out;
    protected Model model;

    public JDOMetaDataModelImpl(Model model) {
        this(model, null);
    }

    public JDOMetaDataModelImpl(Model model, PrintWriter out) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (model == null) {
            String msg = "Initializing meta data: model == null";
            throw new JDOMetaDataFatalError("Initializing meta data: model == null");
        }
        this.model = model;
        this.out = out;
    }

    @Override
    public boolean isTransientClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (classPath.startsWith("java/")) {
            return true;
        }
        if (classPath.startsWith("javax/")) {
            return true;
        }
        return classPath.startsWith("com/sun/jdo/");
    }

    @Override
    public boolean isPersistenceCapableClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (this.isTransientClass(classPath)) {
            return false;
        }
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isPersistent(className);
    }

    @Override
    public boolean isPersistenceCapableRootClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isPersistent(className);
    }

    @Override
    public String getPersistenceCapableRootClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistenceCapableClass(classPath) ? classPath : null;
    }

    @Override
    public String getSuperClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return null;
    }

    @Override
    public boolean isSecondClassObjectType(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isSecondClassObject(className);
    }

    @Override
    public boolean isMutableSecondClassObjectType(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isMutableSecondClassObject(className);
    }

    @Override
    public boolean isPersistentField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isPersistent(className, fieldName);
    }

    @Override
    public boolean isTransactionalField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return false;
    }

    @Override
    public boolean isPrimaryKeyField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        return this.model.isKey(className, fieldName);
    }

    @Override
    public boolean isDefaultFetchGroupField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        PersistenceFieldElement pfe;
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        boolean isdfgField = this.model.isDefaultFetchGroup(className, fieldName);
        if (isdfgField && (pfe = this.model.getPersistenceField(className, fieldName)) instanceof RelationshipElement) {
            isdfgField = false;
        }
        return isdfgField;
    }

    @Override
    public int getFieldNo(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        PersistenceFieldElement pfe = this.model.getPersistenceField(className, fieldName);
        if (pfe == null || pfe.getPersistenceType() != 0) {
            return -1;
        }
        return pfe.getFieldNumber();
    }

    private final String[] getPersistentFields(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String className = JDOMetaDataModelImpl.pathToName(classPath);
        PersistenceClassElement pce = this.model.getPersistenceClass(className);
        if (pce == null) {
            return new String[0];
        }
        PersistenceFieldElement[] pfes = pce.getFields();
        int nofFields = pfes != null ? pfes.length : 0;
        String[] names = new String[nofFields];
        for (int i = 0; i < nofFields; ++i) {
            PersistenceFieldElement pfe = pfes[i];
            names[i] = pfe.getName();
        }
        return names;
    }

    @Override
    public String[] getManagedFields(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.getPersistentFields(classPath);
    }

    protected static String pathToName(String classPath) {
        if (classPath != null) {
            return classPath.replace('/', '.');
        }
        return null;
    }

    protected static String nameToPath(String className) {
        if (className != null) {
            return className.replace('.', '/');
        }
        return null;
    }
}

