/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;

public final class DeprecatedMpConfig {
    private static final Logger LOGGER = Logger.getLogger(DeprecatedMpConfig.class.getName());

    private DeprecatedMpConfig() {
    }

    public static <T> Optional<T> getConfigValue(Config config, Class<T> type, String currentKey, String deprecatedKey) {
        Optional deprecatedConfig = config.getOptionalValue(deprecatedKey, type);
        Optional currentConfig = config.getOptionalValue(currentKey, type);
        if (deprecatedConfig.isPresent()) {
            if (currentConfig.isPresent()) {
                LOGGER.warning("You are using both a deprecated configuration and a current one. Deprecated key: \"" + deprecatedKey + "\", current key: \"" + currentKey + "\", only the current key will be used, and deprecated will be ignored.");
                return currentConfig;
            }
            LOGGER.warning("You are using a deprecated configuration key. Deprecated key: \"" + deprecatedKey + "\", current key: \"" + currentKey + "\".");
            return deprecatedConfig;
        }
        return currentConfig;
    }
}

