/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.remote.RemoteRestAdminCommand;
import com.sun.enterprise.admin.remote.ServerRemoteRestAdminCommand;
import com.sun.enterprise.admin.util.RemoteInstanceCommandHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.StartInstanceCommand;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="restart.instance.command")
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_restart-instance", description="_restart-instance"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="restart-instance", description="restart-instance", params={@RestParam(name="id", value="$parent")})})
public class RestartInstanceCommand
implements AdminCommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ServerEnvironment env;
    @Param(optional=false, primary=true)
    private String instanceName;
    @Param(name="debug", optional=true)
    private String debug;
    @Param(optional=true)
    private Integer timeout;
    private Logger logger;
    private RemoteInstanceCommandHelper helper;
    private ActionReport report;
    private Server instance;
    private String host;
    private int port;
    private String oldPid;
    private AdminCommandContext ctx;

    public void execute(AdminCommandContext context) {
        try {
            this.ctx = context;
            this.helper = new RemoteInstanceCommandHelper(this.habitat);
            this.report = context.getActionReport();
            this.logger = context.getLogger();
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            if (!this.env.isDas()) {
                this.setError(Strings.get("restart.instance.notDas", this.env.getRuntimeType().toString()));
            }
            this.prepare();
            this.setOldPid();
            this.logger.log(Level.FINE, () -> "Restart-instance old-pid = " + this.oldPid);
            this.callInstance();
            if (!this.isError() && !this.waitForRestart()) {
                this.setError(Strings.get("restart.instance.timeout", this.instanceName));
            }
            if (!this.isError()) {
                String msg = Strings.get("restart.instance.success", this.instanceName);
                this.logger.info(msg);
                this.report.setMessage(msg);
            }
        }
        catch (InstanceNotRunningException inre) {
            this.start();
        }
        catch (CommandException ce) {
            this.setError(Strings.get("restart.instance.racError", this.instanceName, ce.getLocalizedMessage()));
        }
    }

    private void prepare() throws InstanceNotRunningException {
        if (this.isError()) {
            return;
        }
        if (!StringUtils.ok((String)this.instanceName)) {
            this.setError(Strings.get("stop.instance.noInstanceName"));
            return;
        }
        this.instance = this.helper.getServer(this.instanceName);
        if (this.instance == null) {
            this.setError(Strings.get("stop.instance.noSuchInstance", this.instanceName));
            return;
        }
        this.host = this.instance.getAdminHost();
        if (this.host == null) {
            this.setError(Strings.get("stop.instance.noHost", this.instanceName));
            return;
        }
        this.port = this.helper.getAdminPort(this.instance);
        if (this.port < 0) {
            this.setError(Strings.get("stop.instance.noPort", this.instanceName));
            return;
        }
        if (!this.isInstanceRestartable()) {
            this.setError(Strings.get("restart.notRestartable", this.instanceName));
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer(ObjectAnalyzer.toString((Object)this));
        }
    }

    private void callInstance() throws CommandException {
        if (this.isError()) {
            return;
        }
        RemoteRestAdminCommand rac = this.createRac("_restart-instance");
        ParameterMap map = new ParameterMap();
        if (this.debug != null) {
            map.add((Object)"debug", (Object)this.debug);
        }
        rac.executeCommand(map);
    }

    private boolean isInstanceRestartable() throws InstanceNotRunningException {
        RemoteRestAdminCommand rac;
        if (this.isError()) {
            return false;
        }
        String cmdName = "_get-runtime-info";
        try {
            rac = this.createRac(cmdName);
            rac.executeCommand(new ParameterMap());
        }
        catch (CommandException ex) {
            throw new InstanceNotRunningException();
        }
        String val = rac.findPropertyInReport("restartable");
        return val == null || !val.equals("false");
    }

    private boolean waitForRestart() {
        return ProcessUtils.waitFor(() -> {
            try {
                String newpid = this.getPid();
                if (newpid != null && !newpid.equals(this.oldPid)) {
                    this.logger.log(Level.INFO, "Restarted instance pid = {0}", newpid);
                    return true;
                }
            }
            catch (CommandException commandException) {
                // empty catch block
            }
            return false;
        }, (Duration)StartInstanceCommand.getTimeout(this.timeout), (boolean)false);
    }

    private RemoteRestAdminCommand createRac(String cmdName) throws CommandException {
        return new ServerRemoteRestAdminCommand(this.habitat, cmdName, this.host, this.port, false, "admin", null, this.logger);
    }

    private void setError(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }

    private void setSuccess(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        this.report.setMessage(s);
    }

    private boolean isError() {
        return this.report.getActionExitCode() == ActionReport.ExitCode.FAILURE;
    }

    private void setOldPid() throws CommandException {
        if (this.isError()) {
            return;
        }
        this.oldPid = this.getPid();
        if (!StringUtils.ok((String)this.oldPid)) {
            this.setError(Strings.get("restart.instance.nopid", this.instanceName));
        }
    }

    private String getPid() throws CommandException {
        String cmdName = "_get-runtime-info";
        RemoteRestAdminCommand rac = this.createRac(cmdName);
        rac.executeCommand(new ParameterMap());
        return rac.findPropertyInReport("pid");
    }

    private void start() {
        try {
            StartInstanceCommand sic = new StartInstanceCommand(this.habitat, this.instanceName, Boolean.parseBoolean(this.debug), this.timeout, this.env);
            sic.execute(this.ctx);
        }
        catch (Exception e) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause((Throwable)e);
        }
        String messageFromStartCommand = this.report.getMessage();
        if (this.isError()) {
            this.setError(Strings.get("restart.instance.startFailed", messageFromStartCommand));
        } else {
            this.setSuccess(Strings.get("restart.instance.startSucceeded", messageFromStartCommand));
        }
    }

    private static class InstanceNotRunningException
    extends Exception {
        private static final long serialVersionUID = 1957218902901618942L;

        private InstanceNotRunningException() {
        }
    }
}

