/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.ejbcontext.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.lite.ejbcontext.common.Util;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBContext;
import jakarta.ejb.SessionContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.naming.Context;

public class Interceptor1 {
    @Resource
    private EJBContext ejbContext;
    private SessionContext sessionContext;
    private EJBContext ejbContextFromDescriptorInjection;
    private EJBContext[] injectedEJBContexts = new EJBContext[3];
    private List<String> injectionRecords = new ArrayList<String>();
    private List<EJBContext> lookupValuesInPostConstruct = new ArrayList<EJBContext>();
    private List<EJBContext> lookupValuesInAroundInvoke = new ArrayList<EJBContext>();

    @Resource
    private void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PreDestroy
    private void preDestroy0(InvocationContext inv) {
        Helper.preDestroy(this);
    }

    @PostConstruct
    private void postConstruct(InvocationContext inv) {
        this.injectedEJBContexts[0] = this.ejbContext;
        this.injectedEJBContexts[1] = this.sessionContext;
        this.injectedEJBContexts[2] = this.ejbContextFromDescriptorInjection;
        Helper.getLogger().logp(Level.FINE, "Interceptor1", "postConstruct", String.format("ejbContext= %s%n sessionContext= %s%n ejbContextFromDescriptorInjection= %s%n", this.ejbContext, this.sessionContext, this.ejbContextFromDescriptorInjection));
        try {
            Util.postConstruct0(this.injectionRecords, this.lookupValuesInPostConstruct, this.injectedEJBContexts);
            inv.proceed();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @AroundInvoke
    private Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        Helper.assertEquals("lookupValuesInAroundInvoke must be empty ", 0, this.lookupValuesInAroundInvoke.size());
        if (methodName.equals("getInjectionRecordsInInterceptor")) {
            return this.injectionRecords;
        }
        if (methodName.equals("lookupEJBContextInInterceptor")) {
            for (String nm : Util.lookupNames) {
                EJBContext ec = (EJBContext)ServiceLocator.lookupNoTry(nm, new Context[0]);
                this.lookupValuesInAroundInvoke.add(ec);
            }
            String result = this.lookupEJBContextInInterceptor();
            this.lookupValuesInAroundInvoke.clear();
            return result;
        }
        return inv.proceed();
    }

    private String lookupEJBContextInInterceptor() {
        StringBuilder sb = new StringBuilder();
        Helper.assertEquals("", Util.lookupNames.length, this.lookupValuesInPostConstruct.size(), sb);
        for (EJBContext ec : this.lookupValuesInPostConstruct) {
            Helper.assertNotEquals("", null, ec, sb);
        }
        Helper.assertEquals("", Util.lookupNames.length, this.lookupValuesInAroundInvoke.size(), sb);
        for (EJBContext ec : this.lookupValuesInAroundInvoke) {
            Helper.assertNotEquals("", null, ec, sb);
        }
        return sb.toString();
    }
}

