/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.client;

import com.sun.ts.tests.common.webclient.WebTestCase;
import com.sun.ts.tests.common.webclient.http.HttpRequest;
import com.sun.ts.tests.jstl.common.JstlTckConstants;
import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class SqlUrlClient
extends AbstractUrlClient
implements JstlTckConstants {
    protected Properties dbArgs = new Properties();

    @Override
    @BeforeEach
    public void setup() throws Exception {
        for (int i = 0; i < JSTL_DB_PROPS.length; ++i) {
            String s = System.getProperty(JSTL_DB_PROPS[i]);
            Assertions.assertTrue((!this.isNullOrEmpty(s) ? 1 : 0) != 0, (String)("[SqlUrlClient] '" + JSTL_DB_PROPS[i] + "' was not set."));
            if (s == null) continue;
            this.dbArgs.setProperty(JSTL_DB_PROPS[i], s.trim());
        }
        super.setup();
    }

    @Override
    public void setTestProperties(WebTestCase testCase) {
        super.setTestProperties(testCase);
        HttpRequest httpReq = testCase.getRequest();
        Enumeration<?> enumm = this.dbArgs.propertyNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String value = this.dbArgs.getProperty(name);
            httpReq.addRequestHeader(name, value);
        }
    }

    private String aggregateParams(String url) {
        StringBuffer newParams = new StringBuffer();
        Enumeration<?> enumm = this.dbArgs.propertyNames();
        int size = this.dbArgs.size();
        int i = 0;
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            String value = this.dbArgs.getProperty(name);
            newParams.append(name + "=" + value);
            if (i < size - 1) {
                newParams.append("&");
            }
            ++i;
        }
        if (newParams.length() > 0) {
            int questionMark = url.indexOf(63);
            StringBuffer workingUrl = new StringBuffer(url);
            if (questionMark == -1) {
                int httpMark = url.indexOf("HTTP/");
                workingUrl.insert(httpMark - 1, "?" + String.valueOf(newParams));
            } else {
                workingUrl.insert(questionMark + 1, String.valueOf(newParams) + "&");
            }
            return workingUrl.toString();
        }
        return url;
    }
}

