/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.etu.config;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_etu_config_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_etu_config_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_etu_config_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigStaticMemebersTest.jsp")), "positiveConfigStaticMemebersTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigGetSetRemoveSessionTest.jsp")), "positiveConfigGetSetRemoveSessionTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigGetSetRemoveRequestTest.jsp")), "positiveConfigGetSetRemoveRequestTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigGetSetRemovePageContextTest.jsp")), "positiveConfigGetSetRemovePageContextTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigGetSetRemoveApplicationTest.jsp")), "positiveConfigGetSetRemoveApplicationTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveConfigFindTest.jsp")), "positiveConfigFindTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveConfigStaticMembersTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveConfigStaticMemebersTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveConfigStaticMemebersTest");
        this.invoke();
    }

    @Test
    public void positiveConfigGetSetRemovePageContextTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveConfigGetSetRemovePageContextTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveConfigGetSetRemovePageContextTest");
        this.invoke();
    }

    @Test
    public void positiveConfigGetSetRemoveRequestTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveConfigGetSetRemoveRequestTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveConfigGetSetRemoveRequestTest");
        this.invoke();
    }

    @Test
    public void positiveConfigGetSetRemoveSessionTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jstl_etu_config_web/positiveConfigGetSetRemoveSessionTest.jsp HTTP/1.0");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "Test FAILED");
        this.invoke();
    }

    @Test
    public void positiveConfigGetSetRemoveApplicationTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveConfigGetSetRemoveApplicationTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveConfigGetSetRemoveApplicationTest");
        this.invoke();
    }

    @Test
    public void positiveConfigFindTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveConfigFindTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveConfigFindTest");
        this.invoke();
    }
}

