/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.security.secform;

import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.WebUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class secformClient {
    private static final System.Logger logger = System.getLogger(secformClient.class.getName());
    private String protocol = "http";
    private String hostname = null;
    private int portnum = 0;
    protected String pageBase = null;
    protected String pageSec = null;
    protected String pageGuest = null;
    protected String pageRoleReverse = null;
    protected String pageUnprotected = null;
    private String pageProgAuthen = null;
    private String pageProgLogin = null;
    private String pageProgLogout = null;
    private String pageOne = null;
    private String pageTwo = null;
    private String pageSample = null;
    private String pageallRoles = null;
    private String pageLogin = "/login.jsp";
    private String pageError = "/error.jsp";
    private String pageSecurityCheck = "/j_security_check";
    private String pageJspBase = "/jsp_sec_secform_web";
    private String pageJspSec = this.pageJspBase + "/jspSec.jsp";
    private String pageJspUnprotected = this.pageJspBase + "/unprotected.jsp";
    private String pageJspGuest = this.pageJspBase + "/guestPage.jsp";
    private String pageJspRoleReverse = this.pageJspBase + "/rolereverse.jsp";
    private String pageJspOne = this.pageJspBase + "/One.jsp";
    private String pageJspTwo = this.pageJspBase + "/Two.jsp";
    private String pageJspSample = this.pageJspBase + "/Sample.jsp";
    private String pageJspallRoles = this.pageJspBase + "/allRoles.jsp";
    private String pageServletBase = "/servlet_sec_secform_web";
    private String pageServletSec = this.pageServletBase + "/ServletSecTest";
    private String pageServletUnprotected = this.pageServletBase + "/UnProtectedTest";
    private String pageServletProgLogin = this.pageServletBase + "/ServletProgrammaticLogin";
    private String pageServletProgLogout = this.pageServletBase + "/ServletProgrammaticLogout";
    private String pageServletProgAuthen = this.pageServletBase + "/ServletProgrammaticAuthen";
    private String pageServletGuest = this.pageServletBase + "/GuestPageTest";
    private String pageServletRoleReverse = this.pageServletBase + "/RoleReverseTest";
    private String pageServletOne = this.pageServletBase + "/OneTest";
    private String pageServletTwo = this.pageServletBase + "/TwoTest";
    private String pageServletSample = this.pageServletBase + "/SampleTest";
    private String pageServletallRoles = this.pageServletBase + "/allRolesTest";
    private String searchFor = "The user principal is: ";
    private String searchForGetRemoteUser = "getRemoteUser(): ";
    private static final String CLASS_TRACE_HEADER = "[secformClient]: ";
    private String username = "";
    private String password = "";
    private String unauthUsername = "";
    private String unauthPassword = "";
    private String tshome = "";
    private final String WebHostProp = "webServerHost";
    private final String WebPortProp = "webServerPort";
    private final String UserNameProp = "user";
    private final String PasswordProp = "password";
    private final String unauthUserNameProp = "authuser";
    private final String unauthPasswordProp = "authpassword";
    private final String tsHomeProp = "ts_home";
    private String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private String request = null;
    private WebUtil.Response response = null;
    private WebUtil.Response loginPageRequestResponse = null;
    private WebUtil.Response errorPageRequestResponse = null;
    private Hashtable cookies = null;
    private TSURL tsurl = new TSURL();
    @ArquillianResource
    @OperateOnDeployment(value="_DEFAULT_")
    public URL url;

    protected boolean isNullOrEmpty(String val) {
        return val == null || val.equals("");
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.INFO, "setup method secformClient");
        if (this.url == null) {
            throw new Exception("[secformClient] The url was not injected");
        }
        this.hostname = this.url.getHost().trim();
        Assertions.assertFalse((boolean)this.isNullOrEmpty(this.hostname), (String)"[secformClient] 'webServerHost' was not set.");
        this.portnum = this.url.getPort();
        Assertions.assertFalse((boolean)this.isNullOrEmpty(Integer.toString(this.portnum)), (String)"[secformClient] 'webServerPort' was not set.");
        try {
            this.username = System.getProperty("user").trim();
            this.password = System.getProperty("password").trim();
            this.unauthUsername = System.getProperty("authuser").trim();
            this.unauthPassword = System.getProperty("authpassword").trim();
            secformClient.logMessage("username: " + this.username);
            secformClient.logMessage("password: " + this.password);
            this.pageBase = this.pageJspBase;
            this.pageSec = this.pageJspSec;
            this.pageGuest = this.pageJspGuest;
            this.pageUnprotected = this.pageJspUnprotected;
            this.pageRoleReverse = this.pageJspRoleReverse;
            this.pageOne = this.pageJspOne;
            this.pageTwo = this.pageJspTwo;
            this.pageSample = this.pageJspSample;
            this.pageallRoles = this.pageJspallRoles;
            this.pageLogin = this.pageJspBase + this.pageLogin;
            this.pageError = this.pageJspBase + this.pageError;
            this.pageSecurityCheck = this.pageJspBase + this.pageSecurityCheck;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: got exception: " + String.valueOf(e));
        }
        logger.log(System.Logger.Level.INFO, "[secformClient] Test setup OK");
    }

    public void test1() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 1);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.logMessage("response.statusToken:" + this.response.statusToken);
            secformClient.logMessage("response.content:" + this.response.content);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test1 failed.");
            }
            this.response = this.followRedirect(this.response, 1);
            secformClient.logMessage("received response content  1: " + this.response.content);
            String searchString = this.searchFor + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("getRemoteUser() did not return " + this.username + ":");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("getRemoteUser() correct.");
            Hashtable<String, Boolean> roleCheck = new Hashtable<String, Boolean>();
            roleCheck.put("ADM", new Boolean(true));
            roleCheck.put("MGR", new Boolean(false));
            roleCheck.put("VP", new Boolean(false));
            roleCheck.put("EMP", new Boolean(true));
            if (!this.checkRoles(this.response.content, roleCheck)) {
                secformClient.logError("isUserInRole() does not work correctly.");
                secformClient.logError("Page Received:");
                secformClient.logError(this.response.content);
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("isUserInRole() correct.");
            this.request = this.pageSec;
            secformClient.logMessage("Cookies =" + this.cookies.toString());
            secformClient.logMessage("Re-sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.pageSec);
                throw new Exception("test1 failed.");
            }
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("User Principal still correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("getRemoteUser() did not return " + this.username + " after lazy authentication:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("getRemoteUser() still correct.");
            if (!this.checkRoles(this.response.content, roleCheck)) {
                secformClient.logError("isUserInRole() does not work correctly.");
                secformClient.logError("Page Received:");
                secformClient.logError(this.response.content);
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("isUserInRole() still correct.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test1 failed: ", e);
        }
    }

    public void test2() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 2);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with incorrect login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", "incorrect" + this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.logMessage("response.statusToken:" + this.response.statusToken);
            this.response = this.followRedirect(this.response, 2);
            String searchString = this.searchFor + "null";
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User principal is not null in error page:");
                secformClient.logError(this.response.content);
                throw new Exception("test2 failed.");
            }
            secformClient.logMessage("User Principal is null as expected.");
            this.request = this.pageError;
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.errorPageRequestResponse = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, (Hashtable)this.cookies);
            if (this.errorPageRequestResponse.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test2  failed.");
            }
            if (!this.response.content.equals(this.errorPageRequestResponse.content)) {
                secformClient.logMessage("Received incorrect error page");
                throw new Exception("test2  failed.");
            }
            secformClient.logMessage("Received the expected error page");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test2 failed: ", e);
        }
    }

    public void test3() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageGuest, 3);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information (as " + this.unauthUsername + ").");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.unauthUsername);
            postData.setProperty("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test3 failed.");
            }
            this.response = this.followRedirect(this.response, 3);
            String searchString = this.searchFor + this.unauthUsername;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test3 failed.");
            }
            secformClient.logMessage("User Principal correct.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test3 failed: ", e);
        }
    }

    public void test4() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 4);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with correct login information (" + this.unauthUsername + "), but incorrect authorization for this resource.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.unauthUsername);
            postData.setProperty("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.logMessage("response.content = " + this.response.content);
            if (this.response.statusToken.equals("302")) {
                if (this.response.location == null) {
                    secformClient.logError("No redirection to login page received.");
                    throw new Exception("test4 failed.");
                }
                this.request = WebUtil.getRequestFromURL((String)this.response.location);
                secformClient.logMessage("Redirect to: " + this.response.location);
                this.addNewCookies(this.cookies, this.response.cookies);
                secformClient.logMessage("Sending request \"" + this.request + "\"");
                this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, (Hashtable)this.cookies);
            }
            if (!this.response.statusToken.equals("403") && !this.response.statusToken.equals("404")) {
                secformClient.logError("Did not receive error for unauthorized access: " + this.request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content:");
                secformClient.logError(this.response.content);
                throw new Exception("test4 failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected unauthorized access error");
            this.request = this.pageUnprotected;
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            if (this.response.isError()) {
                secformClient.logError("Error retrieving " + this.request);
                throw new Exception("test4 failed.");
            }
            String searchString = this.searchFor;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("Incorrect page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should contain: \"" + searchString + "\")");
                throw new Exception("test4 failed.");
            }
            secformClient.logMessage("Access to unprotected page granted.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test4 failed: ", e);
        }
    }

    public void test5() throws Exception {
        try {
            String request = this.pageUnprotected;
            secformClient.logMessage("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(request), null, null);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.pageUnprotected);
                throw new Exception("test5 failed.");
            }
            if (this.response.isError()) {
                secformClient.logError("Error retrieving " + request);
                throw new Exception("test5 failed.");
            }
            Object searchString = this.searchFor;
            if (this.response.content.indexOf((String)searchString) == -1) {
                secformClient.logError("Incorrect page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should contain: \"" + (String)searchString + "\")");
                throw new Exception("test5 failed.");
            }
            secformClient.logMessage("Access to unprotected page granted.");
            secformClient.logMessage("Checking isUserInRole...");
            searchString = "!true!";
            if (this.response.content.indexOf((String)searchString) != -1) {
                secformClient.logError("At least one call to isUserInRole returned true.");
                secformClient.logError("Page received:");
                secformClient.logError(this.response.content);
                throw new Exception("test5 failed.");
            }
            secformClient.logMessage("isUserInRole test passed.");
            secformClient.logMessage("Checking getRemoteUser()...");
            searchString = this.searchForGetRemoteUser + "null";
            if (this.response.content.indexOf((String)searchString) == -1) {
                secformClient.logError("A call to getRemoteUser() did not return null.");
                secformClient.logError("Page received:");
                secformClient.logError(this.response.content);
                throw new Exception("test5 failed.");
            }
            secformClient.logMessage("getRemoteUser() test passed.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test5 failed: ", e);
        }
    }

    public void test6() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageRoleReverse, 6);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information (as " + this.username + ").");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test6 failed.");
            }
            this.response = this.followRedirect(this.response, 6);
            String searchString = this.searchFor + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test6 failed.");
            }
            secformClient.logMessage("User Principal correct.");
            Hashtable<String, Boolean> roleCheck = new Hashtable<String, Boolean>();
            roleCheck.put("ADM", new Boolean(false));
            roleCheck.put("MGR", new Boolean(true));
            roleCheck.put("VP", new Boolean(false));
            roleCheck.put("EMP", new Boolean(true));
            if (!this.checkRoles(this.response.content, roleCheck)) {
                secformClient.logError("isUserInRole() does not work correctly.");
                secformClient.logError("Page Received:");
                secformClient.logError(this.response.content);
                throw new Exception("test6 failed.");
            }
            secformClient.logMessage("isUserInRole() correct.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test6 failed: ", e);
        }
    }

    public void test7() {
        try {
            this.request = this.pageBase + "/WEB-INF/";
            ArrayList<String> statusCodes = new ArrayList<String>();
            statusCodes.add("404");
            statusCodes.add("403");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/web-inf/";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            statusCodes.add("403");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/WEB-INF/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/web-inf/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/WEB-INF/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void test8() throws Exception {
        try {
            this.request = this.pageBase + "/META-INF/";
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                secformClient.logError("Did not receive expected error code" + this.request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content:");
                secformClient.logError(this.response.content);
                throw new Exception("test8 failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected error code");
            this.request = this.pageBase + "/meta-inf/";
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                secformClient.logError("Did not receive expected error code" + this.request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content:");
                secformClient.logError(this.response.content);
                throw new Exception("test8 failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected error code");
            this.request = this.pageBase + "/META-INF/MANIFEST.MF";
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                secformClient.logError("Did not receive expected error code" + this.request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content:");
                secformClient.logError(this.response.content);
                throw new Exception("test8 failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected error code");
            this.request = this.pageBase + "/meta-inf/manifest.mf";
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                secformClient.logError("Did not receive expected error code" + this.request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content:");
                secformClient.logError(this.response.content);
                throw new Exception("test8 failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected error code");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test8 failed: ", e);
        }
    }

    public void test9() throws Exception {
        try {
            String testURL = null;
            String exactMatchURL = null;
            testURL = this.pageBase + "/One/index.html";
            exactMatchURL = this.pageOne;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/One/*";
            exactMatchURL = this.pageOne;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/*.jsp";
            exactMatchURL = this.pageTwo;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/*.two";
            exactMatchURL = this.pageTwo;
            this.compareURLContents(testURL, 9, exactMatchURL);
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test9 failed: ", e);
        }
    }

    public void test10() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSample, 10);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test10 failed.");
            }
            this.response = this.followRedirect(this.response, 10);
            String searchString = this.searchFor + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test10 failed.");
            }
            secformClient.logMessage("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("getRemoteUser() did not return " + this.username + ":");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test10 failed.");
            }
            secformClient.logMessage("getRemoteUser() correct.");
            Hashtable<String, Boolean> roleCheck = new Hashtable<String, Boolean>();
            roleCheck.put("Administrator", new Boolean(true));
            if (!this.checkRoles(this.response.content, roleCheck)) {
                secformClient.logError("isUserInRole() does not work correctly.");
                secformClient.logError("Page Received:");
                secformClient.logError(this.response.content);
                throw new Exception("test10 failed.");
            }
            secformClient.logMessage("isUserInRole() correct.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test10 failed: ", e);
        }
    }

    public void test11() throws Exception {
        try {
            secformClient.logMessage("\nAccessing allRoles.jsp as user j2ee");
            this.requestAndGetLoginPage(this.pageallRoles, 11);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test11 failed.");
            }
            this.response = this.followRedirect(this.response, 11);
            secformClient.logMessage("Successfully accessed allRoles.jsp as user j2ee");
            secformClient.logMessage("\nAccessing allRoles.jsp as user javajoe");
            this.requestAndGetLoginPage(this.pageallRoles, 11);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            postData = new Properties();
            postData.setProperty("j_username", this.unauthUsername);
            postData.setProperty("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test11 failed.");
            }
            this.response = this.followRedirect(this.response, 11);
            secformClient.logMessage("Successfully accessed allRoles.jsp as user javajoe");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test11 failed: ", e);
        }
    }

    public void test12() throws Exception {
        try {
            secformClient.logMessage("\nAccessing pageSample Using HTTP method POST");
            this.requestAndGetLoginPage(this.pageSample, 12);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            secformClient.logMessage("response.content :" + this.response.content);
            secformClient.logMessage("Successfully accessed " + this.pageSample + " with \"POST\"");
            this.request = this.pageSample;
            secformClient.logMessage("\nAccessing pageSample Using HTTP method GET");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            secformClient.logMessage("response.content :" + this.response.content);
            secformClient.logMessage("Successfully accessed " + this.pageSample + " with \"GET\"");
            secformClient.logMessage("\nAccessing pageSample Using HTTP method HEAD");
            this.response = WebUtil.sendRequest((String)"HEAD", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            secformClient.logMessage("response.content :" + this.response.content);
            secformClient.logMessage("Successfully accessed " + this.pageSample + " with \"HEAD\"");
            FileInputStream fstream = new FileInputStream(this.tshome + "/src/web/jsp/sec/secform/Sample.jsp");
            int fileContentLength = fstream.available();
            byte[] byteArray = new byte[1024];
            int bytesRead = fstream.read(byteArray, 0, fileContentLength);
            secformClient.logMessage("\nDELETE " + this.pageSample + " Using HTTP method DELETE ....");
            this.response = WebUtil.sendRequest((String)"DELETE", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            this.addNewCookies(this.cookies, this.response.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            secformClient.logMessage("response.content :" + this.response.content);
            secformClient.logMessage("Successfully accessed " + this.pageSample + " with \"DELETE\"");
            secformClient.logMessage("\nPUT " + this.pageSample + " Using HTTP method PUT ....");
            this.response = secformClient.uploadUsingHttpMethodPUT("PUT", InetAddress.getByName(this.hostname), this.portnum, this.tsurl.getRequest(this.request), byteArray, this.cookies, this.username, this.password);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            secformClient.logMessage("response.content :" + this.response.content);
            secformClient.logMessage("response.statusToken :" + this.response.statusToken);
            secformClient.logMessage("uploaded " + this.pageSample + "using HTTP method PUT");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test12 failed: ", e);
        }
    }

    public void test13() throws Exception {
        try {
            this.request = this.pageServletBase + "/ControlServlet";
            secformClient.logMessage("\nAccessing ControlServlet");
            secformClient.logMessage("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, null);
            secformClient.logMessage("response.content 1:" + this.response.content);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test13 failed.");
            }
            this.response = this.followRedirect(this.response, 13);
            secformClient.logMessage("response.content 2:" + this.response.content);
            secformClient.logMessage("Successfully accessed ControlServlet, ForwardedServlet and IncludedServlet");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test13 failed: ", e);
        }
    }

    public void test14() throws Exception {
        try {
            secformClient.logMessage("\nAccessing  pageSec: " + this.pageSec);
            this.requestAndGetLoginPage(this.pageSec, 14);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test14 failed.");
            }
            this.response = this.followRedirect(this.response, 14);
            String searchString = this.searchFor + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            secformClient.logMessage("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("getRemoteUser() did not return " + this.username + ":");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            secformClient.logMessage("getRemoteUser() correct.");
            Hashtable<String, Boolean> roleCheck = new Hashtable<String, Boolean>();
            roleCheck.put("ADM", new Boolean(true));
            roleCheck.put("MGR", new Boolean(false));
            roleCheck.put("VP", new Boolean(false));
            roleCheck.put("EMP", new Boolean(true));
            if (!this.checkRoles(this.response.content, roleCheck)) {
                secformClient.logError("isUserInRole() does not work correctly.");
                secformClient.logError("Page Received:");
                secformClient.logError(this.response.content);
                throw new Exception("test14 failed.");
            }
            secformClient.logMessage("isUserInRole() correct.");
            this.request = this.pageSample;
            secformClient.logMessage("\nAccessing pageSample :" + this.request);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), null, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.pageSec);
                throw new Exception("test14 failed.");
            }
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("User Principal incorrect.  Page received:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            secformClient.logMessage("User Principal still correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError("getRemoteUser() did not return " + this.username + " after lazy authentication:");
                secformClient.logError(this.response.content);
                secformClient.logError("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            secformClient.logMessage("getRemoteUser() still correct.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test14 failed: ", e);
        }
    }

    public void test15() throws Exception {
        String modifiedPageSec = this.pageSec + this.pageSecurityCheck;
        try {
            secformClient.trace("Sending request \"" + modifiedPageSec + "\"");
            try {
                this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(modifiedPageSec), null, null);
            }
            catch (Exception ex) {
                secformClient.logError("ERROR - got exception when trying to access restricted page w/out AuthN first.");
                ex.printStackTrace();
                throw new Exception("test15 failed.");
            }
            if (this.response != null) {
                secformClient.trace("response.content=" + this.response.content);
                String searchString = "getAuthType()";
                if (this.response.content.indexOf(searchString) != -1) {
                    Object err = "Error - we were not authenticated but were able to access the ";
                    err = (String)err + "following page: " + modifiedPageSec + " with a return status = " + this.response.statusToken;
                    secformClient.logError((String)err);
                    secformClient.logError("response.content = " + this.response.content);
                    throw new Exception("test15 failed.");
                }
                secformClient.trace("Good - we were not able to access restricted page without authenticating.");
            } else {
                secformClient.trace("response=null");
            }
            secformClient.logMessage("test15 passed.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test15 failed: ", e);
        }
    }

    public void test16() throws Exception {
        try {
            this.request = this.pageProgLogin;
            Properties postData = new Properties();
            secformClient.trace("setting request parameter my_username = " + this.username);
            secformClient.trace("setting request parameter my_password = " + this.password);
            postData.setProperty("the_username", this.username);
            postData.setProperty("the_password", this.password);
            secformClient.logMessage("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.trace("response.content = \n" + this.response.content);
            if (!this.response.statusToken.equals("200")) {
                secformClient.logError("ERROR:  not able to do Programmatic Login in: " + this.pageProgLogin);
                throw new Exception("test16 failed.");
            }
            if (this.response.isError()) {
                secformClient.logError("Error retrieving " + this.request);
                throw new Exception("test16 failed.");
            }
            secformClient.trace(this.response.content);
            String searchString = "ERROR - HttpServletRequest.login";
            if (this.response.content.indexOf(searchString) != -1) {
                secformClient.logError(this.response.content);
                throw new Exception("test16 failed.");
            }
            searchString = "HttpServletRequest.login() passed";
            if (this.response.content.indexOf(searchString) == -1) {
                secformClient.logError(this.response.content);
                throw new Exception("test16 failed.");
            }
            secformClient.logMessage("test16 passed.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test16 failed: ", e);
        }
    }

    public void test17() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageServletProgLogout, 1);
            this.request = this.pageSecurityCheck;
            secformClient.logMessage("Sending request \"" + this.request + "\" with login information.");
            Properties postData = new Properties();
            postData.setProperty("j_username", this.username);
            postData.setProperty("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.trace("response.content = " + this.response.content);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test17 failed.");
            }
            this.response = this.followRedirect(this.response, 17);
            secformClient.trace("response.content = " + this.response.content);
            String searchString = "enterred ServletProgrammaticLogout.service()";
            if (this.response.content.indexOf(searchString) == -1) {
                String str = "Error - Did not get expected content from page: " + this.pageServletProgLogout;
                str = str + "  Content should have contained: " + searchString;
                secformClient.logError(str);
                throw new Exception("test17 failed.");
            }
            String errString = "ERROR - HttpServletRequest.logout()";
            if (this.response.content.indexOf(errString) != -1) {
                String str = "Error - returned in content from page: " + this.pageServletProgLogout;
                secformClient.logError(str);
                throw new Exception("test17 failed.");
            }
            secformClient.logMessage("test17 passed.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test17 failed: ", e);
        }
    }

    public void test18() throws Exception {
        try {
            this.request = this.pageProgAuthen;
            Properties postData = new Properties();
            postData.setProperty("the_username", this.username);
            postData.setProperty("the_password", this.password);
            secformClient.logMessage("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(this.request), (Properties)postData, (Hashtable)this.cookies);
            secformClient.trace("YYYYY: response.content = \n" + this.response.content);
            if (!this.response.statusToken.equals("200")) {
                secformClient.logError("ERROR:  not able to do Programmatic Login in: " + this.pageProgLogin);
                throw new Exception("test18 failed.");
            }
            if (this.response.isError()) {
                secformClient.logError("Error retrieving " + this.request);
                throw new Exception("test18 failed.");
            }
            String searchString = "ERROR - HttpServletRequest.authenticate";
            if (this.response.content.indexOf(searchString) != -1) {
                secformClient.logError(this.response.content);
                throw new Exception("test18 failed.");
            }
            if (this.response.content.indexOf("HttpServletRequest.authenticate passed") == -1) {
                secformClient.logError(this.response.content);
                throw new Exception("test18 failed.");
            }
            secformClient.logMessage("test18 passed.");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception("test18 failed: ", e);
        }
    }

    public static WebUtil.Response uploadUsingHttpMethodPUT(String method, InetAddress addr, int port, String req, byte[] postData, Hashtable cookieList, String username, String password) throws IOException {
        String protocol = "HTTP/1.0";
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        WebUtil.Response response = new WebUtil.Response();
        try {
            int c;
            Enumeration keys;
            URL requestURL = new URL("http", addr.getHostName(), port, (String)req);
            req = method + " " + (String)req + " " + protocol;
            socket = new Socket(addr, port);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            out.println((String)req);
            if (cookieList != null && (keys = cookieList.keys()).hasMoreElements()) {
                Object cookieString = "Cookie: ";
                boolean first = true;
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)cookieList.get(key);
                    cookieString = (String)cookieString + (first ? "" : "; ") + key + "=" + value;
                    first = false;
                }
                out.println((String)cookieString);
            }
            if (username != null) {
                String code = WebUtil.encodeBase64((String)(username + ":" + password));
                out.println("Authorization: Basic " + code.trim());
            }
            if (postData != null) {
                out.println("Content-type: text/data");
            }
            StringBuffer content = new StringBuffer(1024);
            ByteArrayInputStream bais = new ByteArrayInputStream(postData);
            while ((c = bais.read()) != -1) {
                content.append((char)c);
            }
            String fileContents = content.toString();
            if (postData != null && method.toUpperCase().equals("PUT")) {
                String postString = WebUtil.encodeBase64((String)fileContents);
                out.println("Content-length: " + postString.length());
                out.println("");
                out.println(postString);
            } else {
                out.println("");
            }
            out.flush();
            String line = in.readLine();
            if (line != null) {
                StringTokenizer st = new StringTokenizer(line.trim());
                response.versionToken = st.nextToken();
                response.statusToken = st.nextToken();
            }
            while ((line = in.readLine()) != null && !line.trim().equals("")) {
                if (line.toLowerCase().startsWith("location:")) {
                    response.location = line.substring(10);
                    continue;
                }
                if (line.toLowerCase().startsWith("set-cookie:")) {
                    response.parseCookie(line);
                    continue;
                }
                if (!line.toLowerCase().startsWith("www-authenticate:")) continue;
                response.authenticationRequested = true;
            }
            while ((line = in.readLine()) != null) {
                response.content = response.content + line + "\n";
            }
            in.close();
            out.close();
        }
        catch (MalformedURLException e) {
            throw new IOException("MalformedURLException: " + e.getMessage());
        }
        catch (UnknownHostException e) {
            throw new IOException("UnknownHostException: " + e.getMessage());
        }
        catch (ConnectException e) {
            throw new IOException("ConnectException: " + e.getMessage());
        }
        return response;
    }

    private static void send(PrintWriter out, String s) {
        out.print(s + "\r\n");
    }

    private void requestAndGetLoginPage(String request, int testNum) throws Exception {
        secformClient.logMessage("Sending request \"" + request + "\"");
        this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(request), null, null);
        if (this.response.isError()) {
            secformClient.logError("Could not find " + request);
            throw new Exception("test" + testNum + " failed.");
        }
        if (this.response.statusToken.equals("302")) {
            if (this.response.location == null) {
                secformClient.logError("No redirection to login page received.");
                throw new Exception("test" + testNum + " failed.");
            }
            request = WebUtil.getRequestFromURL((String)this.response.location);
            secformClient.logMessage("Redirect to: " + this.response.location);
            this.cookies = this.response.cookies;
            secformClient.logMessage("Before requesting redirected Page:response.content=" + this.response.content);
            secformClient.logMessage("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)request, null, (Hashtable)this.cookies);
            if (this.response.isError()) {
                secformClient.logError("Could not find " + request);
                throw new Exception("test" + testNum + " failed.");
            }
        } else {
            this.cookies = this.response.cookies;
        }
    }

    private void compareURLContents(String testURL, int testNum, String exactMatchURL) throws Exception {
        secformClient.logMessage("Sending request \"" + testURL + "\"");
        this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(testURL), null, null);
        if (this.response.isError()) {
            secformClient.logError("Could not find " + testURL);
            throw new Exception("test" + testNum + " failed.");
        }
        WebUtil.Response response2 = null;
        secformClient.logMessage("Sending request \"" + exactMatchURL + "\"");
        response2 = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(exactMatchURL), null, null);
        if (this.response.isError()) {
            secformClient.logError("Could not find " + exactMatchURL);
            throw new Exception("test" + testNum + " failed.");
        }
        secformClient.logMessage("Comparing contents of " + testURL + " and " + exactMatchURL);
        if (!this.response.content.equals(response2.content)) {
            secformClient.logError("MISMATCH in contents of " + testURL + " and " + exactMatchURL);
            secformClient.logError("contents of " + testURL);
            secformClient.logError(this.response.content);
            secformClient.logError("contents of " + exactMatchURL);
            secformClient.logError(response2.content);
            throw new Exception("test" + testNum + " failed.");
        }
        secformClient.logMessage("Contents MATCH : correct URL mapping\n");
    }

    private boolean checkRoles(String content, Hashtable roleCheck) {
        Enumeration keys = roleCheck.keys();
        boolean pass = true;
        while (pass && keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            boolean expected = (Boolean)roleCheck.get(key);
            String search = "isUserInRole(\"" + key + "\"): !" + expected + "!";
            String logMsg = "Searching for \"" + search + "\": ";
            if (content.indexOf(search) == -1) {
                pass = false;
                logMsg = logMsg + "NOT FOUND!";
            } else {
                logMsg = logMsg + "found.";
            }
            secformClient.logMessage(logMsg);
        }
        return pass;
    }

    public void cleanup() throws Exception {
        secformClient.logMessage("cleanup");
    }

    public WebUtil.Response followRedirect(WebUtil.Response response, int testNum) throws Exception {
        if (response.statusToken.equals("301") || response.statusToken.equals("302")) {
            if (response.location == null) {
                secformClient.logError("redirection URL : null");
                throw new Exception("test" + testNum + " failed.");
            }
            this.request = WebUtil.getRequestFromURL((String)response.location);
            secformClient.logMessage("Redirect to: " + response.location);
            this.addNewCookies(this.cookies, response.cookies);
            secformClient.logMessage("Sending request \"" + this.request + "\"");
            response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, (Hashtable)this.cookies);
            this.addNewCookies(this.cookies, response.cookies);
            if (testNum != 7 && testNum != 8 && response.isError()) {
                secformClient.logError("Status Token " + response.statusToken);
                secformClient.logError("Could not find " + this.request);
                throw new Exception("test" + testNum + " failed.");
            }
        } else {
            this.addNewCookies(this.cookies, response.cookies);
        }
        return response;
    }

    public void addNewCookies(Hashtable oldCookies, Hashtable newCookies) {
        Enumeration e = newCookies.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)newCookies.get(name);
            if (oldCookies == null) {
                oldCookies = new Hashtable<String, String>();
            }
            oldCookies.put(name.trim(), value.trim());
        }
    }

    private void testStatusCodes(String request, List<String> expectedCodes, String testName) throws Exception {
        try {
            secformClient.logMessage("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.tsurl.getRequest(request), null, null);
            this.response = this.followRedirect(this.response, 7);
            if (!expectedCodes.contains(this.response.statusToken)) {
                secformClient.logError("Did not receive expected error code" + request);
                secformClient.logMessage("Status Token " + this.response.statusToken);
                secformClient.logError("Page content: ");
                secformClient.logError(this.response.content);
                throw new Exception(testName + " failed.");
            }
            secformClient.logMessage("Status Token " + this.response.statusToken);
            secformClient.logMessage("Received expected error code");
        }
        catch (Exception e) {
            secformClient.logError("Caught exception: " + e.getMessage());
            e.printStackTrace();
            throw new Exception(testName + " failed: ", e);
        }
    }

    private static void logMessage(String message) {
        logger.log(System.Logger.Level.INFO, CLASS_TRACE_HEADER + message);
    }

    private static void trace(String message) {
        logger.log(System.Logger.Level.TRACE, CLASS_TRACE_HEADER + message);
    }

    private static void logError(String message) {
        logger.log(System.Logger.Level.ERROR, CLASS_TRACE_HEADER + message);
    }
}

