/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.convert;

import ee.jakarta.tck.persistence.core.annotations.convert.CommaConverter;
import ee.jakarta.tck.persistence.core.annotations.convert.Country;
import ee.jakarta.tck.persistence.core.annotations.convert.SpaceConverter;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="CUST_TABLE")
@Access(value=AccessType.FIELD)
public class Customer
implements Serializable {
    @Id
    @Column(name="CUST_ID")
    private String id;
    @Convert(converter=SpaceConverter.class)
    @Column(name="NAME")
    private String name;
    @Embedded
    private Country country;
    @ElementCollection
    @CollectionTable(name="PHONES", joinColumns={@JoinColumn(name="ID")})
    @Column(name="PHONE_NUMBER")
    @Convert(converter=CommaConverter.class)
    private List<String> phones = new ArrayList<String>();

    public Customer() {
    }

    public Customer(String id) {
        this.id = id;
    }

    public Customer(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public Customer(String id, String name, Country country) {
        this.id = id;
        this.name = name;
        this.country = country;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String v) {
        this.id = v;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country v) {
        this.country = v;
    }

    public List<String> getPhones() {
        return this.phones;
    }

    public void setPhones(List<String> phones) {
        this.phones = phones;
    }

    public boolean equals(Object o) {
        boolean same = true;
        if (!(o instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)o;
        return same &= this.id.equals(other.id);
    }

    public int hashCode() {
        int myHash = this.id.hashCode();
        return myHash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + this.getId());
        if (this.getName() != null) {
            result.append(", name: " + this.getName());
        } else {
            result.append(", name: null");
        }
        if (this.getCountry() != null) {
            result.append(", country: " + String.valueOf(this.getCountry()));
        } else {
            result.append(", country: null");
        }
        if (this.phones.size() > 0) {
            int size = this.phones.size();
            result.append(", phones[");
            int i = 0;
            for (String s : this.phones) {
                result.append(s);
                if (++i >= size) continue;
                result.append(",");
            }
            result.append("]");
        } else {
            result.append(", phones: null");
        }
        result.append("]");
        return result.toString();
    }
}

