/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.language;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.HardwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.SoftwareProduct;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.Query;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Client4
extends Util {
    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupProductData")
    public void queryTest7() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Products");
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(P) From Product p where P.quantity < 10").getResultList();
            String[] expectedPKs = new String[]{"15", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest7 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest38() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing MOD with numeric Java object types");
            this.logTrace("find orders that have the quantity of 50 available");
            Integer value1 = 550;
            Integer value2 = 100;
            List p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(" + value1 + "," + value2 + ") = p.quantity").getResultList();
            String[] expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.logMsg("Testing MOD with primitive numeric type");
            this.logTrace("find orders that have the quantity of 50 available");
            p = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where MOD(550, 100) = p.quantity").getResultList();
            expectedPKs = new String[]{"5", "20"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest38 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest40() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute two queries composed differently and verify results Execute Query 1");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where p.quantity BETWEEN 10 AND 20").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            this.logTrace("Execute Query 2");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT OBJECT(p) From Product p where (p.quantity >= 10) AND (p.quantity <= 20)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "17", "27", "28", "31", "36"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                this.logErr("Did not get expected results for first query in queryTest40.   Expected 7 references, got: " + p1.size());
            } else {
                this.logTrace("Expected results received for first query in queryTest40.");
                pass1 = true;
            }
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                this.logErr("Did not get expected results for second query in queryTest40.   Expected 7 references, got: " + p2.size());
            } else {
                this.logTrace("Expected results received for second query in queryTest40.");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest40 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest41() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute two queries composed differently and verify results Execute first query");
            List p1 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where p.quantity NOT BETWEEN 20 AND 200").getResultList();
            String[] expectedPKs = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p1, expectedPKs)) {
                this.logErr("Did not get expected results for first query.  Expected 31 references, got: " + p1.size());
            } else {
                this.logTrace("Expected results received for first query");
                pass1 = true;
            }
            this.logTrace("Execute second query");
            List p2 = this.getEntityManager().createQuery("Select DISTINCT Object(p) From Product p where (p.quantity < 20) OR (p.quantity > 200)").getResultList();
            String[] expectedPKs2 = new String[]{"8", "9", "10", "11", "14", "15", "17", "21", "29", "31"};
            if (!this.checkEntityPK(p2, expectedPKs2)) {
                this.logErr("Did not get expected results for second query.  Expected 31 references, got: " + p2.size());
            } else {
                this.logTrace("Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest41 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest43() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Check results of AND operator: False AND False = False");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where (p.quantity > (500 + :int1)) AND (p.partNumber IS NULL)").setParameter("int1", (Object)100).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest43 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest44() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("provide a null value for a comparison operation and verify the results");
            List p = this.getEntityManager().createQuery("Select Distinct Object(p) from Product p where p.name = ?1").setParameter(1, null).getResultList();
            String[] expectedPKs = new String[]{};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 0 references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest44 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest68() throws Exception {
        boolean pass = false;
        Double d1 = 33387.14;
        Double d2 = 33387.15;
        try {
            this.logTrace("find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p");
            Double d3 = (Double)q.getSingleResult();
            if (d3 >= d1 && d3 < d2) {
                this.logTrace("Returned expected results: " + d1);
                pass = true;
            } else {
                this.logTrace("Returned " + d3 + "expected: " + d1);
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest68 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void queryTest70() throws Exception {
        boolean pass = false;
        Long expectedValue = 3277L;
        try {
            this.logTrace("find SUM of all product prices");
            Query q = this.getEntityManager().createQuery("SELECT Sum(p.quantity) FROM Product p");
            Long result = (Long)q.getSingleResult();
            if (expectedValue.equals(result)) {
                this.logTrace("Returned expected results: " + result);
                pass = true;
            } else {
                this.logTrace("Returned " + result + "expected: " + expectedValue);
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception queryTest70: ", e);
        }
        if (!pass) {
            throw new Exception("queryTest70 failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_betweenDates() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Date date1 = this.getSQLDate(2000, 2, 14);
            Date date6 = this.getSQLDate(2005, 2, 18);
            this.logTrace("The dates used in test_betweenDates is : " + String.valueOf(date1) + " and " + String.valueOf(date6));
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate BETWEEN :date1 AND :date6").setParameter("date1", (Object)date1).setParameter("date6", (Object)date6).getResultList();
            String[] expectedPKs = new String[]{"31", "32", "33", "37"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_betweenDates failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void test_notBetweenDates() throws Exception {
        boolean pass = false;
        Date date1 = this.getSQLDate("2000-02-14");
        Date newdate = this.getSQLDate("2005-02-17");
        this.logTrace("The dates used in test_betweenDates is : " + String.valueOf(date1) + " and " + String.valueOf(newdate));
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT DISTINCT p From Product p where p.shelfLife.soldDate NOT BETWEEN :date1 AND :newdate").setParameter("date1", (Object)date1).setParameter("newdate", (Object)newdate).getResultList();
            String[] expectedPKs = new String[]{"31"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        if (!pass) {
            throw new Exception("test_notBetweenDates failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void aggregateFunctionsWithNoValuesTest() throws Exception {
        Object o;
        Query q;
        boolean pass = false;
        try {
            this.logMsg("Testing SUM");
            this.logTrace("find SUM of all product prices");
            q = this.getEntityManager().createQuery("SELECT Sum(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                this.logTrace("Returned expected null results");
                pass = true;
            } else {
                this.logErr("Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.logMsg("Testing AVG");
            this.logTrace("find AVG of all product prices");
            q = this.getEntityManager().createQuery("SELECT AVG(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                this.logTrace("Returned expected null results");
                pass = true;
            } else {
                this.logErr("Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.logMsg("Testing MAX");
            this.logTrace("find MAX of all product prices");
            q = this.getEntityManager().createQuery("SELECT MAX(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                this.logTrace("Returned expected null results");
                pass = true;
            } else {
                this.logErr("Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.logMsg("Testing MIN");
            this.logTrace("find MIN of all product prices");
            q = this.getEntityManager().createQuery("SELECT MIN(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o == null) {
                this.logTrace("Returned expected null results");
                pass = true;
            } else {
                this.logErr("Returned " + o.toString() + ", instead of null");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.logMsg("Testing COUNT");
            this.logTrace("find COUNT of all product prices");
            q = this.getEntityManager().createQuery("SELECT COUNT(p.price) FROM Product p where p.id='9999' ");
            o = q.getSingleResult();
            if (o != null) {
                if (o instanceof Long) {
                    Long i = (Long)o;
                    if (i == 0L) {
                        this.logTrace("Returned expected 0 result");
                        pass = true;
                    }
                } else {
                    this.logErr("Did not get instance of Long");
                }
            } else {
                this.logErr("Received null instead of 0");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("aggregateFunctionsWithNoValuesTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void primaryKeyJoinColumnTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List actual = this.getEntityManager().createQuery("Select p from Product p where p.wareHouse = 'WH5'").getResultList();
            if (actual.size() == 1 && ((Product)actual.get(0)).getWareHouse().equals("WH5")) {
                this.logTrace("Expected results received:" + ((Product)actual.get(0)).getWareHouse());
                pass = true;
            } else {
                this.logErr("test returned: " + ((Product)actual.get(0)).getWareHouse() + ", expected: WH5");
                for (Product p : actual) {
                    this.logErr("**id=" + p.getId() + ", model=" + p.getWareHouse());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void typeTest() throws Exception {
        boolean pass = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        for (HardwareProduct p : this.hardwareRef) {
            expected.add(Integer.valueOf(p.getId()));
        }
        Collections.sort(expected);
        ArrayList<Integer> actual = new ArrayList<Integer>();
        this.getEntityTransaction().begin();
        List result = this.getEntityManager().createQuery("Select p from Product p where TYPE(p) = HardwareProduct").getResultList();
        for (HardwareProduct p : result) {
            actual.add(Integer.parseInt(p.getId()));
        }
        Collections.sort(actual);
        if (!this.checkEntityPK(actual, expected)) {
            this.logErr("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
        } else {
            this.logTrace("Expected results received");
            pass = true;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("primaryKeyJoinColumnTest  failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void entityTypeLiteralTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Products");
            List p = this.getEntityManager().createQuery("Select p From Product p where TYPE(p) in (SoftwareProduct)").getResultList();
            String[] expectedPKs = new String[this.softwareRef.length];
            int i = 0;
            for (SoftwareProduct sf : this.softwareRef) {
                expectedPKs[i++] = sf.getId();
            }
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass) {
            throw new Exception("entityTypeLiteralTest failed");
        }
    }

    @SetupMethod(name="setupProductData")
    public void scalarExpressionsTest() throws Exception {
        String[] expectedPKs;
        List p;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where ((p.quantity) + 10 < 25)").getResultList();
            expectedPKs = new String[]{"8", "9", "15", "17", "21"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Testing string expression:");
            p = this.getEntityManager().createQuery("Select p From Product p where (p.name like 'Java%')").getResultList();
            expectedPKs = new String[]{"1", "2", "20", "34"};
            if (!this.checkEntityPK(p, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + expectedPKs.length + " references, got: " + p.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("scalarExpressionsTest failed");
        }
    }
}

