/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.configuration.elevaluation;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final System.Logger logger = System.getLogger(URLClientIT.class.getName());
    @ArquillianResource
    @OperateOnDeployment(value="jsp_config_eleval23_web")
    public URL url2;

    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/configuration/elevaluation");
        this.setContextRoot("/jsp_config_eleval_web");
    }

    public void setup2() throws Exception {
        logger.log(System.Logger.Level.INFO, "setup2 method URLClientIT");
        if (this.url2 == null) {
            throw new Exception("[URLClientIT] The url was not injected");
        }
        String hostname = this.url2.getHost();
        String portnum = Integer.toString(this.url2.getPort());
        Assertions.assertFalse((boolean)this.isNullOrEmpty(hostname), (String)"[URLClientIT] 'webServerHost' was not set in the properties.");
        this._hostname = hostname.trim();
        Assertions.assertFalse((boolean)this.isNullOrEmpty(portnum), (String)"[URLClientIT] 'webServerPort' was not set in the properties.");
        this._port = Integer.parseInt(portnum.trim());
        logger.log(System.Logger.Level.INFO, "[URLClientIT] Test setup2 OK");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_eleval_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_eleval_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/compat13/ElCompatTest.jsp")), "compat13/ElCompatTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elconffalse/ElEvaluationTest.jsp")), "elconffalse/ElEvaluationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elconffalsex/ElEvaluationTest.jspx")), "elconffalsex/ElEvaluationTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elconftrue/ElEvaluationTest.jsp")), "elconftrue/ElEvaluationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elconftruex/ElEvaluationTest.jspx")), "elconftruex/ElEvaluationTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elpagefalse/ElEvaluationTest.jsp")), "elpagefalse/ElEvaluationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elpagefalsex/ElEvaluationTest.jspx")), "elpagefalsex/ElEvaluationTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elpagetrue/ElEvaluationTest.jsp")), "elpagetrue/ElEvaluationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elpagetruex/ElEvaluationTest.jspx")), "elpagetruex/ElEvaluationTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elunspec/ElEvaluationTest.jsp")), "elunspec/ElEvaluationTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/elunspecx/ElEvaluationTest.jspx")), "elunspecx/ElEvaluationTest.jspx");
        return archive;
    }

    @Deployment(testable=false, name="jsp_config_eleval23_web")
    public static WebArchive createDeployment23() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_config_eleval23_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_config_eleval23_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/compat13/ElCompatTest.jsp")), "ElCompatTest.jsp");
        return archive;
    }

    @Test
    public void elEvaluationUnspecifiedTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elunspec/ElEvaluationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elunspecx/ElEvaluationTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void elEvaluationConfigurationFalseTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elconffalse/ElEvaluationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elconffalsex/ElEvaluationTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void elEvaluationConfigurationTrueTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elconftrue/ElEvaluationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elconftruex/ElEvaluationTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "${testPassed}");
        this.invoke();
    }

    @Test
    public void elEvaluationPageDirectiveOverrideTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elpagetrue/ElEvaluationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elpagetruex/ElEvaluationTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elpagefalse/ElEvaluationTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval_web/elpagefalsex/ElEvaluationTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        this.invoke();
    }

    @Test
    public void elEvaluation23WebApplicationTest() throws Exception {
        this.setup2();
        TEST_PROPS.setProperty("request", "GET /jsp_config_eleval23_web/ElCompatTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "${testPassed}");
        this.invoke();
    }
}

