/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.srattributeevent;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import servlet.tck.common.util.StaticLog;

public final class SRAttributeListener
implements ServletRequestAttributeListener,
ServletContextListener {
    static ServletContext savedSC = null;

    public void contextInitialized(ServletContextEvent event) {
        savedSC = event.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
        StaticLog.add("AttributeAdded:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (!savedSC.equals((Object)sc)) {
            StaticLog.add("AttributeAdded: The context in the listener did not match the one initialized");
            StaticLog.add("AttributeAdded: initialized context=" + String.valueOf(savedSC));
            StaticLog.add("AttributeAdded: getServletContext returned context=" + String.valueOf(sc));
        }
        sc.setAttribute("testrequest", (Object)event.getServletRequest());
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        StaticLog.add("AttributeRemoved:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (!savedSC.equals((Object)sc)) {
            StaticLog.add("AttributeRemoved: The context in the listener did not match the one initialized");
            StaticLog.add("AttributeRemoved: initialized context=" + String.valueOf(savedSC));
            StaticLog.add("AttributeRemoved: getServletContext returned context=" + String.valueOf(sc));
        }
        sc.setAttribute("testrequest", (Object)event.getServletRequest());
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        StaticLog.add("AttributeReplaced:" + event.getName() + "," + String.valueOf(event.getValue()));
        ServletContext sc = event.getServletContext();
        if (!savedSC.equals((Object)sc)) {
            StaticLog.add("AttributeReplaced: The context in the listener did not match the one initialized");
            StaticLog.add("AttributeReplaced: initialized context=" + String.valueOf(savedSC));
            StaticLog.add("AttributeReplaced: getServletContext returned context=" + String.valueOf(sc));
        }
        sc.setAttribute("testrequest", (Object)event.getServletRequest());
    }
}

