/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.serverpush;

import java.net.Authenticator;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.InetAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.spec.serverpush.TestServlet;
import servlet.tck.spec.serverpush.TestServlet2;
import servlet.tck.spec.serverpush.TestServlet3;
import servlet.tck.spec.serverpush.TestServlet4;
import servlet.tck.spec.serverpush.TestServlet5;
import servlet.tck.spec.serverpush.TestServlet6;
import servlet.tck.spec.serverpush.TestServlet7;
import servlet.tck.util.WebUtil;

public class ServerPushTests
extends AbstractTckTest {
    public static boolean SUPPORT_HTTP_PUSH = Boolean.parseBoolean(System.getProperty("servlet.tck.support.http2Push", "true"));
    private String requestURI = null;
    private String hostname;
    private int portnum;
    private WebUtil.Response response = null;
    private String authUsername = "javajoe";
    private String authPassword = "javajoe";
    private CookieManager cm = new CookieManager();

    @BeforeEach
    public void setupServletName() throws Exception {
        this.setServletName("TestServlet");
    }

    @Deployment(testable=false)
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"servlet_spec_serverpush_web.war")).addAsWebResource("spec/serverpush/index.html")).addClasses(new Class[]{TestServlet.class, TestServlet2.class, TestServlet3.class, TestServlet4.class, TestServlet5.class, TestServlet6.class, TestServlet7.class})).setWebXML(ServerPushTests.class.getResource("servlet_spec_serverpush_web.xml"));
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.authUsername = p.getProperty("authuser");
        this.authPassword = p.getProperty("authpassword");
        this.hostname = p.getProperty("webServerHost");
        this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
        this.logger.debug("hostname:port:{}:{}", (Object)this.hostname, (Object)this.portnum);
    }

    @Test
    public void serverPushTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", "bar");
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, null);
        this.verifyResponses(responses, new String[]{"hello", "INDEX from index.html"});
    }

    @Test
    public void getNullPushBuilderTest() throws Exception {
        try {
            this.requestURI = this.getContextRoot() + "/TestServlet";
            this.logger.debug("Sending request {}", (Object)this.requestURI);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.getRequest(this.requestURI), null, null);
            this.logger.debug("response.statusToken: {}", (Object)this.response.statusToken);
            this.logger.debug("response.content: {}", (Object)this.response.content);
            if (this.response.isError()) {
                this.logger.error("Could not find {}", (Object)this.requestURI);
                throw new Exception("getNullPushBuilderTest failed.");
            }
            if (!this.response.content.contains("Get Null PushBuilder")) {
                throw new Exception("getNullPushBuilderTest failed.");
            }
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("getNullPushBuilderTest failed: ", e);
        }
    }

    @Test
    public void serverPushInitTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet2";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", "bar");
        headers.put("If-Match", "*");
        headers.put("Range", "bytes=100-");
        String authString = "Basic " + new String(Base64.getEncoder().encode((this.authUsername + ":" + this.authPassword).getBytes()));
        this.logger.debug("auth string: {}", (Object)authString);
        CookieManager cm = new CookieManager();
        headers.put("Authorization", authString);
        headers.put("Referer", this.requestURI + "/test");
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, cm);
        if (responses.size() != 1) {
            throw new Exception("Test fail");
        }
        String sessionid = responses.get(0).headers().allValues("set-cookie").stream().filter(value -> value.contains("JSESSIONID=")).findFirst().orElse(null);
        if (sessionid == null) {
            throw new Exception("Test fail: new session ID should be used as the PushBuilder's session ID.");
        }
        if ((sessionid = sessionid.substring(sessionid.indexOf("JSESSIONID=") + "JSESSIONID=".length())).indexOf(";") > 0) {
            sessionid = sessionid.substring(0, sessionid.indexOf(";"));
        } else if (sessionid.indexOf(".") > 0) {
            sessionid = sessionid.substring(0, sessionid.indexOf("."));
        }
        this.logger.debug("Sessionid in cookie: {}", (Object)sessionid);
        String response = responses.get(0).body();
        StringTokenizer token = new StringTokenizer(response, "\n");
        String newSessionId = "";
        while (token.hasMoreTokens()) {
            String tmp = token.nextToken();
            if (!tmp.startsWith("JSESSIONID:")) continue;
            newSessionId = tmp.substring("JSESSIONID:".length()).trim();
            break;
        }
        if (!sessionid.contains(newSessionId) && !newSessionId.contains(sessionid)) {
            throw new Exception("Test fail: new session ID should be used as the PushBuilder's session ID.");
        }
        if (!response.contains("Return new instance:true")) {
            throw new Exception("Test fail: each call to newPushBuilder() should create a new instance");
        }
        if (!response.contains("Method:GET")) {
            throw new Exception("Test fail: The method of PushBuilder should be initialized to \"GET\"");
        }
        if (!response.contains("foo=bar")) {
            throw new Exception("Test fail: The existing request headers of the current HttpServletRequest should be added to the builder");
        }
        if (response.contains("if-match")) {
            throw new Exception("Test fail: Conditional headers should NOT be added to the builder");
        }
        if (response.contains("range")) {
            throw new Exception("Test fail: Range headers should NOT be added to the builder");
        }
        if (!response.contains("authorization")) {
            throw new Exception("Test fail: Authorization headers should be added to the builder");
        }
        if (!response.contains("referer=" + this.requestURI)) {
            throw new Exception("Test fail: Referer headers should be set to " + this.requestURI);
        }
    }

    @Test
    public void serverPushSessionTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        try {
            this.requestURI = this.getContextRoot() + "/TestServlet3?generateSession=true";
            this.logger.debug("Sending request {}", (Object)this.requestURI);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.getRequest(this.requestURI), null, null);
            this.logger.debug("The new sessionid is : {}", (Object)this.response.content);
            if (this.response.isError()) {
                this.logger.error("Could not find {}", (Object)this.requestURI);
                throw new Exception("serverPushSessionTest failed.");
            }
            this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet3;jsessionid=" + this.response.content.trim();
            this.logger.debug("Sending request {}", (Object)this.requestURI);
            List<HttpResponse<String>> responses = this.sendRequest(new HashMap<String, String>(), null, null);
            String responseStr = responses.get(0).body();
            this.logger.debug("The test result : {}", (Object)responseStr);
            if (!responseStr.contains("Test success")) {
                throw new Exception("serverPushSessionTest failed.");
            }
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("serverPushSessionTest failed: ", e);
        }
    }

    @Test
    public void serverPushCookieTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet4";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", "bar");
        CookieManager cm = new CookieManager();
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, cm);
        this.verifyResponses(responses, new String[]{"add cookies [foo,bar] [baz,qux] [abc,123] to response", "INDEX from index.html"});
        boolean cookieExisted = false;
        String pbCookies = "";
        try {
            for (HttpResponse<String> r : responses) {
                if (!r.body().contains("Cookie header in PushBuilder: ")) continue;
                cookieExisted = true;
                pbCookies = r.body().substring(r.body().indexOf("Cookie header in PushBuilder: "));
                break;
            }
            if (!cookieExisted) {
                throw new Exception("Wrong Responses");
            }
            if (!pbCookies.contains("foo") || !pbCookies.contains("bar")) {
                throw new Exception("The Cookie header 'foo=bar' should be added to the PushBuilder.");
            }
            if (pbCookies.contains("baz") || pbCookies.contains("qux")) {
                throw new Exception("The maxAge for Cookie 'baz=qux' is == 0, it should be removed from the PushBuilder.");
            }
            if (!pbCookies.contains("abc") || !pbCookies.contains("123")) {
                throw new Exception("The maxAge for Cookie 'abc=123' is < 0, it should be added to the PushBuilder.");
            }
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("serverPushSessionTest failed: ", e);
        }
    }

    @Test
    public void serverPushSessionTest2() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet5";
        HashMap<String, String> headers = new HashMap<String, String>();
        CookieManager cm = new CookieManager();
        cm.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, cm);
        boolean pass = false;
        try {
            List<HttpCookie> cookies = cm.getCookieStore().get(new URI("http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/index.html"));
            for (HttpCookie httpCookie : cookies) {
                if (!"JSESSIONID".equals(httpCookie.getName())) continue;
                pass = true;
                break;
            }
            if (!pass) {
                for (HttpResponse httpResponse : responses) {
                    if (httpResponse.uri().toString().indexOf("index.html;jsessionid") <= 0) continue;
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("serverPushSessionTest failed: ", e);
        }
        if (!pass) {
            throw new Exception("If the builder has a session ID, then the pushed request should include the session ID either as a Cookie or as a URI parameter as appropriate");
        }
    }

    @Test
    public void serverPushMiscTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet6";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", "bar");
        headers.put("baz", "qux");
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, null);
        HttpResponse<String> pushResp = null;
        HttpRequest pushReq = null;
        for (HttpResponse<String> response : responses) {
            if (!response.uri().toString().contains("index.html")) continue;
            pushResp = response;
            pushReq = response.request();
        }
        if (pushResp == null) {
            throw new Exception("can not get push response");
        }
        this.logMsg("expected header: h1=v1, foo=v2; expected querysting: querystring=1&querystring=2");
        Map<String, List<String>> pushHeaders = pushReq.headers().map();
        this.logMsg("Current push request header: " + String.valueOf(pushHeaders));
        if (pushHeaders.get("h1") == null || !pushHeaders.get("h1").get(0).equals("v1")) {
            throw new Exception("test fail: could not find header h1=v1");
        }
        if (pushHeaders.get("foo") == null || !pushHeaders.get("foo").get(0).equals("v2")) {
            throw new Exception("test fail: could not find header foo=v2");
        }
        if (pushHeaders.get("baz") != null) {
            throw new Exception("test fail");
        }
        this.logMsg("Current query string of the push request is " + pushReq.uri().getQuery());
        if (pushReq.uri().getQuery() == null || !pushReq.uri().getQuery().contains("querystring=1&querystring=2")) {
            throw new Exception("test fail: could not find correct querystring \"querystring=1&querystring=2\"");
        }
    }

    @Test
    public void serverPushNegtiveTest() throws Exception {
        Assumptions.assumeTrue((boolean)SUPPORT_HTTP_PUSH);
        this.requestURI = "http://" + this.hostname + ":" + this.portnum + this.getContextRoot() + "/TestServlet7";
        HashMap<String, String> headers = new HashMap<String, String>();
        List<HttpResponse<String>> responses = this.sendRequest(headers, null, null);
        HttpResponse<String> servletResp = null;
        for (HttpResponse<String> response : responses) {
            if (!response.uri().toString().contains("TestServlet7")) continue;
            servletResp = response;
        }
        if (servletResp == null) {
            throw new Exception("can not get servlet response");
        }
        if (!((String)servletResp.body()).contains("test passed")) {
            throw new Exception("test fail");
        }
    }

    private List<HttpResponse<String>> sendRequest(Map<String, String> headers, Authenticator auth, CookieManager cm) throws Exception {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (auth != null) {
            builder.authenticator(auth);
        }
        if (cm != null) {
            builder.cookieHandler(cm);
        }
        HttpClient client = builder.version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.ALWAYS).executor(Executors.newFixedThreadPool(3)).build();
        CopyOnWriteArrayList<HttpResponse<String>> responses = new CopyOnWriteArrayList<HttpResponse<String>>();
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(new URI(this.requestURI)).version(HttpClient.Version.HTTP_2);
            headers.forEach(requestBuilder::header);
            CopyOnWriteArrayList futureResponses = new CopyOnWriteArrayList();
            HttpResponse.PushPromiseHandler pushPromiseHandler = (req, pushPromiseRequest, acceptor) -> futureResponses.add((CompletableFuture)acceptor.apply(HttpResponse.BodyHandlers.ofString()));
            ((CompletableFuture)client.sendAsync(requestBuilder.build(), HttpResponse.BodyHandlers.ofString(), pushPromiseHandler).thenAccept(responses::add)).get(Long.getLong("http2.timeout", 1L), TimeUnit.MINUTES);
            responses.addAll(futureResponses.stream().map(httpResponseCompletableFuture -> {
                try {
                    return (HttpResponse)httpResponseCompletableFuture.get(Long.getLong("http2.timeout", 1L), TimeUnit.MINUTES);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new Exception("Test fail", e);
        }
        return responses;
    }

    private void printResponse(HttpResponse<String> response) {
        this.logMsg("ResponseURI:     " + String.valueOf(response.uri()));
        this.logMsg("ResponseBody:     " + response.body());
        this.logMsg("HTTP-Version: " + String.valueOf((Object)response.version()));
        this.logMsg("Statuscode:   " + response.statusCode());
        this.logMsg("Header:");
        response.headers().map().forEach((header, values) -> this.logMsg("  " + header + " = " + values.stream().map(String::trim).reduce(String::concat).orElse("hallo")));
    }

    private void verifyResponses(List<HttpResponse<String>> responses, String[] expectedResponses) throws Exception {
        if (responses.size() == 0) {
            throw new Exception("No Responses, expected responses are " + Arrays.toString(expectedResponses));
        }
        if (responses.size() != expectedResponses.length) {
            throw new Exception("Wrong Responses, expected responses are " + Arrays.toString(expectedResponses));
        }
        for (String s : expectedResponses) {
            boolean found = false;
            for (HttpResponse<String> r : responses) {
                this.logMsg(r.body());
                if (!r.body().contains(s)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new Exception("Wrong Responses, expected responses are " + Arrays.toString(expectedResponses));
        }
    }
}

