/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ActionConstants implements Enumerator
{
    ABANDON(0, "abandon", "Abandon"),
    CHECKOUT(1, "checkout", "Checkout"),
    CHERRYPICK(2, "cherrypick", "Cherry-Pick"),
    DRAFT(3, "draft", "Draft ..."),
    FOLLOWUP(4, "followup", "Followup"),
    PUBLISH(5, "publish", "Publish"),
    REBASE(6, "rebase", "Rebase"),
    REFRESH(7, "refresh", "Refresh"),
    REPLY(8, "reply", "Reply ..."),
    RESTORE(9, "restore", "Restore"),
    REVERT(10, "revert", "Revert"),
    SUBMIT(11, "submit", "Submit"),
    TOPIC(12, "topic", "Topic");

    public static final int ABANDON_VALUE = 0;
    public static final int CHECKOUT_VALUE = 1;
    public static final int CHERRYPICK_VALUE = 2;
    public static final int DRAFT_VALUE = 3;
    public static final int FOLLOWUP_VALUE = 4;
    public static final int PUBLISH_VALUE = 5;
    public static final int REBASE_VALUE = 6;
    public static final int REFRESH_VALUE = 7;
    public static final int REPLY_VALUE = 8;
    public static final int RESTORE_VALUE = 9;
    public static final int REVERT_VALUE = 10;
    public static final int SUBMIT_VALUE = 11;
    public static final int TOPIC_VALUE = 12;
    private static final ActionConstants[] VALUES_ARRAY;
    public static final List<ActionConstants> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ActionConstants[]{ABANDON, CHECKOUT, CHERRYPICK, DRAFT, FOLLOWUP, PUBLISH, REBASE, REFRESH, REPLY, RESTORE, REVERT, SUBMIT, TOPIC};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ActionConstants get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionConstants result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionConstants getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionConstants result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ActionConstants get(int value) {
        switch (value) {
            case 0: {
                return ABANDON;
            }
            case 1: {
                return CHECKOUT;
            }
            case 2: {
                return CHERRYPICK;
            }
            case 3: {
                return DRAFT;
            }
            case 4: {
                return FOLLOWUP;
            }
            case 5: {
                return PUBLISH;
            }
            case 6: {
                return REBASE;
            }
            case 7: {
                return REFRESH;
            }
            case 8: {
                return REPLY;
            }
            case 9: {
                return RESTORE;
            }
            case 10: {
                return REVERT;
            }
            case 11: {
                return SUBMIT;
            }
            case 12: {
                return TOPIC;
            }
        }
        return null;
    }

    private ActionConstants(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

