/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.egerrit.internal.model.ReviewerInfo;
import org.eclipse.egerrit.internal.ui.table.model.ReviewersTableModel;
import org.eclipse.egerrit.internal.ui.table.provider.BaseTableLabelProvider;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class ReviewersTableLabelProvider
extends BaseTableLabelProvider {
    private static Display fDisplay = Display.getCurrent();
    private static final Color RED_COLOR = fDisplay.getSystemColor(3);
    private static final Color GREEN_COLOR = fDisplay.getSystemColor(6);
    private String[] dynamicName;
    private int defaultColumn = ReviewersTableModel.values().length;
    private int fValue;

    public ReviewersTableLabelProvider(IObservableMap[] iObservableMaps, String[] dynamicReviewersColumn) {
        super(iObservableMaps);
        this.dynamicName = dynamicReviewersColumn;
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof ReviewerInfo) {
            ReviewerInfo reviewerInfo = (ReviewerInfo)aObj;
            switch (aIndex) {
                case 0: {
                    if (reviewerInfo.isDeleteable()) {
                        return "x";
                    }
                    return "";
                }
                case 1: {
                    return super.getColumnText(aObj, aIndex);
                }
                case 2: {
                    return super.getColumnText(aObj, aIndex);
                }
            }
            String label = this.getColumnLabels(aIndex);
            if (reviewerInfo.getApprovals() != null && reviewerInfo.getApprovals().containsKey((Object)label)) {
                String tmp = (String)reviewerInfo.getApprovals().get((Object)label);
                if (tmp.trim().contains("0")) {
                    this.fValue = 0;
                } else {
                    this.fValue = Integer.valueOf(tmp);
                    String convert = this.fValue > 0 ? "+" : "";
                    convert = String.valueOf(convert) + StringConverter.asString((int)this.fValue);
                    return convert;
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public Color getForeground(Object aElement, int aColumnIndex) {
        if (aElement instanceof ReviewerInfo) {
            switch (aColumnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    if (this.fValue < 0) {
                        return RED_COLOR;
                    }
                    if (this.fValue <= 0) break;
                    return GREEN_COLOR;
                }
            }
        }
        return null;
    }

    private String getColumnLabels(int column) {
        int val = column - this.defaultColumn;
        if (val >= 0) {
            return this.dynamicName[val];
        }
        return "";
    }
}

