/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.model;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.commands.table.AdjustMyStarredHandler;
import org.eclipse.egerrit.internal.dashboard.ui.model.ModifiedModelItemProviderAdapterFactory;
import org.eclipse.egerrit.internal.dashboard.ui.model.ReviewTableDefinition;
import org.eclipse.egerrit.internal.dashboard.ui.model.ReviewTableSorter;
import org.eclipse.egerrit.internal.dashboard.ui.utils.UIUtils;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIReviewTable {
    private static final String DASHBOARD_CONTEXT_MENU = "org.eclipse.egerrit.dashboard.contextMenu";
    private static final String EGERRIT_DASHBOARD = "egerrit.dashboard";
    private static final String VIEW_COLUMN_ORDER = "egerritViewColumnOrder";
    private static final String VIEW_COLUMN_WIDTH = "egerritViewColumnWidth";
    private static Logger logger = LoggerFactory.getLogger(UIReviewTable.class);
    private static final int TABLE_STYLE = 66304;
    private TableViewer fViewer;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryLabelProvider.ColorProvider labelProvider;
    private AdapterFactoryContentProvider contentProvider;
    private int defaultColumn = ReviewTableDefinition.values().length;
    private String[] voteColumns;
    private final Listener mouseButtonListener = aEvent -> {
        logger.debug("mouseButtonListener() for " + aEvent.button);
        switch (aEvent.type) {
            case 3: {
                Point p;
                ViewerCell viewerCell;
                if (aEvent.button == 1 && (viewerCell = this.fViewer.getCell(p = new Point(aEvent.x, aEvent.y))) != null && viewerCell.getColumnIndex() == ReviewTableDefinition.STARRED.ordinal()) {
                    AdjustMyStarredHandler handler = new AdjustMyStarredHandler();
                    try {
                        handler.execute(new ExecutionEvent());
                    }
                    catch (ExecutionException excutionException) {
                        logger.error(excutionException.getMessage());
                    }
                }
                int cfr_ignored_0 = aEvent.button;
                int cfr_ignored_1 = aEvent.button;
                break;
            }
        }
    };

    public Composite createTableViewerSection(Composite aParent, String[] voteColumns) {
        this.voteColumns = voteColumns;
        Composite viewerForm = new Composite(aParent, 2064);
        viewerForm.setLayout((Layout)new FillLayout());
        this.fViewer = new TableViewer(viewerForm, 66304);
        this.fViewer = this.buildAndLayoutTable(this.fViewer);
        this.fViewer.getTable().addDisposeListener(e -> this.storeColumnsSettings());
        this.fViewer.getTable().addListener(3, this.mouseButtonListener);
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ModifiedModelItemProviderAdapterFactory(voteColumns));
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.fViewer.setContentProvider((IContentProvider)this.contentProvider);
        if (voteColumns != null) {
            this.setLabelProvider(voteColumns);
        }
        return viewerForm;
    }

    private void setLabelProvider(String[] voteColumns) {
        String[] stringArray = voteColumns;
        int n = voteColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            this.createTableViewerLabelColumn(this.getAcronymLabel(column));
            ++n2;
        }
        ReviewTableSorter.bind(this.fViewer);
        this.fViewer.setComparator((ViewerComparator)new ReviewTableSorter(7));
        this.labelProvider = new AdapterFactoryLabelProvider.ColorProvider((AdapterFactory)this.adapterFactory, null, null);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.restoreColumnsSettings();
    }

    private String getAcronymLabel(String label) {
        String ret = "";
        if (!label.isEmpty()) {
            String[] arraySt;
            String[] stringArray = arraySt = label.split("-");
            int n = arraySt.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                ret = ret.concat(s.substring(0, 1));
                ++n2;
            }
        }
        return ret;
    }

    private TableViewer buildAndLayoutTable(TableViewer aViewer) {
        Table table = aViewer.getTable();
        ReviewTableDefinition[] tableInfo = ReviewTableDefinition.values();
        int size = tableInfo.length;
        logger.debug("Table\tName\tWidth\tResize Moveable");
        int index = 0;
        while (index < size) {
            logger.debug("index [ " + index + " ] " + tableInfo[index].getName() + "\t: " + tableInfo[index].getWidth() + "\t: " + tableInfo[index].getResize() + "\t: " + tableInfo[index].getMoveable());
            this.createTableViewerColumn(tableInfo[index]);
            ++index;
        }
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        this.handleTooltipNotOnWindow(aViewer, table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        MenuManager menuManager = new MenuManager();
        Menu contextMenu = menuManager.createContextMenu((Control)table);
        table.setMenu(contextMenu);
        GerritTableView.getActiveView(true).getSite().registerContextMenu(DASHBOARD_CONTEXT_MENU, menuManager, (ISelectionProvider)aViewer);
        return aViewer;
    }

    private void handleTooltipNotOnWindow(TableViewer aViewer, Table table) {
        String os = Platform.getOS();
        if (!"win32".equals(os)) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ToolTip tip = new ToolTip(shell, 2);
            table.addListener(5, event -> tip.setVisible(false));
            table.addListener(32, event -> {
                ViewerCell viewerCell = UIUtils.getAdjustedViewerCell(event, aViewer);
                if (viewerCell != null) {
                    String message = "";
                    int columnIndex = viewerCell.getColumnIndex();
                    message = this.adjustSubjectTooltip(viewerCell, columnIndex);
                    TableItem item = (TableItem)viewerCell.getViewerRow().getItem();
                    Rectangle rect = item.getBounds(columnIndex);
                    if (message.isEmpty()) {
                        message = item.getText(columnIndex);
                    }
                    tip.setMessage(message);
                    Point displayPos = item.getParent().toDisplay(rect.x, rect.y);
                    tip.setLocation(displayPos.x, displayPos.y);
                    tip.setVisible(true);
                }
            });
        }
    }

    private String adjustSubjectTooltip(ViewerCell viewerCell, int columnIndex) {
        Object obj;
        String message = "";
        if (columnIndex == ReviewTableDefinition.SUBJECT.ordinal() && (obj = viewerCell.getElement()) instanceof ChangeInfo) {
            ChangeInfo changeInfo = (ChangeInfo)obj;
            message = changeInfo.getRevision() != null ? changeInfo.getRevision().getCommit().getMessage() : "";
        }
        return message;
    }

    private TableViewerColumn createTableViewerColumn(ReviewTableDefinition aTableInfo) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(aTableInfo.getName());
        column.setWidth(aTableInfo.getWidth());
        column.setAlignment(aTableInfo.getAlignment());
        column.setResizable(aTableInfo.getResize());
        column.setMoveable(aTableInfo.getMoveable());
        return viewerColumn;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    public void dispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
    }

    private void storeColumnsSettings() {
        if (this.fViewer == null) {
            return;
        }
        int[] columnOrder = this.fViewer.getTable().getColumnOrder();
        if (columnOrder.length == ReviewTableDefinition.values().length) {
            return;
        }
        int colInTable = this.fViewer.getTable().getColumnCount();
        int[] columnWidth = new int[colInTable];
        int i2 = 0;
        while (i2 < colInTable) {
            columnWidth[i2] = this.fViewer.getTable().getColumn(i2).getWidth();
            ++i2;
        }
        this.getDialogSettings().put(VIEW_COLUMN_ORDER, (String[])Arrays.stream(columnOrder).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
        this.getDialogSettings().put(VIEW_COLUMN_WIDTH, (String[])Arrays.stream(columnWidth).mapToObj(i -> String.valueOf(i)).toArray(String[]::new));
    }

    private void restoreColumnsSettings() {
        if (this.fViewer == null) {
            return;
        }
        String[] backedUpValue = this.getDialogSettings().getArray(VIEW_COLUMN_ORDER);
        if (backedUpValue == null) {
            return;
        }
        int[] columnOrderStored = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
        int columInTable = this.fViewer.getTable().getColumnCount();
        if (columInTable == ReviewTableDefinition.values().length) {
            return;
        }
        int[] oldvalue = new int[columInTable];
        int i = 0;
        while (i < columInTable) {
            int width;
            oldvalue[i] = width = this.fViewer.getTable().getColumn(i).getWidth();
            ++i;
        }
        int lastStoredColumnSize = columnOrderStored.length;
        int[] nextTableColumn = new int[columInTable];
        if (columInTable < columnOrderStored.length) {
            System.arraycopy(columnOrderStored, 0, nextTableColumn, 0, columInTable);
        } else {
            System.arraycopy(columnOrderStored, 0, nextTableColumn, 0, columnOrderStored.length);
            int i2 = lastStoredColumnSize;
            while (i2 < nextTableColumn.length) {
                nextTableColumn[i2] = i2;
                ++i2;
            }
        }
        int nextColumSize = nextTableColumn.length;
        int numberColumnToMove = 0;
        int i3 = 0;
        while (i3 < nextColumSize) {
            if (nextTableColumn[i3] >= nextColumSize) {
                System.arraycopy(columnOrderStored, i3 + ++numberColumnToMove, nextTableColumn, i3, nextColumSize - i3);
                --i3;
            }
            ++i3;
        }
        this.fViewer.getTable().setColumnOrder(nextTableColumn);
        this.restoreColumnWidth(columnOrderStored, columInTable, oldvalue, lastStoredColumnSize - 1, nextTableColumn);
    }

    private void restoreColumnWidth(int[] columnOrderStored, int columInTable, int[] oldvalue, int lastStoredColumnSize, int[] nextTableColumn) {
        int i;
        String[] backedUpValue = this.getDialogSettings().getArray(VIEW_COLUMN_WIDTH);
        if (backedUpValue == null) {
            return;
        }
        int[] columnWidth = Arrays.stream(backedUpValue).mapToInt(Integer::parseInt).toArray();
        int totalSize = 0;
        if (columInTable < columnWidth.length) {
            System.arraycopy(columnWidth, 0, nextTableColumn, 0, columInTable);
        } else {
            System.arraycopy(columnWidth, 0, nextTableColumn, 0, columnWidth.length);
            i = columnWidth.length;
            while (i < nextTableColumn.length) {
                nextTableColumn[i] = oldvalue[i];
                ++i;
            }
        }
        i = 0;
        while (i < nextTableColumn.length) {
            totalSize += nextTableColumn[i];
            this.fViewer.getTable().getColumn(i).setWidth(nextTableColumn[i]);
            ++i;
        }
        if (totalSize <= 50) {
            this.resetDefault();
        }
        if (lastStoredColumnSize < this.fViewer.getTable().getColumnCount()) {
            int defaultWidth = oldvalue[lastStoredColumnSize];
            int testCol = columnOrderStored[lastStoredColumnSize];
            if (testCol < ReviewTableDefinition.values().length) {
                defaultWidth = ReviewTableDefinition.values()[testCol].getWidth();
            }
            this.fViewer.getTable().getColumn(testCol).setWidth(defaultWidth);
        }
    }

    public void resetDefault() {
        Table table = this.fViewer.getTable();
        ReviewTableDefinition[] tableInfo = ReviewTableDefinition.values();
        int defaultLength = tableInfo.length;
        int colInTable = table.getColumnCount();
        int[] newOrder = new int[colInTable];
        int i = 0;
        while (i < colInTable) {
            newOrder[i] = i;
            ++i;
        }
        table.setColumnOrder(newOrder);
        i = 0;
        while (i < defaultLength) {
            table.getColumn(i).setWidth(tableInfo[i].getWidth());
            ++i;
        }
        i = defaultLength;
        while (i < colInTable) {
            table.getColumn(i).pack();
            ++i;
        }
        this.storeColumnsSettings();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = GerritUi.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(EGERRIT_DASHBOARD);
        if (section == null) {
            section = settings.addNewSection(EGERRIT_DASHBOARD);
        }
        return section;
    }

    private void createTableViewerLabelColumn(String label) {
        int width = 28 + 5 * label.length();
        TableViewerColumn viewerColumn = new TableViewerColumn(this.fViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(label);
        column.setWidth(width);
        column.setAlignment(16384);
        column.setResizable(true);
        column.setMoveable(true);
    }

    public String getColumnLabel(int column) {
        int val = column - this.defaultColumn;
        if (val >= 0) {
            return this.voteColumns[val];
        }
        return "";
    }
}

