/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.workspace;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.workspace.EGFChangedSynchRequest;
import org.eclipse.egf.core.workspace.EGFDeletedSynchRequest;
import org.eclipse.egf.core.workspace.EGFMovedSynchRequest;
import org.eclipse.egf.core.workspace.EGFPersistedSynchRequest;
import org.eclipse.egf.core.workspace.EGFSynchRequest;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EGFWorkspaceSynchronizer {
    private final TransactionalEditingDomain domain;
    private Delegate delegate;
    private static Collection<EGFWorkspaceSynchronizer> synchronizers = new ArrayList<EGFWorkspaceSynchronizer>();
    private static IResourceChangeListener workspaceListener = new WorkspaceListener();
    static Delegate defaultDelegate = new DefaultDelegate();

    public EGFWorkspaceSynchronizer(TransactionalEditingDomain domain) {
        this(domain, null);
    }

    public EGFWorkspaceSynchronizer(TransactionalEditingDomain domain, Delegate delegate) {
        if (domain == null) {
            throw new IllegalArgumentException("null domain");
        }
        if (delegate == null) {
            delegate = defaultDelegate;
        }
        this.domain = domain;
        this.delegate = delegate;
        EGFWorkspaceSynchronizer.startListening(this);
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    Delegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EGFWorkspaceSynchronizer.stopListening(this);
        EGFWorkspaceSynchronizer eGFWorkspaceSynchronizer = this;
        synchronized (eGFWorkspaceSynchronizer) {
            if (!this.isDisposed()) {
                this.delegate.dispose();
                this.delegate = null;
            }
        }
    }

    boolean isDisposed() {
        return this.delegate == null;
    }

    void processDelta(IResourceDelta delta, List<EGFSynchRequest> synchRequests, List<IProject> affectedProjects) {
        URI encodedURI;
        String fullPath = delta.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)fullPath, (boolean)false);
        ResourceSet rset = this.getEditingDomain().getResourceSet();
        Resource resource = rset.getResource(uri, false);
        if (resource == null && !(encodedURI = URI.createPlatformResourceURI((String)fullPath, (boolean)true)).equals((Object)uri) && (resource = rset.getResource(encodedURI, false)) != null) {
            uri = encodedURI;
        }
        if (resource != null && resource.isLoaded()) {
            IProject project = ((IFile)delta.getResource()).getProject();
            switch (delta.getKind()) {
                case 1: {
                    if ((delta.getFlags() & 0x1000) != 0) {
                        affectedProjects.add(project);
                        break;
                    }
                    synchRequests.add(new EGFPersistedSynchRequest(this, resource));
                    affectedProjects.add(project);
                    break;
                }
                case 2: {
                    if ((delta.getFlags() & 0x2000) != 0) {
                        URI newEncodedURI;
                        String newPath = delta.getMovedToPath().toString();
                        URI newURI = URI.createPlatformPluginURI((String)newPath, (boolean)false);
                        if (rset.getResource(newURI, false) == null && !(newEncodedURI = URI.createPlatformPluginURI((String)newPath, (boolean)true)).equals((Object)newURI) && rset.getResource(newURI, false) != null) {
                            newURI = newEncodedURI;
                        }
                        synchRequests.add(new EGFMovedSynchRequest(this, resource, newURI));
                        break;
                    }
                    synchRequests.add(new EGFDeletedSynchRequest(this, resource));
                    break;
                }
                case 4: {
                    if ((delta.getFlags() & 0x100) == 0) break;
                    synchRequests.add(new EGFChangedSynchRequest(this, resource));
                    affectedProjects.add(project);
                }
            }
        }
    }

    public static IFile getFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return EGFWorkspaceSynchronizer.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, false);
    }

    public static IFile getUnderlyingFile(Resource resource) {
        ResourceSet rset = resource.getResourceSet();
        return EGFWorkspaceSynchronizer.getFile(resource.getURI(), rset != null ? rset.getURIConverter() : null, true);
    }

    private static IFile getFile(URI uri, URIConverter converter, boolean considerArchives) {
        URI normalized;
        IFile result = null;
        if (considerArchives && uri.isArchive()) {
            class MyArchiveURLConnection
            extends ArchiveURLConnection {
                public MyArchiveURLConnection(String url) {
                    super(url);
                }

                public String getNestedURI() {
                    try {
                        return this.getNestedURL();
                    }
                    catch (IOException exception) {
                        return "";
                    }
                }
            }
            MyArchiveURLConnection archiveURLConnection = new MyArchiveURLConnection(uri.toString());
            result = EGFWorkspaceSynchronizer.getFile(URI.createURI((String)archiveURLConnection.getNestedURI()), converter, considerArchives);
        } else if (uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (converter != null && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            result = EGFWorkspaceSynchronizer.getFile(normalized, converter, considerArchives);
        }
        if (result == null && !uri.isRelative()) {
            try {
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new java.net.URI(uri.toString()));
                if (files.length > 0) {
                    result = files[0];
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startListening(EGFWorkspaceSynchronizer synchronizer) {
        Collection<EGFWorkspaceSynchronizer> collection = synchronizers;
        synchronized (collection) {
            ArrayList<EGFWorkspaceSynchronizer> newList = new ArrayList<EGFWorkspaceSynchronizer>(synchronizers.size() + 1);
            newList.addAll(synchronizers);
            newList.add(synchronizer);
            synchronizers = newList;
            ResourcesPlugin.getWorkspace().addResourceChangeListener(workspaceListener, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopListening(EGFWorkspaceSynchronizer synchronizer) {
        Collection<EGFWorkspaceSynchronizer> collection = synchronizers;
        synchronized (collection) {
            ArrayList<EGFWorkspaceSynchronizer> newList = new ArrayList<EGFWorkspaceSynchronizer>(synchronizers);
            newList.remove(synchronizer);
            synchronizers = newList;
            if (synchronizers.isEmpty()) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(workspaceListener);
            }
        }
    }

    static Collection<EGFWorkspaceSynchronizer> getSynchronizers() {
        return synchronizers;
    }

    private static class DefaultDelegate
    implements Delegate {
        private DefaultDelegate() {
        }

        public boolean handleResourcePersisted(Resource resource) {
            return true;
        }

        public boolean handleResourceDeleted(Resource resource) {
            resource.unload();
            return true;
        }

        public boolean handleResourceMoved(Resource resource, URI newURI) {
            resource.unload();
            return true;
        }

        public boolean handleResourceChanged(Resource resource) {
            resource.unload();
            try {
                resource.load(resource.getResourceSet().getLoadOptions());
            }
            catch (IOException e) {
                EGFCorePlugin.getDefault().logError(e);
            }
            return true;
        }

        public void dispose() {
        }
    }

    public static interface Delegate {
        public boolean handleResourcePersisted(Resource var1);

        public boolean handleResourceDeleted(Resource var1);

        public boolean handleResourceMoved(Resource var1, URI var2);

        public boolean handleResourceChanged(Resource var1);

        public void dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceSynchJob
    extends WorkspaceJob {
        private final List<EGFSynchRequest> synchRequests;

        ResourceSynchJob(List<EGFSynchRequest> synchRequests, List<IProject> affectedProjects) {
            super(EGFCoreMessages.synchJobName);
            this.synchRequests = synchRequests;
            this.setRule(ProjectHelper.getRule(affectedProjects));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInWorkspace(IProgressMonitor monitor) {
            try {
                for (EGFSynchRequest next : this.synchRequests) {
                    try {
                        Object object = next.getLock();
                        synchronized (object) {
                            if (!next.isDisposed()) {
                                next.perform();
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        EGFCorePlugin.getDefault().logError(e);
                    }
                }
            }
            catch (InterruptedException e) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                final ArrayList<EGFSynchRequest> synchRequests = new ArrayList<EGFSynchRequest>();
                UniqueEList affectedProjects = new UniqueEList();
                delta.accept(new IResourceDeltaVisitor((List)affectedProjects){
                    private final /* synthetic */ List val$affectedProjects;
                    {
                        this.val$affectedProjects = list2;
                    }

                    public boolean visit(IResourceDelta innerDelta) {
                        if (innerDelta.getResource().getType() == 4 && (innerDelta.getFlags() & 0x4000) != 0) {
                            return false;
                        }
                        if (innerDelta.getResource().getType() != 1) {
                            return true;
                        }
                        if (innerDelta.getResource().getType() == 1) {
                            switch (innerDelta.getKind()) {
                                case 4: {
                                    if (innerDelta.getFlags() == 131072) break;
                                }
                                case 1: 
                                case 2: {
                                    if (!EGFCorePlugin.FCORE_FILE_EXTENSION.equals(innerDelta.getResource().getFileExtension())) break;
                                    WorkspaceListener.this.processDelta(innerDelta, synchRequests, this.val$affectedProjects);
                                }
                            }
                        }
                        return true;
                    }
                });
                if (!synchRequests.isEmpty()) {
                    new ResourceSynchJob(synchRequests, (List<IProject>)affectedProjects).schedule();
                }
            }
            catch (CoreException e) {
                EGFCorePlugin.getDefault().logError(e);
            }
        }

        private void processDelta(IResourceDelta delta, List<EGFSynchRequest> synchRequests, List<IProject> affectedProjects) {
            for (EGFWorkspaceSynchronizer next : EGFWorkspaceSynchronizer.getSynchronizers()) {
                next.processDelta(delta, synchRequests, affectedProjects);
            }
        }
    }
}

